/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.knopflerfish.framework.BundleURLConnection;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.PermissionOps;

public class BundleURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "bundle";
    public static final String PERM_OK = "P";
    private Bundles bundles;
    private PermissionOps secure;

    BundleURLStreamHandler(Bundles b, PermissionOps s) {
        this.bundles = b;
        this.secure = s;
    }

    public URLConnection openConnection(URL u) {
        if (u.getAuthority() != PERM_OK) {
            this.secure.checkResourceAdminPerm(this.bundles.getBundle(this.getId(u.getHost())));
        }
        return new BundleURLConnection(u, this.bundles);
    }

    protected void parseURL(URL u, String s, int start, int limit) {
        int cpElem;
        long id;
        String host;
        String path;
        block24: {
            int pstart;
            path = u.getPath();
            host = u.getHost();
            id = -1L;
            cpElem = u.getPort();
            if (limit <= start) break block24;
            int len = limit - start;
            char[] sc = new char[len];
            s.getChars(start, limit, sc, 0);
            int pos = 0;
            if (len >= 2 && sc[0] == '/' && sc[1] == '/') {
                for (pos = 2; pos < len && sc[pos] != ':' && sc[pos] != '/'; ++pos) {
                    if (sc[pos] == '.' || sc[pos] == '_') {
                        if (id != -1L) continue;
                        id = Long.parseLong(new String(sc, 2, pos - 2));
                        continue;
                    }
                    if (Character.isDigit(sc[pos])) continue;
                    throw new IllegalArgumentException("Illegal chars in bundle id specification");
                }
                host = new String(sc, 2, pos - 2);
                if (pos < len && sc[pos] == ':') {
                    ++pos;
                    cpElem = 0;
                    while (pos < len && sc[pos] != '/') {
                        if (!Character.isDigit(sc[pos])) {
                            throw new IllegalArgumentException("Illegal chars in bundle port specification");
                        }
                        cpElem = 10 * cpElem + (sc[pos++] - 48);
                    }
                } else {
                    cpElem = -1;
                }
            }
            if (pos >= len) break block24;
            if (sc[pos] != '/') {
                if (path != null) {
                    int dirend = path.lastIndexOf(47) + 1;
                    if (dirend > 0) {
                        int plen = len - pos;
                        pstart = path.startsWith("/") ? 0 : 1;
                        if ((len = dirend + plen + pstart) > sc.length) {
                            char[] newsc = new char[len];
                            System.arraycopy(sc, pos, newsc, dirend + pstart, plen);
                            sc = newsc;
                        } else if (pos != dirend) {
                            System.arraycopy(sc, pos, sc, dirend + pstart, plen);
                        }
                        path.getChars(1 - pstart, dirend, sc, 1);
                    } else {
                        len = 1;
                    }
                } else {
                    len = 1;
                }
                sc[0] = 47;
                pstart = 0;
                pos = 0;
            } else {
                pstart = pos;
            }
            int dots = 0;
            int ipos = pstart - 1;
            boolean slash = false;
            while (pos < len) {
                block26: {
                    block28: {
                        block29: {
                            block30: {
                                block25: {
                                    block27: {
                                        if (sc[pos] != '/') break block25;
                                        if (slash) break block26;
                                        slash = true;
                                        if (dots != 1) break block27;
                                        dots = 0;
                                        break block26;
                                    }
                                    if (dots == 2) {
                                        while (ipos > pstart && sc[--ipos] != '/') {
                                        }
                                    }
                                    break block28;
                                }
                                if (sc[pos] != '.') break block29;
                                if (!slash) break block30;
                                dots = 1;
                                slash = false;
                                break block26;
                            }
                            if (dots != 1) break block28;
                            dots = 2;
                            break block26;
                        }
                        slash = false;
                    }
                    while (dots-- > 0) {
                        sc[++ipos] = 46;
                    }
                    if (++ipos != pos) {
                        sc[ipos] = sc[pos];
                    }
                }
                ++pos;
            }
            if (dots == 2) {
                while (ipos > pstart && sc[--ipos] != '/') {
                }
            }
            path = new String(sc, pstart, ipos - pstart + 1);
        }
        if (id == -1L) {
            id = this.getId(host);
        }
        this.secure.checkResourceAdminPerm(this.bundles.getBundle(id));
        this.setURL(u, u.getProtocol(), host, cpElem, PERM_OK, null, path, null, null);
    }

    protected boolean equals(URL u1, URL u2) {
        return this.sameFile(u1, u2);
    }

    protected int hashCode(URL u) {
        int h = 0;
        if (PROTOCOL.equals(u.getProtocol())) {
            String file;
            String host = u.getHost();
            if (host != null) {
                h = host.hashCode();
            }
            if ((file = u.getFile()) != null) {
                h += file.hashCode();
            }
            h += u.getPort();
        } else {
            h = u.hashCode();
        }
        return h;
    }

    protected boolean sameFile(URL u1, URL u2) {
        String p1 = u1.getProtocol();
        if (PROTOCOL.equals(p1)) {
            if (!p1.equals(u2.getProtocol())) {
                return false;
            }
            if (!this.hostsEqual(u1, u2)) {
                return false;
            }
            if (!(u1.getFile() == u2.getFile() || u1.getFile() != null && u1.getFile().equals(u2.getFile()))) {
                return false;
            }
            return u1.getPort() == u2.getPort();
        }
        return u1.equals(u2);
    }

    protected boolean hostsEqual(URL u1, URL u2) {
        String s2;
        String s1 = u1.getHost();
        return s1 == (s2 = u2.getHost()) || s1 != null && s1.equals(s2);
    }

    protected String toExternalForm(URL url) {
        StringBuffer res = new StringBuffer(url.getProtocol());
        res.append("://");
        res.append(url.getHost());
        int port = url.getPort();
        if (port >= 0) {
            res.append(":").append(port);
        }
        res.append(url.getPath());
        return res.toString();
    }

    protected synchronized InetAddress getHostAddress(URL url) {
        return null;
    }

    private long getId(String host) {
        int i = host.indexOf(".");
        if (i == -1) {
            i = host.indexOf("_");
        }
        if (i >= 0) {
            host = host.substring(0, i);
        }
        return Long.parseLong(host);
    }
}

