/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class Bundles {
    private Hashtable bundles = new Hashtable();
    private Framework framework;

    Bundles(Framework fw) {
        this.framework = fw;
        this.bundles.put(fw.systemBundle.location, fw.systemBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl install(String location, InputStream in) throws BundleException {
        BundleImpl b;
        Bundles bundles = this;
        synchronized (bundles) {
            b = (BundleImpl)this.bundles.get(location);
            if (b != null) {
                return b;
            }
            b = this.framework.perm.callInstall0(this, location, in);
        }
        this.framework.listeners.bundleChanged(new BundleEvent(1, b));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl install0(String location, InputStream in, Object checkContext) throws BundleException {
        BundleArchive ba = null;
        try {
            InputStream bin;
            if (in == null) {
                URL url = new URL(location);
                URLConnection conn = url.openConnection();
                String auth = System.getProperty("http.proxyAuth");
                if (auth != null && !"".equals(auth) && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                    String base64 = Util.base64Encode(auth);
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
                }
                bin = conn.getInputStream();
            } else {
                bin = in;
            }
            BundleImpl res = null;
            try {
                ba = this.framework.storage.insertBundleJar(location, bin);
            }
            finally {
                bin.close();
            }
            String ee = ba.getAttribute("Bundle-RequiredExecutionEnvironment");
            if (ee != null) {
                if (Debug.packages) {
                    Debug.println("bundle #" + ba.getBundleId() + " has EE=" + ee);
                }
                if (!this.framework.isValidEE(ee)) {
                    throw new RuntimeException("Execution environment '" + ee + "' is not supported");
                }
            }
            res = new BundleImpl(this.framework, ba);
            this.framework.perm.checkLifecycleAdminPerm(res, checkContext);
            if (res.isExtension()) {
                this.framework.perm.checkExtensionLifecycleAdminPerm(res, checkContext);
                if (!res.hasPermission(new AllPermission())) {
                    throw new SecurityException();
                }
            }
            ba.setLastModified(System.currentTimeMillis());
            this.bundles.put(location, res);
            return res;
        }
        catch (Exception e) {
            if (ba != null) {
                ba.purge();
            }
            throw new BundleException("Failed to install bundle: " + e, e);
        }
    }

    void remove(String location) {
        this.bundles.remove(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle(long id) {
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                if (b.id != id) continue;
                return b;
            }
        }
        return null;
    }

    public Bundle getBundle(String location) {
        return (Bundle)this.bundles.get(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl getBundle(String name, Version version) {
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                if (!name.equals(b.symbolicName) || !version.equals(b.version)) continue;
                return b;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBundles() {
        ArrayList res = new ArrayList(this.bundles.size());
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            res.addAll(this.bundles.values());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBundles(String name) {
        ArrayList<BundleImpl> res = new ArrayList<BundleImpl>();
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                if (!name.equals(b.symbolicName)) continue;
                res.add(b);
            }
        }
        return res;
    }

    List getBundles(String name, VersionRange range) {
        List res = this.getBundles(name);
        int i = 0;
        while (i < res.size()) {
            BundleImpl b = (BundleImpl)res.remove(i);
            if (!range.withinRange(b.version)) continue;
            int j = i;
            while (--j >= 0 && b.version.compareTo(((BundleImpl)res.get((int)j)).version) > 0) {
            }
            res.add(j + 1, b);
            ++i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getActiveBundles() {
        ArrayList<BundleImpl> slist = new ArrayList<BundleImpl>();
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                int s = b.getState();
                if (s != 32 && s != 8) continue;
                slist.add(b);
            }
        }
        return slist;
    }

    synchronized void load() {
        BundleArchive[] bas = this.framework.storage.getAllBundleArchives();
        for (int i = 0; i < bas.length; ++i) {
            BundleImpl b = new BundleImpl(this.framework, bas[i]);
            this.bundles.put(b.location, b);
        }
    }

    void startBundles(List slist) {
        Iterator i = slist.iterator();
        while (i.hasNext()) {
            BundleImpl rb = (BundleImpl)i.next();
            if (rb.getUpdatedState() != 4) continue;
            try {
                rb.start();
            }
            catch (BundleException be) {
                rb.framework.listeners.frameworkError(rb, be);
            }
        }
    }

    List getFragmentBundles(BundleImpl target) {
        ArrayList<BundleImpl> retval = new ArrayList<BundleImpl>();
        Enumeration e = this.bundles.elements();
        while (e.hasMoreElements()) {
            BundleImpl b = (BundleImpl)e.nextElement();
            if (!b.isFragment() || b.state == 1 || b.getFragmentHost() != target) continue;
            retval.add(b);
        }
        return retval;
    }
}

