/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ListenerEntry;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceListenerState;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.SynchronousBundleListener;

public class Listeners
implements BundleListener,
FrameworkListener,
ServiceListener {
    private HashSet bundleListeners = new HashSet();
    private HashSet syncBundleListeners = new HashSet();
    private HashSet frameworkListeners = new HashSet();
    private ServiceListenerState serviceListeners = new ServiceListenerState();
    private PermissionOps secure;
    static boolean nocacheldap = "true".equals(System.getProperty("org.knopflerfish.framework.ldap.nocache"));

    Listeners(PermissionOps perm) {
        this.secure = perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(Bundle bundle, BundleListener listener) {
        ListenerEntry le = new ListenerEntry(bundle, listener);
        if (listener instanceof SynchronousBundleListener) {
            this.secure.checkListenerAdminPerm(bundle);
            HashSet hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                this.syncBundleListeners.add(le);
            }
        }
        HashSet hashSet = this.bundleListeners;
        synchronized (hashSet) {
            this.bundleListeners.add(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(Bundle bundle, BundleListener listener) {
        ListenerEntry le = new ListenerEntry(bundle, listener);
        if (listener instanceof SynchronousBundleListener) {
            HashSet hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                this.secure.checkListenerAdminPerm(bundle);
                this.syncBundleListeners.remove(le);
            }
        }
        HashSet hashSet = this.bundleListeners;
        synchronized (hashSet) {
            this.bundleListeners.remove(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(Bundle bundle, FrameworkListener listener) {
        ListenerEntry le = new ListenerEntry(bundle, listener);
        HashSet hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            this.frameworkListeners.add(le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(Bundle bundle, FrameworkListener listener) {
        HashSet hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            this.frameworkListeners.remove(new ListenerEntry(bundle, listener));
        }
    }

    void addServiceListener(Bundle bundle, ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.serviceListeners.add(bundle, listener, filter);
    }

    void removeServiceListener(Bundle bundle, ServiceListener listener) {
        this.serviceListeners.remove(bundle, listener);
    }

    void removeAllListeners(Bundle b) {
        this.removeAllListeners(this.syncBundleListeners, b);
        this.removeAllListeners(this.bundleListeners, b);
        this.removeAllListeners(this.frameworkListeners, b);
        this.serviceListeners.removeAll(b);
    }

    void frameworkError(Bundle b, Throwable t) {
        this.frameworkEvent(new FrameworkEvent(2, b, t));
    }

    void frameworkInfo(Bundle b, Throwable t) {
        this.frameworkEvent(new FrameworkEvent(32, b, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent evt) {
        ListenerEntry[] tmp;
        ListenerEntry[] bl;
        HashSet hashSet;
        int type = evt.getType();
        if (type == 128 || type == 256) {
            hashSet = this.syncBundleListeners;
            synchronized (hashSet) {
                bl = new ListenerEntry[this.syncBundleListeners.size()];
                ((AbstractCollection)this.syncBundleListeners).toArray(bl);
            }
        }
        hashSet = this.bundleListeners;
        synchronized (hashSet) {
            tmp = new ListenerEntry[this.bundleListeners.size()];
            ((AbstractCollection)this.bundleListeners).toArray(tmp);
        }
        hashSet = this.syncBundleListeners;
        synchronized (hashSet) {
            bl = new ListenerEntry[tmp.length + this.syncBundleListeners.size()];
            ((AbstractCollection)this.syncBundleListeners).toArray(bl);
        }
        System.arraycopy(tmp, 0, bl, bl.length - tmp.length, tmp.length);
        for (int i = 0; i < bl.length; ++i) {
            ListenerEntry l = bl[i];
            try {
                this.secure.callBundleChanged((BundleListener)l.listener, evt);
                continue;
            }
            catch (Throwable pe) {
                this.frameworkError(l.bundle, pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent evt) {
        ListenerEntry[] fl;
        if (Debug.errors && evt.getType() == 2) {
            Debug.println("errors - FrameworkErrorEvent bundle #" + evt.getBundle().getBundleId());
            Debug.printStackTrace("errors - FrameworkErrorEvent throwable: ", evt.getThrowable());
        }
        HashSet hashSet = this.frameworkListeners;
        synchronized (hashSet) {
            fl = new ListenerEntry[this.frameworkListeners.size()];
            ((AbstractCollection)this.frameworkListeners).toArray(fl);
        }
        for (int i = 0; i < fl.length; ++i) {
            ListenerEntry l = fl[i];
            try {
                this.secure.callFrameworkEvent((FrameworkListener)l.listener, evt);
                continue;
            }
            catch (Throwable pe) {
                if (evt.getType() == 2) continue;
                this.frameworkError(l.bundle, pe);
            }
        }
    }

    public void serviceChanged(ServiceEvent evt) {
        ServiceReferenceImpl sr = (ServiceReferenceImpl)evt.getServiceReference();
        String[] classes = (String[])sr.getProperty("objectClass");
        Set sl = this.serviceListeners.getMatchingListeners(sr);
        int n = 0;
        Iterator it = sl.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry l = (ServiceListenerEntry)it.next();
            boolean testAssignable = false;
            if (!(l.listener instanceof AllServiceListener)) {
                testAssignable = true;
            }
            try {
                int length = classes.length;
                for (int i = 0; i < length; ++i) {
                    if (testAssignable && !sr.isAssignableTo(l.bundle, classes[i]) || !l.bundle.hasPermission(new ServicePermission(classes[i], "get"))) continue;
                    try {
                        this.secure.callServiceChanged((ServiceListener)l.listener, evt);
                    }
                    catch (Throwable pe) {
                        this.frameworkError(l.bundle, pe);
                    }
                    break;
                }
            }
            catch (Exception le) {
                this.frameworkError(l.bundle, le);
            }
            ++n;
        }
        if (Debug.ldap) {
            Debug.println("Notified " + n + " listeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllListeners(Set s, Bundle b) {
        Set set = s;
        synchronized (set) {
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (((ListenerEntry)i.next()).bundle != b) continue;
                i.remove();
            }
        }
    }
}

