/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleException;

public class Main {
    static Framework framework;
    static long bootMgr;
    static int verbosity;
    static String version;
    static String topDir;
    static String defaultXArgsInit;
    static final String defaultXArgsInit2 = "remote-init.xargs";
    static final String defaultXArgsStart = "restart.xargs";
    static boolean bZeroArgs;
    public static String bootText;
    static final String JARDIR_PROP = "org.knopflerfish.gosg.jars";
    static final String JARDIR_DEFAULT = "file:";
    static final String FWDIR_PROP = "org.osgi.framework.dir";
    static final String FWDIR_DEFAULT = "fwdir";
    static final String CMDIR_PROP = "org.knopflerfish.bundle.cm.store";
    static final String CMDIR_DEFAULT = "cmdir";
    static final String VERBOSITY_PROP = "org.knopflerfish.verbosity";
    static final String VERBOSITY_DEFAULT = "0";
    static final String XARGS_DEFAULT = "default";
    static final String PRODVERSION_PROP = "org.knopflerfish.prodver";
    static final String EXITONSHUTDOWN_PROP = "org.knopflerfish.framework.exitonshutdown";
    static final String USINGWRAPPERSCRIPT_PROP = "org.knopflerfish.framework.usingwrapperscript";
    static boolean restarting;
    static String[] initArgs;
    static int initOffset;
    static String[] initBase;
    public static final String[] FWPROPS;
    static String[][] defaultSysProps;

    public static void main(String[] args) {
        try {
            verbosity = Integer.parseInt(System.getProperty(VERBOSITY_PROP, VERBOSITY_DEFAULT));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        version = Main.readVersion();
        bootText = "Knopflerfish OSGi framework, version " + version + "\n" + "Copyright 2003-2008 Knopflerfish. All Rights Reserved.\n\n" + "See http://www.knopflerfish.org for more information.";
        System.out.println(bootText);
        bZeroArgs = args.length == 0;
        String xargsPath = Main.getDefaultXArgs(args);
        if (xargsPath != null) {
            if (bZeroArgs) {
                args = new String[]{"-xargs", xargsPath};
            } else if (args.length == 1 && "-init".equals(args[0])) {
                args = new String[]{"-init", "-xargs", xargsPath};
            }
        }
        args = Main.expandArgs(args);
        if (verbosity > 5) {
            for (int i = 0; i < args.length; ++i) {
                Main.println("argv[" + i + "]=" + args[i], 5);
            }
        }
        try {
            verbosity = Integer.parseInt(System.getProperty(VERBOSITY_PROP, VERBOSITY_DEFAULT));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (bZeroArgs) {
            args = Main.sanityArgs(args);
        }
        Main.setDefaultSysProps();
        String[] base = Main.getJarBase();
        for (int i = 0; i < args.length; ++i) {
            if (!"-init".equals(args[i])) continue;
            Main.doInit();
        }
        try {
            framework = new Framework(new Main());
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.error("New Framework failed!");
        }
        initArgs = args;
        initOffset = 0;
        initBase = base;
        Main.handleArgs(args, initOffset, base);
    }

    static void doInit() {
        FileTree dir;
        String d = System.getProperty(FWDIR_PROP);
        FileTree fileTree = dir = d != null ? new FileTree(d) : null;
        if (dir != null && dir.exists()) {
            boolean bOK = dir.delete();
            if (bOK) {
                Main.println("Removed existing fwdir " + dir.getAbsolutePath(), 0);
            } else {
                Main.println("Failed to remove existing fwdir " + dir.getAbsolutePath(), 0);
            }
        }
    }

    static String[] getJarBase() {
        String jars = System.getProperty(JARDIR_PROP, JARDIR_DEFAULT);
        String[] base = Util.splitwords(jars, ";");
        for (int i = 0; i < base.length; ++i) {
            try {
                base[i] = new URL(base[i]).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Main.println("jar base[" + i + "]=" + base[i], 3);
        }
        return base;
    }

    private static void handleArgs(String[] args, int startOffset, String[] base) {
        boolean doNotLaunch = false;
        for (int i = startOffset; i < args.length; ++i) {
            try {
                if ("-exit".equals(args[i])) {
                    Main.println("Exit.", 0);
                    System.exit(0);
                    continue;
                }
                if ("-init".equals(args[i])) continue;
                if ("-version".equals(args[i])) {
                    Main.printResource("/tstamp");
                    Main.printResource("/revision");
                    System.exit(0);
                    continue;
                }
                if ("-help".equals(args[i])) {
                    Main.printResource("/help.txt");
                    System.exit(0);
                    continue;
                }
                if ("-readme".equals(args[i])) {
                    Main.printResource("/readme.txt");
                    System.exit(0);
                    continue;
                }
                if ("-jvminfo".equals(args[i])) {
                    Main.printJVMInfo();
                    System.exit(0);
                    continue;
                }
                if ("-install".equals(args[i])) {
                    if (i + 1 < args.length) {
                        String bundle = args[i + 1];
                        long id = framework.installBundle(Main.completeLocation(base, bundle), null);
                        Main.println("Installed: " + framework.getBundleLocation(id) + " (id#" + id + ")", 0);
                        ++i;
                        continue;
                    }
                    Main.error("No URL for install command");
                    continue;
                }
                if ("-istart".equals(args[i])) {
                    if (i + 1 < args.length) {
                        String bundle = args[i + 1];
                        long id = framework.installBundle(Main.completeLocation(base, bundle), null);
                        framework.startBundle(id);
                        Main.println("Installed and started: " + framework.getBundleLocation(id) + " (id#" + id + ")", 0);
                        ++i;
                        continue;
                    }
                    Main.error("No URL for install command");
                    continue;
                }
                if ("-launch".equals(args[i])) {
                    if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                        bootMgr = Long.parseLong(args[i + 1]);
                        framework.launch(bootMgr);
                        ++i;
                    } else {
                        framework.launch(0L);
                    }
                    doNotLaunch = true;
                    Main.println("Framework launched", 0);
                    continue;
                }
                if ("-shutdown".equals(args[i])) {
                    doNotLaunch = true;
                    framework.shutdown();
                    Main.println("Framework shutdown", 0);
                    continue;
                }
                if ("-sleep".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long t = Long.parseLong(args[i + 1]);
                        try {
                            Main.println("Sleeping " + t + " seconds...", 0);
                            Thread.sleep(t * 1000L);
                        }
                        catch (InterruptedException e) {
                            Main.error("Sleep interrupted.");
                        }
                        ++i;
                        continue;
                    }
                    Main.error("No time for sleep command");
                    continue;
                }
                if ("-start".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long id = Main.getBundleID(base, args[i + 1]);
                        framework.startBundle(id);
                        Main.println("Started: " + framework.getBundleLocation(id) + " (id#" + id + ")", 0);
                        ++i;
                        continue;
                    }
                    Main.error("No ID for start command");
                    continue;
                }
                if ("-stop".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long id = Main.getBundleID(base, args[i + 1]);
                        framework.stopBundle(id);
                        Main.println("Stopped: " + framework.getBundleLocation(id) + " (id#" + id + ")", 0);
                        ++i;
                        continue;
                    }
                    Main.error("No ID for stop command");
                    continue;
                }
                if ("-uninstall".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long id = Main.getBundleID(base, args[i + 1]);
                        String loc = framework.getBundleLocation(id);
                        framework.uninstallBundle(id);
                        Main.println("Uninstalled: " + loc + " (id#" + id + ")", 0);
                        ++i;
                        continue;
                    }
                    Main.error("No id for uninstall command");
                    continue;
                }
                if ("-update".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long[] ids = null;
                        if ("ALL".equals(args[i + 1])) {
                            List bl = Main.framework.bundles.getBundles();
                            ids = new long[bl.size()];
                            for (int n = bl.size() - 1; n >= 0; --n) {
                                ids[n] = ((BundleImpl)bl.get(n)).getBundleId();
                            }
                        } else {
                            ids = new long[]{Main.getBundleID(base, args[i + 1])};
                        }
                        for (int n = 0; n < ids.length; ++n) {
                            long id = ids[n];
                            if (id == 0L) continue;
                            framework.updateBundle(id);
                            Main.println("Updated: " + framework.getBundleLocation(id) + " (id#" + id + ")", 0);
                        }
                        ++i;
                        continue;
                    }
                    Main.error("No id for update command");
                    continue;
                }
                if ("-initlevel".equals(args[i])) {
                    if (i + 1 < args.length) {
                        int n = Integer.parseInt(args[i + 1]);
                        if (Main.framework.startLevelService != null) {
                            Main.framework.startLevelService.setInitialBundleStartLevel(n);
                        } else {
                            Main.println("No start level service - ignoring init bundle level " + n, 0);
                        }
                        ++i;
                        continue;
                    }
                    Main.error("No integer level for initlevel command");
                    continue;
                }
                if ("-startlevel".equals(args[i])) {
                    if (i + 1 < args.length) {
                        int n = Integer.parseInt(args[i + 1]);
                        if (Main.framework.startLevelService != null) {
                            if (n == 1) {
                                if (Debug.startlevel) {
                                    Debug.println("Entering startlevel compatibility mode, all bundles will have startlevel == 1");
                                }
                                Main.framework.startLevelService.bCompat = true;
                            }
                            Main.framework.startLevelService.setStartLevel(n);
                        } else {
                            Main.println("No start level service - ignoring start level " + n, 0);
                        }
                        ++i;
                        continue;
                    }
                    Main.error("No integer level for startlevel command");
                    continue;
                }
                Main.error("Unknown option: " + args[i] + "\nUse option -help to see all options");
                continue;
            }
            catch (BundleException e) {
                Throwable ne = e.getNestedException();
                if (ne != null) {
                    e.getNestedException().printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                Main.error("Command \"" + args[i] + (i + 1 < args.length && !args[i + 1].startsWith("-") ? " " + args[i + 1] : "") + "\" failed, " + e.getMessage());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                Main.error("Command \"" + args[i] + (i + 1 < args.length && !args[i + 1].startsWith("-") ? " " + args[i + 1] : "") + "\" failed, " + e.getMessage());
            }
        }
        if (!Main.framework.active && !doNotLaunch) {
            try {
                framework.launch(0L);
                Main.println("Framework launched", 0);
            }
            catch (Throwable t) {
                BundleException be;
                Throwable ne;
                if (t instanceof BundleException && (ne = (be = (BundleException)t).getNestedException()) != null) {
                    t = ne;
                }
                t.printStackTrace(System.err);
                Main.error("Framework launch failed, " + t.getMessage());
            }
        }
    }

    private static long getBundleID(String[] base, String idLocation) {
        try {
            return Long.parseLong(idLocation);
        }
        catch (NumberFormatException nfe) {
            long id = framework.getBundleId(Main.completeLocation(base, idLocation));
            if (id != -1L) {
                return id;
            }
            throw new IllegalArgumentException("Invalid bundle id/location: " + idLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String completeLocation(String[] base, String location) {
        int ic;
        if (bZeroArgs && location.startsWith("file:jars/") && !topDir.equals("")) {
            location = (JARDIR_DEFAULT + topDir + location.substring(5)).replace('\\', '/');
            Main.println("mangled bundle location to " + location, 2);
        }
        if ((ic = location.indexOf(":")) < 2 || ic > location.indexOf("/")) {
            Main.println("location=" + location, 2);
            for (int i = 0; i < base.length; ++i) {
                Main.println("base[" + i + "]=" + base[i], 2);
                try {
                    URL url = new URL(new URL(base[i]), location);
                    Main.println("check " + url, 2);
                    if ("file".equals(url.getProtocol())) {
                        File f = new File(url.getFile());
                        if (!f.exists() || !f.canRead()) {
                            continue;
                        }
                    } else if ("http".equals(url.getProtocol())) {
                        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                        uc.connect();
                        int rc = uc.getResponseCode();
                        uc.disconnect();
                        if (rc != 200) {
                            Main.println("Can't access HTTP bundle: " + url + ", response code=" + rc, 0);
                            continue;
                        }
                    } else {
                        InputStream is = null;
                        try {
                            is = url.openStream();
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    location = url.toString();
                    Main.println("found location=" + location, 5);
                    break;
                }
                catch (Exception _e) {
                    // empty catch block
                }
            }
        }
        return location;
    }

    public static void shutdown(final int exitcode) {
        if (restarting) {
            return;
        }
        Thread t = new Thread(){

            public void run() {
                if (bootMgr != 0L) {
                    try {
                        framework.stopBundle(bootMgr);
                    }
                    catch (BundleException e) {
                        System.err.println("Stop of BootManager failed, " + e.getNestedException());
                    }
                }
                framework.shutdown();
                if ("true".equals(System.getProperty(Main.EXITONSHUTDOWN_PROP, "true"))) {
                    System.exit(exitcode);
                } else {
                    Main.println("Framework shutdown, skipped System.exit()", 0);
                }
            }
        };
        t.setDaemon(false);
        t.start();
    }

    public static void restart() {
        restarting = true;
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block9: {
                    try {
                        if (bootMgr != 0L) {
                            try {
                                framework.stopBundle(bootMgr);
                            }
                            catch (BundleException e) {
                                System.err.println("Stop of BootManager failed, " + e.getNestedException());
                            }
                        }
                        framework.shutdown();
                        try {
                            if (bootMgr != 0L) {
                                framework.launch(bootMgr);
                                break block9;
                            }
                            framework.launch(0L);
                        }
                        catch (Exception e) {
                            Main.println("Failed to restart framework", 0);
                        }
                    }
                    finally {
                        restarting = false;
                    }
                }
            }
        };
        t.setDaemon(false);
        t.start();
    }

    static String[] expandArgs(String[] argv) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < argv.length; ++i) {
            if ("-xargs".equals(argv[i]) || "--xargs".equals(argv[i])) {
                boolean bIgnoreException = argv[i].equals("--xargs");
                if (i + 1 < argv.length) {
                    String xargsPath = argv[i + 1];
                    ++i;
                    try {
                        String[] moreArgs = Main.loadArgs(xargsPath, argv);
                        String[] r = Main.expandArgs(moreArgs);
                        for (int j = 0; j < r.length; ++j) {
                            v.addElement(r[j]);
                        }
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (bIgnoreException) {
                            Main.println("Failed to load -xargs " + xargsPath, 1, e);
                            continue;
                        }
                        throw e;
                    }
                }
                throw new IllegalArgumentException("-xargs without argument");
            }
            v.addElement(argv[i]);
        }
        Object[] r = new String[v.size()];
        v.copyInto(r);
        return r;
    }

    static void printResource(String name) {
        try {
            System.out.println(new String(Util.readResource(name)));
        }
        catch (Exception e) {
            System.out.println("No resource '" + name + "' available");
        }
    }

    static void printJVMInfo() {
        try {
            Properties props = System.getProperties();
            System.out.println("--- System properties ---");
            Enumeration e = ((Hashtable)props).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.out.println(key + ": " + ((Hashtable)props).get(key));
            }
            System.out.println("\n--- Framework properties ---");
            for (int i = 0; i < FWPROPS.length; ++i) {
                System.out.println(FWPROPS[i] + ": " + Framework.getProperty(FWPROPS[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String readVersion() {
        return Main.readResource("/version", "<no version found>");
    }

    static String readRelease() {
        return Main.readResource("/release", "0.0.0.snapshot");
    }

    static String readResource(String file, String defaultValue) {
        try {
            return new String(Util.readResource(file)).trim();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static String getDefaultXArgs(String[] oldArgs) {
        boolean bInit = false;
        for (int i = 0; i < oldArgs.length; ++i) {
            if (!"-init".equals(oldArgs[i])) continue;
            bInit = true;
        }
        String fwDirStr = System.getProperty(FWDIR_PROP, FWDIR_DEFAULT);
        File fwDir = new File(fwDirStr);
        File xargsFile = null;
        String defDirStr = new File(fwDir.getAbsolutePath()).getParent();
        File defDir = defDirStr != null ? new File(defDirStr) : null;
        Main.println("fwDir=" + fwDir, 2);
        Main.println("defDir=" + defDir, 2);
        Main.println("bInit=" + bInit, 2);
        if (defDir != null) {
            topDir = defDir + File.separator;
            try {
                String osName = (String)Alias.unifyOsName(System.getProperty("os.name")).get(0);
                File f = new File(defDir, "init_" + osName + ".xargs");
                if (f.exists()) {
                    defaultXArgsInit = f.getName();
                    Main.println("found OS specific xargs=" + defaultXArgsInit, 1);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (!bInit && fwDir.exists() && fwDir.isDirectory()) {
                Main.println("found fwdir at " + fwDir.getAbsolutePath(), 1);
                xargsFile = new File(defDir, defaultXArgsStart);
                if (xargsFile.exists()) {
                    Main.println("\nDefault restart xargs file: " + xargsFile + "\n" + "To reinitialize, remove the " + fwDir.toString() + " directory\n", 5);
                } else {
                    File xargsFile2 = new File(defDir, defaultXArgsInit);
                    Main.println("No restart xargs file " + xargsFile + ", trying " + xargsFile2 + " instead.", 0);
                    xargsFile = xargsFile2;
                }
            } else {
                Main.println("no fwdir at " + fwDir.getAbsolutePath(), 1);
                xargsFile = new File(defDir, defaultXArgsInit);
                if (xargsFile.exists()) {
                    Main.println("\nDefault init xargs file: " + xargsFile + "\n", 5);
                } else {
                    xargsFile = new File(defDir, defaultXArgsInit2);
                    if (xargsFile.exists()) {
                        Main.println("\nDeafult secondary init xargs file: " + xargsFile + "\n", 5);
                    }
                }
            }
        }
        return xargsFile != null ? xargsFile.getAbsolutePath() : null;
    }

    static void setDefaultSysProps() {
        String jars;
        Properties sysProps = System.getProperties();
        Main.println("setDefaultSysProps", 1);
        for (int i = 0; i < defaultSysProps.length; ++i) {
            if (null == System.getProperty(defaultSysProps[i][0])) {
                Main.println("Using default " + defaultSysProps[i][0] + "=" + defaultSysProps[i][1], 1);
                ((Hashtable)sysProps).put(defaultSysProps[i][0], defaultSysProps[i][1]);
                continue;
            }
            Main.println("system prop " + defaultSysProps[i][0] + "=" + System.getProperty(defaultSysProps[i][0]), 1);
        }
        if (null == System.getProperty(PRODVERSION_PROP)) {
            ((Hashtable)sysProps).put(PRODVERSION_PROP, version);
        }
        if ((jars = System.getProperty(JARDIR_PROP, null)) == null || "".equals(jars)) {
            String jarBaseDir = topDir + "jars";
            Main.println("jarBaseDir=" + jarBaseDir, 1);
            File jarDir = new File(jarBaseDir);
            if (jarDir.exists() && jarDir.isDirectory()) {
                String[] names = jarDir.list();
                Vector<String> v = new Vector<String>();
                for (int i = 0; i < names.length; ++i) {
                    File f = new File(jarDir, names[i]);
                    if (!f.isDirectory()) continue;
                    v.addElement(names[i]);
                }
                Object[] subdirs = new String[v.size()];
                v.copyInto(subdirs);
                StringBuffer sb = new StringBuffer();
                sb.append(JARDIR_DEFAULT + jarBaseDir + "/");
                for (int i = 0; i < subdirs.length; ++i) {
                    sb.append(";file:" + jarBaseDir + "/" + (String)subdirs[i] + "/");
                }
                jars = sb.toString().replace('\\', '/');
                ((Hashtable)sysProps).put(JARDIR_PROP, jars);
                Main.println("scanned org.knopflerfish.gosg.jars=" + jars, 1);
            }
        }
        System.setProperties(sysProps);
    }

    static String[] sanityArgs(String[] args) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            v.addElement(args[i]);
        }
        if (!v.contains("-launch")) {
            Main.println("adding last -launch command", 1);
            v.addElement("-launch");
        }
        Object[] arg2 = new String[v.size()];
        v.copyInto(arg2);
        return arg2;
    }

    static String[] loadArgs(String xargsPath, String[] oldArgs) {
        if (XARGS_DEFAULT.equals(xargsPath)) {
            xargsPath = Main.getDefaultXArgs(oldArgs);
        }
        Vector<String> v = new Vector<String>();
        try {
            BufferedReader in = null;
            File f = new File(xargsPath);
            if (f.exists()) {
                Main.println("Loading xargs file " + f.getAbsolutePath(), 0);
                in = new BufferedReader(new FileReader(f));
            }
            if (in == null) {
                try {
                    URL url = new URL(xargsPath);
                    Main.println("Loading xargs url " + url, 0);
                    in = new BufferedReader(new InputStreamReader(url.openStream()));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Bad xargs URL " + xargsPath + ": " + e);
                }
            }
            Properties sysProps = System.getProperties();
            StringBuffer contLine = new StringBuffer();
            String line = null;
            String tmpline = null;
            int lineno = 0;
            tmpline = in.readLine();
            while (tmpline != null) {
                ++lineno;
                if ((tmpline = tmpline.trim()).endsWith("\\")) {
                    tmpline = tmpline.substring(0, tmpline.length() - 1);
                    if (contLine == null) {
                        contLine = new StringBuffer(tmpline);
                    } else {
                        contLine.append(tmpline);
                    }
                } else {
                    if (contLine != null) {
                        contLine.append(tmpline);
                        line = contLine.toString();
                        contLine = null;
                    } else {
                        line = tmpline;
                    }
                    if (line.startsWith("-D")) {
                        int ix = line.indexOf("=");
                        if (ix != -1) {
                            String name = line.substring(2, ix);
                            String val = line.substring(ix + 1);
                            if (-1 != val.indexOf("${")) {
                                Enumeration e = ((Hashtable)sysProps).keys();
                                while (e.hasMoreElements()) {
                                    String k = (String)e.nextElement();
                                    if (-1 == val.indexOf(k)) continue;
                                    String sv = (String)((Hashtable)sysProps).get(k);
                                    val = Util.replace(val, "${" + k + "}", sv);
                                }
                            }
                            ((Hashtable)sysProps).put(name, val);
                        }
                    } else if (!line.startsWith("#")) {
                        if (line.startsWith("-")) {
                            int i = line.indexOf(32);
                            if (i != -1) {
                                v.addElement(line.substring(0, i));
                                line = line.substring(i).trim();
                                if (line.length() > 0) {
                                    v.addElement(line);
                                }
                            } else {
                                v.addElement(line);
                            }
                        } else if (line.length() > 0) {
                            v.addElement(line);
                        }
                    }
                }
                tmpline = in.readLine();
            }
            Main.setSecurityManager(sysProps);
            System.setProperties(sysProps);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("xargs loading failed: " + e);
        }
        Object[] args2 = new String[v.size()];
        v.copyInto(args2);
        return args2;
    }

    static void println(String s, int level) {
        Main.println(s, level, null);
    }

    static void println(String s, int level, Exception e) {
        if (verbosity >= level) {
            System.out.println((level > 0 ? "#" + level + ": " : "") + s);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    static void setSecurityManager(Properties props) {
        try {
            String manager = (String)((Hashtable)props).get("java.security.manager");
            String policy = (String)((Hashtable)props).get("java.security.policy");
            if (manager != null && System.getSecurityManager() == null) {
                Main.println("Setting security manager=" + manager + ", policy=" + policy, 1);
                System.setProperty("java.security.manager", manager);
                if (policy != null) {
                    System.setProperty("java.security.policy", policy);
                }
                SecurityManager sm = null;
                if ("".equals(manager)) {
                    sm = new SecurityManager();
                } else {
                    Class<?> clazz = Class.forName(manager);
                    Constructor<?> cons = clazz.getConstructor(new Class[0]);
                    sm = (SecurityManager)cons.newInstance(new Object[0]);
                }
                System.setSecurityManager(sm);
            }
        }
        catch (Exception e) {
            Main.error("Failed to set security manager", e);
        }
    }

    static void error(String s) {
        Main.error(s, null);
    }

    static void error(String s, Exception e) {
        System.err.println("Error: " + s);
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    static {
        version = "<unknown>";
        topDir = "";
        defaultXArgsInit = "init.xargs";
        bootText = "";
        restarting = false;
        initArgs = null;
        initOffset = 0;
        initBase = null;
        FWPROPS = new String[]{"org.osgi.framework.vendor", "org.osgi.framework.version", "org.osgi.framework.language", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.executionenvironment"};
        defaultSysProps = new String[][]{{"org.osgi.framework.system.packages", "javax.accessibility,javax.net,javax.net.ssl,javax.swing,javax.swing.border,javax.swing.event,javax.swing.filechooser,javax.swing.plaf,javax.swing.plaf.basic,javax.swing.plaf.metal,javax.swing.table,javax.swing.text,javax.swing.tree"}, {FWDIR_PROP, FWDIR_DEFAULT}, {CMDIR_PROP, CMDIR_DEFAULT}};
    }
}

