/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Queue;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelImpl
implements StartLevel,
Runnable {
    Thread wc;
    long wcDelay = 2000L;
    boolean bRun = false;
    Queue jobQueue = new Queue(100);
    static final int START_MIN = 0;
    static final int START_MAX = Integer.MAX_VALUE;
    static final String LEVEL_FILE = "currentlevel";
    int currentLevel = 0;
    int initStartLevel = 1;
    int targetStartLevel = this.currentLevel;
    boolean acceptChanges = true;
    Framework framework;
    FileTree storage;
    boolean bCompat;
    public static final String SPEC_VERSION = "1.0";
    Object lock = new Object();
    static final Util.Comparator BSComparator = new Util.Comparator(){

        public int compare(Object o1, Object o2) {
            BundleImpl b1 = (BundleImpl)o1;
            BundleImpl b2 = (BundleImpl)o2;
            int res = b1.getStartLevel() - b2.getStartLevel();
            if (res == 0) {
                res = (int)(b1.getBundleId() - b2.getBundleId());
            }
            return res;
        }
    };

    public StartLevelImpl(Framework framework) {
        this.framework = framework;
        this.storage = Util.getFileStorage("startlevel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        if (Debug.startlevel) {
            Debug.println("startlevel: open");
        }
        if (this.jobQueue.isEmpty()) {
            this.setStartLevel0(1, false, false, true);
        }
        Runnable firstJob = (Runnable)this.jobQueue.firstElement();
        this.wc = new Thread((Runnable)this, "startlevel job thread");
        Runnable runnable = firstJob;
        synchronized (runnable) {
            this.bRun = true;
            this.wc.start();
            if (!this.acceptChanges) {
                this.acceptChanges = true;
                this.restoreState();
            }
            try {
                firstJob.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void restoreState() {
        if (Debug.startlevel) {
            Debug.println("startlevel: restoreState");
        }
        if (!Framework.bIsMemoryStorage) {
            try {
                int oldStartLevel;
                String s = Util.getContent(new File(this.storage, LEVEL_FILE));
                if (s != null && (oldStartLevel = Integer.parseInt(s)) != -1) {
                    this.setStartLevel0(oldStartLevel, false, false, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void close() {
        if (Debug.startlevel) {
            Debug.println("*** closing startlevel service");
        }
        this.bRun = false;
        if (this.wc != null) {
            try {
                this.wc.join(this.wcDelay * 2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.acceptChanges = false;
        this.setStartLevel0(0, false, true, false);
        while (this.currentLevel > 1) {
            Thread thread = this.wc;
            synchronized (thread) {
                try {
                    this.wc.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.bRun) {
            try {
                Runnable job = (Runnable)this.jobQueue.removeWait((float)((double)this.wcDelay / 1000.0));
                if (job == null) continue;
                job.run();
                Runnable runnable = job;
                synchronized (runnable) {
                    job.notify();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    public int getStartLevel() {
        return this.currentLevel;
    }

    public void setStartLevel(int startLevel) {
        this.framework.perm.checkStartLevelAdminPerm();
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        if (this.acceptChanges) {
            this.setStartLevel0(startLevel, this.framework.active, false, true);
        }
    }

    private void setStartLevel0(final int startLevel, final boolean notifyFw, final boolean notifyWC, final boolean storeLevel) {
        if (Debug.startlevel) {
            Debug.println("startlevel: setStartLevel " + startLevel);
        }
        this.jobQueue.insert(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int sl;
                StartLevelImpl.this.targetStartLevel = sl = StartLevelImpl.this.bCompat ? 1 : startLevel;
                while (StartLevelImpl.this.targetStartLevel > StartLevelImpl.this.currentLevel) {
                    StartLevelImpl.this.increaseStartLevel();
                }
                while (StartLevelImpl.this.targetStartLevel < StartLevelImpl.this.currentLevel) {
                    StartLevelImpl.this.decreaseStartLevel();
                }
                if (storeLevel && !Framework.bIsMemoryStorage) {
                    try {
                        Util.putContent(new File(StartLevelImpl.this.storage, StartLevelImpl.LEVEL_FILE), Integer.toString(StartLevelImpl.this.currentLevel));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (notifyFw) {
                    StartLevelImpl.this.notifyFramework();
                }
                if (notifyWC && StartLevelImpl.this.wc != null) {
                    Thread thread = StartLevelImpl.this.wc;
                    synchronized (thread) {
                        StartLevelImpl.this.wc.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            BundleImpl bs;
            ++this.currentLevel;
            if (Debug.startlevel) {
                Debug.println("startlevel: increaseStartLevel currentLevel=" + this.currentLevel);
            }
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            List bundles = this.framework.bundles.getBundles();
            Iterator i = bundles.iterator();
            while (i.hasNext()) {
                bs = (BundleImpl)i.next();
                if (!this.canStart(bs) || bs.getStartLevel() != this.currentLevel || !bs.archive.isPersistent()) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, false);
            for (int i2 = 0; i2 < set.size(); ++i2) {
                bs = (BundleImpl)set.elementAt(i2);
                try {
                    if (!bs.archive.isPersistent()) continue;
                    if (Debug.startlevel) {
                        Debug.println("startlevel: start " + bs);
                    }
                    bs.start();
                    continue;
                }
                catch (Exception e) {
                    this.framework.listeners.frameworkError(bs, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            BundleImpl bs;
            --this.currentLevel;
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            List bundles = this.framework.bundles.getBundles();
            Iterator i = bundles.iterator();
            while (i.hasNext()) {
                bs = (BundleImpl)i.next();
                if (bs.getState() != 32 || bs.getStartLevel() != this.currentLevel + 1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, true);
            for (int i2 = 0; i2 < set.size(); ++i2) {
                bs = (BundleImpl)set.elementAt(i2);
                BundleException saved = null;
                BundleImpl bundleImpl = bs;
                synchronized (bundleImpl) {
                    if (bs.getState() == 32) {
                        if (Debug.startlevel) {
                            Debug.println("startlevel: stop " + bs);
                        }
                        saved = bs.stop0(false);
                    }
                }
                if (saved == null) continue;
                this.framework.listeners.frameworkError(bs, saved);
            }
        }
    }

    boolean canStart(BundleImpl b) {
        return b.getState() != 1;
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle.getBundleId() == 0L) {
            return 0;
        }
        BundleImpl bs = (BundleImpl)bundle;
        return bs.getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle, final int startLevel) {
        this.framework.perm.checkExecuteAdminPerm(bundle);
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("System bundle start level cannot be changed");
        }
        final BundleImpl bs = (BundleImpl)bundle;
        if (bs.getState() == 1) {
            throw new IllegalArgumentException("uninstalled bundle start level cannot be changed");
        }
        this.jobQueue.insert(new Runnable(){

            public void run() {
                int sl = StartLevelImpl.this.bCompat ? 1 : startLevel;
                bs.setStartLevel(sl);
                StartLevelImpl.this.syncStartLevel(bs);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncStartLevel(BundleImpl bs) {
        Object object = this.lock;
        synchronized (object) {
            if (bs.getStartLevel() <= this.currentLevel) {
                if (this.canStart(bs)) {
                    if (bs.archive.isPersistent() || bs.getState() == 4) {
                        try {
                            if (Debug.startlevel) {
                                Debug.println("startlevel: start " + bs);
                            }
                            bs.start();
                        }
                        catch (Exception e) {
                            this.framework.listeners.frameworkError(bs, e);
                        }
                    } else {
                        bs.bDelayedStart = true;
                    }
                }
            } else if (bs.getStartLevel() > this.currentLevel) {
                BundleException saved = null;
                BundleImpl bundleImpl = bs;
                synchronized (bundleImpl) {
                    if (bs.getState() == 32) {
                        if (Debug.startlevel) {
                            Debug.println("startlevel: stop " + bs);
                        }
                        saved = bs.stop0(false);
                    }
                }
                if (saved != null) {
                    this.framework.listeners.frameworkError(bs, saved);
                }
            }
        }
    }

    public int getInitialBundleStartLevel() {
        return this.initStartLevel;
    }

    public void setInitialBundleStartLevel(int startLevel) {
        this.framework.perm.checkStartLevelAdminPerm();
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        this.initStartLevel = this.bCompat ? 1 : startLevel;
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        return ((BundleImpl)bundle).isPersistent();
    }

    private void notifyFramework() {
        this.framework.listeners.frameworkEvent(new FrameworkEvent(8, this.framework.systemBundle, null));
    }
}

