/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.Main;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class SystemBundle
extends BundleImpl {
    private static final String SYSPKG_FILE = "org.osgi.framework.system.packages.file";
    private static final String EXPORT_ALL_CURRENT = "org.knopflerfish.framework.system.export.all";
    private static final String EXPORT13 = "org.knopflerfish.framework.system.export.all_13";
    private static final String EXPORT14 = "org.knopflerfish.framework.system.export.all_14";
    private static final String EXPORT15 = "org.knopflerfish.framework.system.export.all_15";
    private static final String EXPORT16 = "org.knopflerfish.framework.system.export.all_16";
    private final String exportPackageString;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$osgi$util$tracker$ServiceTracker;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;
    static /* synthetic */ Class class$org$knopflerfish$framework$SystemBundle;

    SystemBundle(Framework fw, ProtectionDomain pd) {
        super(fw, 0L, "System Bundle", pd, "system.bundle", new Version(Main.readVersion()));
        this.state = 8;
        StringBuffer sp = new StringBuffer(System.getProperty("org.osgi.framework.system.packages", ""));
        if (sp.length() > 0) {
            sp.append(",");
        }
        if ("true".equals(System.getProperty(EXPORT_ALL_CURRENT, "").trim())) {
            String jv = System.getProperty("java.version", null);
            if (null != jv) {
                int end = jv.indexOf(46);
                if (end > -1) {
                    end = jv.indexOf(46, end + 1);
                }
                if (end > -1) {
                    this.addSysPackagesFromFile(sp, "packages" + jv.substring(0, end) + ".txt");
                }
            }
        } else {
            if ("true".equals(System.getProperty(EXPORT13, "").trim())) {
                this.addSysPackagesFromFile(sp, "packages1.3.txt");
            }
            if ("true".equals(System.getProperty(EXPORT14, "").trim())) {
                this.addSysPackagesFromFile(sp, "packages1.4.txt");
            }
            if ("true".equals(System.getProperty(EXPORT15, "").trim())) {
                this.addSysPackagesFromFile(sp, "packages1.5.txt");
            }
            if ("true".equals(System.getProperty(EXPORT16, "").trim())) {
                this.addSysPackagesFromFile(sp, "packages1.6.txt");
            }
        }
        this.addSysPackagesFromFile(sp, System.getProperty(SYSPKG_FILE, null));
        this.addSystemPackages(sp);
        this.exportPackageString = sp.toString();
        this.bpkgs = new BundlePackages(this, 0, this.exportPackageString, null, null, null);
        this.bpkgs.registerPackages();
        this.bpkgs.resolvePackages();
    }

    void addSystemPackages(StringBuffer sp) {
        String name = (class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = SystemBundle.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append(name + ";" + "version" + "=" + "1.3");
        name = (class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = SystemBundle.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.2");
        name = (class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = SystemBundle.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.2");
        name = (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = SystemBundle.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.0");
        name = (class$org$osgi$util$tracker$ServiceTracker == null ? (class$org$osgi$util$tracker$ServiceTracker = SystemBundle.class$("org.osgi.util.tracker.ServiceTracker")) : class$org$osgi$util$tracker$ServiceTracker).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.3.1");
        name = (class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = SystemBundle.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName();
        name = name.substring(0, name.lastIndexOf(46));
        sp.append("," + name + ";" + "version" + "=" + "1.0");
    }

    void addSysPackagesFromFile(StringBuffer sp, String sysPkgFile) {
        if (null == sysPkgFile || 0 == sysPkgFile.length()) {
            return;
        }
        if (Debug.packages) {
            Debug.println("Will add system packages from file " + sysPkgFile);
        }
        URL url = null;
        File f = new File(sysPkgFile);
        if (!f.exists() || !f.isFile()) {
            url = (class$org$knopflerfish$framework$SystemBundle == null ? (class$org$knopflerfish$framework$SystemBundle = SystemBundle.class$("org.knopflerfish.framework.SystemBundle")) : class$org$knopflerfish$framework$SystemBundle).getResource(sysPkgFile);
            if (null == url) {
                url = (class$org$knopflerfish$framework$SystemBundle == null ? (class$org$knopflerfish$framework$SystemBundle = SystemBundle.class$("org.knopflerfish.framework.SystemBundle")) : class$org$knopflerfish$framework$SystemBundle).getResource("/" + sysPkgFile);
            }
            if (null == url) {
                throw new RuntimeException("System package file '" + sysPkgFile + "' does not exists");
            }
        }
        BufferedReader in = null;
        try {
            InputStreamReader reader = null;
            String source = null;
            if (null == url) {
                reader = new FileReader(f);
                source = f.getAbsolutePath().toString();
            } else {
                reader = new InputStreamReader(url.openStream());
                source = url.toString();
            }
            in = new BufferedReader(reader);
            if (Debug.packages) {
                Debug.println("\treading from " + source);
            }
            String line = in.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    sp.append(line);
                    sp.append(",");
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read " + sysPkgFile + ": " + e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignored) {}
        }
    }

    public boolean hasPermission(Object permission) {
        return true;
    }

    public synchronized void start() throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public synchronized void stop(int exitcode) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        this.framework.listeners.bundleChanged(new BundleEvent(256, this));
        this.secure.callMainShutdown(exitcode);
    }

    public synchronized void update(InputStream in) throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        this.secure.callMainRestart();
    }

    public synchronized void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        throw new BundleException("uninstall of System bundle is not allowed");
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Bundle-SymbolicName", "system.bundle");
        headers.put("Bundle-Name", "System Bundle");
        headers.put("Export-Package", this.exportPackageString);
        headers.put("Bundle-Version", Main.readRelease());
        return headers;
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return null;
    }

    public URL getEntry(String name) {
        return null;
    }

    public Enumeration getEntryPaths(String path) {
        return null;
    }

    ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    void setBundleContext(BundleContextImpl bc) {
        this.bundleContext = bc;
    }

    void systemActive() {
        this.state = 32;
    }

    void systemShuttingdown() {
        this.state = 16;
    }

    private boolean isInClassPath(BundleImpl extension) {
        String cps = extension.isBootClassPathExtension() ? "sun.boot.class.path" : "java.class.path";
        String cp = System.getProperty(cps);
        String[] scp = Util.splitwords(cp, ":");
        String path = extension.archive.getJarLocation();
        for (int i = 0; i < scp.length; ++i) {
            if (!scp[i].equals(path)) continue;
            return true;
        }
        return false;
    }

    void attachFragment(BundleImpl extension) {
        if (!this.isInClassPath(extension)) {
            throw new UnsupportedOperationException("Extension can not be dynamicly activated");
        }
        super.attachFragment(extension);
    }

    protected void readLocalization(String locale, Hashtable localization_entries) {
        String[] parts = Util.splitwords(locale, "_");
        String tmploc = parts[0];
        int o = 0;
        while (true) {
            if (this.fragments != null) {
                for (int i = this.fragments.size() - 1; i >= 0; --i) {
                    BundleImpl b = (BundleImpl)this.fragments.get(i);
                    Hashtable tmp = b.archive.getLocalizationEntries(tmploc);
                    if (tmp == null) continue;
                    localization_entries.putAll(tmp);
                }
            }
            if (++o >= parts.length) break;
            tmploc = tmploc + "_" + parts[o];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

