/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

class Archive {
    Manifest manifest;
    protected HashMap content;
    ArrayList subDirs;

    Archive(InputStream is) throws IOException {
        JarInputStream ji = new JarInputStream(is);
        this.manifest = ji.getManifest();
        if (this.manifest == null) {
            throw new IOException("Bundle manifest is missing");
        }
        if (this.manifest.getMainAttributes().getValue("Bundle-NativeCode") != null) {
            throw new IOException("Native code not allowed by memory storage");
        }
        this.content = this.loadJarStream(ji);
    }

    Archive(Archive a, String path) throws IOException {
        byte[] bs = (byte[])a.content.remove(path);
        if (bs == null) {
            throw new FileNotFoundException("No such file: " + path);
        }
        JarInputStream ji = new JarInputStream(new ByteArrayInputStream(bs));
        this.content = this.loadJarStream(ji);
    }

    String getAttribute(String key) {
        return this.manifest.getMainAttributes().getValue(key);
    }

    byte[] getClassBytes(String classFile) throws IOException {
        byte[] bytes = (byte[])this.content.remove(classFile);
        if (bytes == null) {
            if (this.subDirs == null) {
                return null;
            }
            Iterator it = ((AbstractList)this.subDirs).iterator();
            boolean found = false;
            while (it.hasNext()) {
                String subDir = (String)it.next();
                bytes = (byte[])this.content.remove(subDir + "/" + classFile);
                if (bytes == null) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        return bytes;
    }

    InputStream getInputStream(String component) {
        byte[] b;
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if ((b = (byte[])this.content.get(component)) != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    Enumeration findResourcesPath(String path) {
        Vector<String> answer = new Vector<String>();
        path.replace('\\', '/');
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/") && path.length() > 1) {
            path = path + "/";
        }
        Iterator it = this.content.keySet().iterator();
        while (it.hasNext()) {
            String terminal;
            StringTokenizer st;
            String entryPath;
            String entry = (String)it.next();
            if (!entry.startsWith(path) || answer.contains(entryPath = (st = new StringTokenizer(terminal = entry.substring(path.length()), "/")).hasMoreTokens() ? path + st.nextToken() : path)) continue;
            answer.add(entryPath);
        }
        if (answer.size() == 0) {
            return null;
        }
        return answer.elements();
    }

    Archive getSubArchive(String path) throws IOException {
        return new Archive(this, path);
    }

    private HashMap loadJarStream(JarInputStream ji) throws IOException {
        JarEntry je;
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        while ((je = ji.getNextJarEntry()) != null) {
            byte[] oldb;
            if (je.isDirectory()) continue;
            int len = (int)je.getSize();
            if (len == -1) {
                len = 8192;
            }
            byte[] b = new byte[len];
            int pos = 0;
            do {
                int n;
                if (pos == len) {
                    oldb = b;
                    b = new byte[len *= 2];
                    System.arraycopy(oldb, 0, b, 0, oldb.length);
                }
                while (len - pos > 0 && (n = ji.read(b, pos, len - pos)) > 0) {
                    pos += n;
                }
            } while (ji.available() > 0);
            if (pos != b.length) {
                oldb = b;
                b = new byte[pos];
                System.arraycopy(oldb, 0, b, 0, pos);
            }
            files.put(je.getName(), b);
        }
        return files;
    }
}

