/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import org.knopflerfish.framework.permissions.PermissionsHandle;

class FrameworkPolicy
extends Policy {
    private final Policy defaultPolicy;
    private PermissionsHandle ph;

    FrameworkPolicy(Policy policy, PermissionsHandle ph) {
        this.defaultPolicy = policy;
        this.ph = ph;
    }

    public PermissionCollection getPermissions(ProtectionDomain pd) {
        if (null == pd) {
            return this.defaultPolicy.getPermissions(pd);
        }
        CodeSource cs = pd.getCodeSource();
        if (null == cs) {
            return this.defaultPolicy.getPermissions(pd);
        }
        URL u = cs.getLocation();
        if (u != null && "bundle".equals(u.getProtocol())) {
            return this.getPermissions(cs);
        }
        return this.defaultPolicy.getPermissions(pd);
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        if (null == cs) {
            return this.defaultPolicy.getPermissions(cs);
        }
        URL u = cs.getLocation();
        if (u != null && "bundle".equals(u.getProtocol())) {
            try {
                Long id = new Long(u.getHost());
                return this.ph.getPermissionCollection(id);
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        }
        return this.defaultPolicy.getPermissions(cs);
    }

    public boolean implies(ProtectionDomain pd, Permission p) {
        if (null == pd) {
            return this.defaultPolicy.implies(pd, p);
        }
        CodeSource cs = pd.getCodeSource();
        if (null == cs) {
            return this.defaultPolicy.implies(pd, p);
        }
        URL u = cs.getLocation();
        if (u != null && "bundle".equals(u.getProtocol())) {
            return super.implies(pd, p);
        }
        return this.defaultPolicy.implies(pd, p);
    }

    public void refresh() {
        this.defaultPolicy.refresh();
    }
}

