/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.DataInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionsWrapper
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    String location;
    private PermissionInfoStorage pinfos;
    private PermissionCollection implicitPermissions;
    private PermissionCollection localPermissions;
    private PermissionCollection systemPermissions;
    private File dataRoot;
    private boolean readOnly = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$FilePermission;

    PermissionsWrapper(Framework fw, PermissionInfoStorage pis, String loc, Bundle b, InputStream localPerms) {
        this.pinfos = pis;
        this.location = loc;
        this.dataRoot = fw.getDataStorage(b.getBundleId());
        this.localPermissions = localPerms != null ? this.makeLocalPermissionCollection(localPerms) : null;
        this.implicitPermissions = this.makeImplicitPermissionCollection(fw, b);
        this.systemPermissions = this.makePermissionCollection();
    }

    public void add(Permission permission) {
        this.getPerms().add(permission);
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Enumeration implicitElements;
            private Enumeration systemElements;
            {
                this.implicitElements = PermissionsWrapper.this.implicitPermissions.elements();
                this.systemElements = PermissionsWrapper.this.getPerms().elements();
            }

            public boolean hasMoreElements() {
                if (this.implicitElements != null) {
                    if (this.implicitElements.hasMoreElements()) {
                        return true;
                    }
                    this.implicitElements = null;
                }
                return this.systemElements.hasMoreElements();
            }

            public Object nextElement() {
                if (this.implicitElements != null) {
                    try {
                        return this.implicitElements.nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.implicitElements = null;
                    }
                }
                return this.systemElements.nextElement();
            }
        };
    }

    public boolean implies(Permission permission) {
        if (this.implicitPermissions.implies(permission)) {
            return true;
        }
        if (this.localPermissions != null && !this.localPermissions.implies(permission)) {
            return false;
        }
        return this.getPerms().implies(permission);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        if (!this.readOnly) {
            this.readOnly = true;
            this.getPerms().setReadOnly();
        }
    }

    synchronized void invalidate() {
        this.systemPermissions = null;
    }

    synchronized void updateLocalPermissions(InputStream localPerms) {
        this.localPermissions = localPerms != null ? this.makeLocalPermissionCollection(localPerms) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPerms() {
        PermissionCollection p = this.systemPermissions;
        if (p == null) {
            PermissionsWrapper permissionsWrapper = this;
            synchronized (permissionsWrapper) {
                p = this.systemPermissions;
                if (p == null) {
                    p = this.makePermissionCollection();
                    if (this.readOnly) {
                        p.setReadOnly();
                    }
                    this.systemPermissions = p;
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection makeLocalPermissionCollection(InputStream localPerms) {
        try {
            String l;
            DataInputStream dis = new DataInputStream(localPerms);
            Permissions res = new Permissions();
            while ((l = dis.readLine()) != null) {
                if ((l = l.trim()).startsWith("#") || l.startsWith("//") || l.length() == 0) continue;
                try {
                    Permission p = this.makePermission(new PermissionInfo(l), false);
                    if (p == null) continue;
                    res.add(p);
                }
                catch (Exception e) {}
            }
            Permissions permissions = res;
            return permissions;
        }
        catch (IOException e) {
            PermissionCollection permissionCollection = null;
            return permissionCollection;
        }
        finally {
            try {
                localPerms.close();
            }
            catch (IOException _ignore) {}
        }
    }

    private PermissionCollection makeImplicitPermissionCollection(Framework fw, Bundle b) {
        Permissions pc = new Permissions();
        if (this.dataRoot != null) {
            pc.add(new FilePermission(this.dataRoot.getPath(), "read,write"));
            pc.add(new FilePermission(new File(this.dataRoot, "-").getPath(), "read,write,delete"));
        }
        pc.add(new AdminPermission(b, "resource,metadata,class"));
        return pc;
    }

    private PermissionCollection makePermissionCollection() {
        boolean usingDefault;
        PermissionInfo[] pi = this.pinfos.get(this.location, this);
        if (pi == null) {
            pi = this.pinfos.getDefault(this);
            usingDefault = true;
        } else {
            usingDefault = false;
        }
        Permissions res = new Permissions();
        for (int i = pi.length - 1; i >= 0; --i) {
            Permission p = this.makePermission(pi[i], usingDefault);
            if (p == null) continue;
            res.add(p);
        }
        return res;
    }

    private Permission makePermission(PermissionInfo pi, boolean usingDefault) {
        String a = pi.getActions();
        String n = pi.getName();
        String t = pi.getType();
        try {
            Class<?> pc = Class.forName(t);
            Constructor<?> c = pc.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PermissionsWrapper.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PermissionsWrapper.class$("java.lang.String")) : class$java$lang$String);
            if ((class$java$io$FilePermission == null ? (class$java$io$FilePermission = PermissionsWrapper.class$("java.io.FilePermission")) : class$java$io$FilePermission).equals(pc)) {
                File f = new File(n);
                if (!f.isAbsolute()) {
                    if (usingDefault) {
                        return null;
                    }
                    f = new File(this.dataRoot, n);
                }
                n = f.getPath();
            }
            return (Permission)c.newInstance(n, a);
        }
        catch (ClassNotFoundException e) {
            return new UnresolvedPermission(t, n, a, null);
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (InstantiationException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException ignore) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

