/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.Main;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.Util;

public final class BundleClassLoader
extends ClassLoader {
    private final boolean debug = Debug.classLoader;
    private static final ClassLoader parent = (class$org$knopflerfish$framework$Framework == null ? (class$org$knopflerfish$framework$Framework = BundleClassLoader.class$("org.knopflerfish.framework.Framework")) : class$org$knopflerfish$framework$Framework).getClassLoader();
    private static boolean isJava2;
    final PermissionOps secure;
    final ProtectionDomain protectionDomain;
    private BundleArchive archive;
    private ArrayList fragments;
    private BundlePackages bpkgs;
    private static ArrayList bootDelegationPatterns;
    private static boolean bootDelegationUsed;
    static final SearchAction classSearch;
    static final SearchAction resourceSearch;
    static /* synthetic */ Class class$org$knopflerfish$framework$Framework;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    static void buildBootDelegationPatterns() {
        String bootDelegationString = System.getProperty("org.osgi.framework.bootdelegation");
        bootDelegationUsed = bootDelegationString != null;
        try {
            Iterator i = Util.parseEntries("org.osgi.framework.bootdelegation", bootDelegationString, true, true, false);
            while (i.hasNext()) {
                Map e = (Map)i.next();
                String key = (String)e.get("key");
                if (key.equals("*")) {
                    bootDelegationPatterns = null;
                    break;
                }
                if (key.endsWith(".*")) {
                    bootDelegationPatterns.add(key.substring(0, key.length() - 1));
                    continue;
                }
                if (key.endsWith(".")) {
                    Main.framework.listeners.frameworkError(Main.framework.systemBundle, new IllegalArgumentException("org.osgi.framework.bootdelegation entry ends with '.': " + key));
                    continue;
                }
                if (key.indexOf("*") != -1) {
                    Main.framework.listeners.frameworkError(Main.framework.systemBundle, new IllegalArgumentException("org.osgi.framework.bootdelegation entry contains a '*': " + key));
                    continue;
                }
                bootDelegationPatterns.add(key);
            }
        }
        catch (IllegalArgumentException e) {
            Main.framework.listeners.frameworkError(Main.framework.systemBundle, e);
        }
    }

    static boolean isBootDelegated(String className) {
        if (!bootDelegationUsed) {
            return false;
        }
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            String classPackage = className.substring(0, pos);
            if (bootDelegationPatterns == null) {
                return true;
            }
            Iterator i = ((AbstractList)bootDelegationPatterns).iterator();
            while (i.hasNext()) {
                String ps = (String)i.next();
                if ((!ps.endsWith(".") || !classPackage.regionMatches(0, ps, 0, ps.length() - 1)) && !classPackage.equals(ps)) continue;
                return true;
            }
        }
        return false;
    }

    BundleClassLoader(BundlePackages bpkgs, BundleArchive ba, ArrayList frags, ProtectionDomain pd, PermissionOps secure) {
        super(parent);
        this.secure = secure;
        this.protectionDomain = pd;
        this.bpkgs = bpkgs;
        this.archive = ba;
        this.fragments = frags;
        if (this.debug) {
            Debug.println(this + " Created new classloader");
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.")) {
            return parent.loadClass(name);
        }
        if (BundleClassLoader.isBootDelegated(name)) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (this.secure.okClassAdminPerm(this.bpkgs.bundle)) {
            String pkg;
            String path;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                path = name.replace('.', '/');
                pkg = name.substring(0, pos);
            } else {
                path = name;
                pkg = null;
            }
            Class res = (Class)this.secure.callSearchFor(this, name, pkg, path + ".class", classSearch, true, this, null);
            if (res != null) {
                return res;
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected String findLibrary(String name) {
        String res = this.archive.getNativeLibrary(name);
        if (res == null && this.fragments != null) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext() && (res = ((BundleArchive)i.next()).getNativeLibrary(name)) == null) {
            }
        }
        if (this.debug) {
            Debug.println(this + " Find library: " + name + (res != null ? " OK" : " FAIL"));
        }
        return res;
    }

    protected Enumeration findResources(String name) {
        return this.getBundleResources(name, false);
    }

    protected URL findResource(String name) {
        Enumeration res = this.getBundleResources(name, true);
        if (res != null) {
            return (URL)res.nextElement();
        }
        return null;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        URL res;
        if (this.debug) {
            Debug.println(this + " getResource: " + name);
        }
        if ((res = super.getResource(name)) == null && !isJava2) {
            return this.findResource(name);
        }
        return res;
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "BundleClassLoader(id=" + this.bpkgs.bundle.id + ",gen=" + this.bpkgs.generation + ")";
    }

    BundleImpl getBundle() {
        return this.bpkgs.bundle;
    }

    BundleArchive getBundleArchive(long frag) {
        if (frag >= 0L) {
            if (this.fragments != null) {
                Iterator i = ((AbstractList)this.fragments).iterator();
                while (i.hasNext()) {
                    BundleArchive ba = (BundleArchive)i.next();
                    if (ba.getBundleId() != frag) continue;
                    return ba;
                }
            }
            return null;
        }
        return this.archive;
    }

    void close() {
        this.archive = null;
        this.bpkgs.invalidateClassLoader();
        if (this.debug) {
            Debug.println(this + " Cleared archives");
        }
    }

    void purge() {
        this.bpkgs.unregisterPackages(true);
        if (this.protectionDomain != null) {
            this.bpkgs.bundle.framework.perm.purge(this.bpkgs.bundle, this.protectionDomain);
        }
        if (this.archive != null) {
            this.archive.purge();
        }
        if (this.fragments != null) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                BundleArchive ba = (BundleArchive)i.next();
                BundleImpl b = (BundleImpl)this.bpkgs.bundle.framework.bundles.getBundle(ba.getBundleLocation());
                if (b != null && b.archive == ba) continue;
                ba.purge();
            }
        }
        this.close();
    }

    Enumeration getBundleResources(String name, boolean onlyFirst) {
        if (this.secure.okResourceAdminPerm(this.bpkgs.bundle)) {
            if (this.debug) {
                Debug.println(this + " Find bundle resource" + (onlyFirst ? "" : "s") + ": " + name);
            }
            String pkg = null;
            int pos = name.lastIndexOf(47);
            if (pos > 0) {
                int start = name.startsWith("/") ? 1 : 0;
                pkg = name.substring(start, pos).replace('/', '.');
            } else {
                pkg = null;
            }
            return (Enumeration)this.secure.callSearchFor(this, null, pkg, name, resourceSearch, onlyFirst, this, null);
        }
        return null;
    }

    Hashtable getLocalizationEntries(String name) {
        Hashtable tmp;
        Hashtable localization_entries = null;
        if (this.fragments != null) {
            for (int i = this.fragments.size() - 1; i >= 0; --i) {
                BundleArchive ba = (BundleArchive)this.fragments.get(i);
                Hashtable tmp2 = ba.getLocalizationEntries(name);
                if (tmp2 == null) continue;
                if (localization_entries != null) {
                    localization_entries.putAll(tmp2);
                    continue;
                }
                localization_entries = tmp2;
            }
        }
        if ((tmp = this.archive.getLocalizationEntries(name)) != null) {
            if (localization_entries != null) {
                localization_entries.putAll(tmp);
            } else {
                localization_entries = tmp;
            }
        }
        return localization_entries;
    }

    BundlePackages getBpkgs() {
        return this.bpkgs;
    }

    Object searchFor(String name, String pkg, String path, SearchAction action, boolean onlyFirst, BundleClassLoader requestor, HashSet visited) {
        ExportPkg ep;
        BundlePackages pbp;
        Class<?> c;
        if (action == classSearch && requestor != this && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        if (this.debug) {
            Debug.println(this + " Search for: " + path);
        }
        if (pkg != null) {
            pbp = this.bpkgs.getProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bundle)) {
                    try {
                        return pbp.bundle.framework.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != this) {
                        if (cl != null) {
                            if (this.debug) {
                                Debug.println(this + " Import search: " + path + " from #" + pbp.bundle.id);
                            }
                            return this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited);
                        }
                        if (this.debug) {
                            Debug.println(this + " No import found: " + path);
                        }
                        return null;
                    }
                }
            } else {
                ArrayList pl = this.bpkgs.getRequiredBundlePackages(pkg);
                if (pl != null) {
                    if (visited == null) {
                        visited = new HashSet<BundleClassLoader>();
                    }
                    visited.add(this);
                    Iterator pi = ((AbstractList)pl).iterator();
                    while (pi.hasNext()) {
                        Object res;
                        BundleClassLoader cl;
                        pbp = (BundlePackages)pi.next();
                        if (pbp == null || (cl = (BundleClassLoader)pbp.getClassLoader()) == null || visited.contains(cl)) continue;
                        if (this.debug) {
                            Debug.println(this + " Required bundle search: " + path + " from #" + pbp.bundle.id);
                        }
                        if ((res = this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited)) == null) continue;
                        return res;
                    }
                }
            }
            ep = this.bpkgs.getExport(pkg);
        } else {
            ep = null;
        }
        if (this != requestor && ep != null && !ep.checkFilter(name)) {
            return null;
        }
        Vector av = this.archive.componentExists(path, onlyFirst);
        if (av != null) {
            try {
                return action.get(av, path, name, pkg, this, this.archive);
            }
            catch (IOException ioe) {
                this.bpkgs.bundle.framework.listeners.frameworkError(this.bpkgs.bundle, ioe);
                return null;
            }
        }
        if (this.fragments != null) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                Vector vec;
                BundleArchive ba = (BundleArchive)i.next();
                if (this.debug) {
                    Debug.println(this + " Fragment bundle search: " + path + " from #" + ba.getBundleId());
                }
                if ((vec = ba.componentExists(path, onlyFirst)) == null) continue;
                try {
                    return action.get(vec, path, name, pkg, this, ba);
                }
                catch (IOException ioe) {
                    this.bpkgs.bundle.framework.listeners.frameworkError(this.bpkgs.bundle, ioe);
                    return null;
                }
            }
        }
        if (ep != null) {
            return null;
        }
        if (pkg != null) {
            pbp = this.bpkgs.getDynamicProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bundle)) {
                    try {
                        return pbp.bundle.framework.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != null) {
                        if (this.debug) {
                            Debug.println(this + " Dynamic import search: " + path + " from #" + pbp.bundle.id);
                        }
                        return this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited);
                    }
                }
            }
            if (this.debug) {
                Debug.println(this + " No dynamic import: " + path);
            }
        }
        return null;
    }

    private static boolean isSystemBundle(BundleImpl bundle) {
        return bundle == bundle.framework.systemBundle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        bootDelegationPatterns = new ArrayList(1);
        try {
            (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("findLibrary", class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String);
            isJava2 = true;
        }
        catch (NoSuchMethodException ignore) {
            isJava2 = false;
        }
        BundleClassLoader.buildBootDelegationPatterns();
        classSearch = new SearchAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Vector items, String path, String name, String pkg, BundleClassLoader cl, BundleArchive ba) throws IOException {
                byte[] bytes = ba.getClassBytes((Integer)items.get(0), path);
                if (bytes != null) {
                    if (Debug.classLoader) {
                        Debug.println("classLoader(#" + ((BundleClassLoader)cl).bpkgs.bundle.id + ") - load class: " + name);
                    }
                    BundleClassLoader bundleClassLoader = cl;
                    synchronized (bundleClassLoader) {
                        Class c = cl.findLoadedClass(name);
                        if (c == null) {
                            if (pkg != null && cl.getPackage(pkg) == null) {
                                cl.definePackage(pkg, null, null, null, null, null, null, null);
                            }
                            c = cl.protectionDomain == null ? cl.defineClass(name, bytes, 0, bytes.length) : cl.defineClass(name, bytes, 0, bytes.length, cl.protectionDomain);
                        }
                        return c;
                    }
                }
                return null;
            }
        };
        resourceSearch = new SearchAction(){

            public Object get(Vector items, String path, String name, String _pkg, BundleClassLoader cl, BundleArchive ba) {
                Vector<URL> answer = new Vector<URL>(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    int subId = (Integer)items.elementAt(i);
                    URL url = ((BundleClassLoader)cl).bpkgs.bundle.getURL(((BundleClassLoader)cl).bpkgs.generation, ba.getBundleId(), subId, path);
                    if (url != null) {
                        if (Debug.classLoader) {
                            Debug.println("classLoader(#" + ((BundleClassLoader)cl).bpkgs.bundle.id + ") - found: " + path + " -> " + url);
                        }
                    } else {
                        return null;
                    }
                    answer.addElement(url);
                }
                return answer.elements();
            }
        };
    }

    static interface SearchAction {
        public Object get(Vector var1, String var2, String var3, String var4, BundleClassLoader var5, BundleArchive var6) throws IOException;
    }
}

