/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.MainClassBundleActivator;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

class BundleImpl
implements Bundle {
    static int RESOLVED_FLAGS = 60;
    final Framework framework;
    final PermissionOps secure;
    final long id;
    final String location;
    boolean v2Manifest;
    String symbolicName;
    boolean singleton;
    Version version;
    int state;
    BundlePackages bpkgs;
    BundleArchive archive;
    int generation = 0;
    private ProtectionDomain protectionDomain;
    private ClassLoader classLoader = null;
    private HashMap oldClassLoaders = null;
    protected FileTree bundleDir = null;
    protected BundleContextImpl bundleContext = null;
    protected BundleActivator bactivator = null;
    protected long lastModified;
    boolean bDelayedStart = false;
    ArrayList fragments = null;
    String attachPolicy;
    Fragment fragment = null;
    private HeaderDictionary cachedHeaders = null;
    private HeaderDictionary cachedRawHeaders = null;

    BundleImpl(Framework fw, long id, String loc, ProtectionDomain pd, String sym, Version ver) {
        this.framework = fw;
        this.secure = fw.perm;
        this.id = id;
        this.location = loc;
        this.protectionDomain = pd;
        this.symbolicName = sym;
        this.singleton = false;
        this.version = ver;
        this.v2Manifest = true;
        this.attachPolicy = "always";
        this.modified();
    }

    BundleImpl(Framework fw, BundleArchive ba) {
        this.framework = fw;
        this.secure = fw.perm;
        this.id = ba.getBundleId();
        this.location = ba.getBundleLocation();
        this.archive = ba;
        this.state = 2;
        this.checkManifestHeaders();
        this.protectionDomain = this.secure.getProtectionDomain(this);
        this.doExportImport();
        this.bundleDir = fw.getDataStorage(this.id);
        int oldStartLevel = this.archive.getStartLevel();
        try {
            if (this.framework.startLevelService == null) {
                this.archive.setStartLevel(0);
            } else if (oldStartLevel == -1) {
                this.archive.setStartLevel(this.framework.startLevelService.getInitialBundleStartLevel());
            }
        }
        catch (Exception e) {
            Debug.println("Failed to set start level on #" + this.id + ": " + e);
        }
        if (this.isExtension() && this.resolveFragment(this.framework.systemBundle)) {
            this.state = 4;
        }
        this.lastModified = this.archive.getLastModified();
        if (this.lastModified == 0L) {
            this.modified();
        }
    }

    public int getState() {
        return this.state;
    }

    public synchronized void start() throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        if (this.isFragment()) {
            throw new BundleException("Cannot start a fragment bundle");
        }
        if (this.framework.startLevelService != null && this.state != 1 && this.getStartLevel() > this.framework.startLevelService.getStartLevel()) {
            this.secure.callSetPersistent(this, true);
            this.bDelayedStart = true;
            return;
        }
        switch (this.getUpdatedState()) {
            case 2: {
                throw new BundleException("Failed, " + this.bpkgs.getResolveFailReason());
            }
            case 4: {
                if (this.framework.active) {
                    this.state = 8;
                    this.framework.listeners.bundleChanged(new BundleEvent(128, this));
                    this.bundleContext = new BundleContextImpl(this);
                    try {
                        this.secure.callStart0(this);
                    }
                    catch (BundleException e) {
                        this.removeBundleResources();
                        this.bundleContext.invalidate();
                        this.bundleContext = null;
                        this.state = 4;
                        throw e;
                    }
                    this.framework.listeners.bundleChanged(new BundleEvent(2, this));
                    break;
                }
                this.secure.callSetPersistent(this, true);
                this.startOnLaunch(true);
                break;
            }
            case 32: {
                break;
            }
            case 8: {
                throw new BundleException("called from BundleActivator.start");
            }
            case 16: {
                throw new BundleException("called from BundleActivator.stop");
            }
            case 1: {
                throw new IllegalStateException("Bundle is in UNINSTALLED state");
            }
        }
    }

    void start0() throws BundleException {
        String ba = this.archive.getAttribute("Bundle-Activator");
        boolean bStarted = false;
        ClassLoader oldLoader = null;
        if (Framework.SETCONTEXTCLASSLOADER) {
            oldLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            if (Framework.SETCONTEXTCLASSLOADER) {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            if (ba != null) {
                Class<?> c = this.getClassLoader().loadClass(ba.trim());
                this.bactivator = (BundleActivator)c.newInstance();
                this.bactivator.start(this.bundleContext);
                bStarted = true;
            } else {
                String mc = this.archive.getAttribute("Main-class");
                if (mc != null) {
                    if (Debug.packages) {
                        Debug.println("starting main class " + mc);
                    }
                    Class<?> mainClass = this.getClassLoader().loadClass(mc.trim());
                    this.bactivator = MainClassBundleActivator.create(this.getClassLoader(), mainClass);
                    this.bactivator.start(this.bundleContext);
                    bStarted = true;
                }
            }
            if (!bStarted) {
                // empty if block
            }
            this.state = 32;
            this.setPersistent(true);
            this.startOnLaunch(true);
        }
        catch (Throwable t) {
            throw new BundleException("BundleActivator start failed", t);
        }
        finally {
            if (Framework.SETCONTEXTCLASSLOADER) {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    boolean allowSetStartOnLaunchFalse() {
        return !this.framework.shuttingdown && !this.archive.isPersistent();
    }

    public synchronized void stop() throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        if (this.isFragment()) {
            throw new BundleException("Cannot stop a fragment bundle");
        }
        this.bDelayedStart = false;
        switch (this.state) {
            case 2: 
            case 4: {
                this.secure.callSetPersistent(this, false);
                if (!this.allowSetStartOnLaunchFalse()) break;
                this.secure.callStartOnLaunch(this, false);
                break;
            }
            case 32: {
                BundleException savedException = this.secure.callStop0(this, true);
                if (savedException == null) break;
                throw savedException;
            }
            case 8: {
                throw new BundleException("Bundle.start called from BundleActivator.stop");
            }
            case 16: {
                throw new BundleException("Bundle.stop called from BundleActivator.stop");
            }
            case 1: {
                throw new IllegalStateException("Bundle.stop: Bundle is in UNINSTALLED state");
            }
        }
    }

    synchronized BundleException stop0(boolean resetPersistent) {
        BundleException res = null;
        this.state = 16;
        this.framework.listeners.bundleChanged(new BundleEvent(256, this));
        if (resetPersistent) {
            this.setPersistent(false);
        }
        if (this.allowSetStartOnLaunchFalse()) {
            this.startOnLaunch(false);
        }
        if (this.bactivator != null) {
            try {
                this.bactivator.stop(this.bundleContext);
            }
            catch (Throwable e) {
                res = new BundleException("Bundle.stop: BundleActivator stop failed", e);
            }
            this.bactivator = null;
        }
        this.bundleContext.invalidate();
        this.bundleContext = null;
        this.removeBundleResources();
        this.state = 4;
        this.framework.listeners.bundleChanged(new BundleEvent(4, this));
        return res;
    }

    public void update() throws BundleException {
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void update(InputStream in) throws BundleException {
        try {
            this.secure.checkLifecycleAdminPerm(this);
            if (this.isExtension()) {
                this.secure.checkExtensionLifecycleAdminPerm(this);
            }
            boolean wasActive = this.state == 32;
            switch (this.getUpdatedState()) {
                case 32: {
                    this.stop();
                }
                case 2: 
                case 4: {
                    this.secure.callUpdate0(this, in, wasActive);
                    break;
                }
                case 8: {
                    throw new IllegalStateException("Bundle is in STARTING state");
                }
                case 16: {
                    throw new IllegalStateException("Bundle is in STOPPING state");
                }
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
            }
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ignore) {}
    }

    void update0(InputStream in, boolean wasActive) throws BundleException {
        boolean purgeOld;
        boolean wasResolved = this.state == 4;
        int oldStartLevel = this.getStartLevel();
        BundleArchive newArchive = null;
        try {
            InputStream bin;
            if (in == null) {
                String update = this.archive.getAttribute("Bundle-UpdateLocation");
                if (update == null) {
                    update = this.location;
                }
                bin = new URL(update).openStream();
            } else {
                bin = in;
            }
            newArchive = this.framework.storage.updateBundleArchive(this.archive, bin);
            this.checkEE(newArchive);
            this.checkManifestHeaders();
            newArchive.setStartLevel(oldStartLevel);
            this.framework.storage.replaceBundleArchive(this.archive, newArchive);
        }
        catch (Exception e) {
            if (newArchive != null) {
                newArchive.purge();
            }
            if (wasActive) {
                try {
                    this.start();
                }
                catch (BundleException be) {
                    this.framework.listeners.frameworkError(this, be);
                }
            }
            if (e instanceof BundleException) {
                throw (BundleException)e;
            }
            throw new BundleException("Failed to get update bundle", e);
        }
        if (this.isFragment()) {
            if (this.isAttached()) {
                this.fragment.setHost(null);
                purgeOld = false;
            } else {
                purgeOld = true;
            }
        } else {
            boolean allRemoved = this.bpkgs.unregisterPackages(false);
            if (allRemoved) {
                if (this.classLoader != null) {
                    ((BundleClassLoader)this.classLoader).close();
                    this.classLoader = null;
                }
                purgeOld = true;
            } else {
                this.saveZombiePackages();
                purgeOld = false;
            }
        }
        BundleArchive oldArchive = this.archive;
        this.archive = newArchive;
        this.cachedRawHeaders = null;
        this.state = 2;
        ProtectionDomain oldProtectionDomain = this.protectionDomain;
        this.protectionDomain = this.secure.getProtectionDomain(this);
        this.doExportImport();
        if (purgeOld) {
            this.secure.purge(this, oldProtectionDomain);
            oldArchive.purge();
        }
        if (wasResolved) {
            this.framework.listeners.bundleChanged(new BundleEvent(64, this));
        }
        this.framework.listeners.bundleChanged(new BundleEvent(8, this));
        if (wasActive) {
            try {
                this.start();
            }
            catch (BundleException be) {
                this.framework.listeners.frameworkError(this, be);
            }
        }
        this.modified();
    }

    void checkEE(BundleArchive ba) throws BundleException {
        String ee = ba.getAttribute("Bundle-RequiredExecutionEnvironment");
        if (ee != null) {
            if (Debug.packages) {
                Debug.println("bundle #" + ba.getBundleId() + " has EE=" + ee);
            }
            if (!this.framework.isValidEE(ee)) {
                throw new BundleException("Execution environment '" + ee + "' is not supported");
            }
        }
    }

    public synchronized void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        if (this.isExtension()) {
            this.secure.checkExtensionLifecycleAdminPerm(this);
        }
        this.secure.callUninstall0(this);
    }

    void uninstall0() {
        boolean wasResolved = false;
        try {
            this.archive.setStartLevel(-2);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.cachedHeaders = this.getHeaders0(null);
        this.bDelayedStart = false;
        switch (this.state) {
            case 32: {
                try {
                    this.stop();
                }
                catch (BundleException be) {
                    this.framework.listeners.frameworkError(this, be);
                }
            }
            case 4: {
                wasResolved = true;
            }
            case 2: {
                this.framework.bundles.remove(this.location);
                if (this.isFragment()) {
                    if (this.isAttached()) {
                        this.classLoader = null;
                        this.fragment.setHost(null);
                    } else {
                        this.secure.purge(this, this.protectionDomain);
                        this.archive.purge();
                    }
                } else {
                    if (this.bpkgs.unregisterPackages(false)) {
                        if (this.classLoader != null) {
                            ((BundleClassLoader)this.classLoader).purge();
                            this.classLoader = null;
                        } else {
                            this.secure.purge(this, this.protectionDomain);
                            this.archive.purge();
                        }
                    } else {
                        this.saveZombiePackages();
                        this.classLoader = null;
                    }
                    if (this.isFragmentHost()) {
                        this.detachFragments(true);
                    }
                }
                this.bpkgs = null;
                this.bactivator = null;
                if (this.bundleDir != null) {
                    if (!this.bundleDir.delete()) {
                        try {
                            this.archive.setStartLevel(-2);
                        }
                        catch (Exception e) {
                            Debug.println("Failed to mark bundle " + this.id + " as uninstalled, " + this.bundleDir + " must be deleted manually: " + e);
                        }
                    }
                    this.bundleDir = null;
                }
                this.state = 1;
                this.modified();
                if (wasResolved) {
                    this.framework.listeners.bundleChanged(new BundleEvent(64, this));
                }
                this.framework.listeners.bundleChanged(new BundleEvent(16, this));
                break;
            }
            case 8: {
                throw new IllegalStateException("Bundle is in STARTING state");
            }
            case 16: {
                throw new IllegalStateException("Bundle is in STOPPING state");
            }
            case 1: {
                throw new IllegalStateException("Bundle is in UNINSTALLED state");
            }
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public long getBundleId() {
        return this.id;
    }

    public String getLocation() {
        this.secure.checkMetadataAdminPerm(this);
        return this.location;
    }

    public ServiceReference[] getRegisteredServices() {
        Set sr = this.framework.services.getRegisteredByBundle(this);
        this.secure.filterGetServicePermission(sr);
        ServiceReference[] res = new ServiceReference[sr.size()];
        int pos = 0;
        Iterator i = sr.iterator();
        while (i.hasNext()) {
            res[pos++] = ((ServiceRegistration)i.next()).getReference();
        }
        return res;
    }

    public ServiceReference[] getServicesInUse() {
        Set sr = this.framework.services.getUsedByBundle(this);
        this.secure.filterGetServicePermission(sr);
        ServiceReference[] res = new ServiceReference[sr.size()];
        int pos = 0;
        Iterator i = sr.iterator();
        while (i.hasNext()) {
            res[pos++] = ((ServiceRegistration)i.next()).getReference();
        }
        return res;
    }

    public boolean hasPermission(Object permission) {
        this.checkUninstalled();
        if (permission instanceof Permission) {
            if (this.secure.checkPermissions()) {
                PermissionCollection pc = this.protectionDomain.getPermissions();
                return pc != null ? pc.implies((Permission)permission) : false;
            }
            return true;
        }
        return false;
    }

    public URL getResource(String name) {
        Enumeration res;
        BundleClassLoader cl;
        this.checkUninstalled();
        if (this.isFragment()) {
            return null;
        }
        if (this.state == 2 && !this.secure.okResourceAdminPerm(this)) {
            return null;
        }
        if (this.getUpdatedState() != 2 && (cl = (BundleClassLoader)this.getClassLoader()) != null && (res = cl.getBundleResources(name, true)) != null) {
            return (URL)res.nextElement();
        }
        return null;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUpdatedState() {
        if (this.state == 2) {
            BundleImpl bundleImpl = this;
            synchronized (bundleImpl) {
                if (this.state == 2) {
                    if (this.isFragment()) {
                        BundleImpl host = this.getFragmentHost();
                        if (host != null && host.state == 2) {
                            host.getUpdatedState();
                        }
                    } else {
                        this.attachFragments();
                        if (this.bpkgs.resolvePackages()) {
                            List fe;
                            BundleImpl b;
                            Iterator i;
                            if (this.fragments != null) {
                                i = ((AbstractList)this.fragments).iterator();
                                while (i.hasNext()) {
                                    b = (BundleImpl)i.next();
                                    b.state = 4;
                                }
                            }
                            this.state = 4;
                            if (this.fragments != null) {
                                i = ((AbstractList)this.fragments).iterator();
                                while (i.hasNext()) {
                                    b = (BundleImpl)i.next();
                                    this.framework.listeners.bundleChanged(new BundleEvent(32, b));
                                }
                            }
                            this.framework.listeners.bundleChanged(new BundleEvent(32, this));
                            if (this.id != 0L && (fe = this.archive.getFailedClassPathEntries()) != null) {
                                Iterator i2 = fe.iterator();
                                while (i2.hasNext()) {
                                    IOException e = new IOException("Failed to classpath entry: " + i2.next());
                                    this.framework.listeners.frameworkInfo(this, e);
                                }
                            }
                        } else {
                            this.detachFragments(false);
                        }
                    }
                }
            }
        }
        return this.state;
    }

    boolean resolveFragment(BundleImpl host) {
        if (host == this.getFragmentHost() && this.secure.okFragmentBundlePerm(this)) {
            try {
                host.attachFragment(this);
                this.fragment.setHost(host);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    File getDataRoot() {
        return this.bundleDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            BundleImpl bundleImpl = this;
            synchronized (bundleImpl) {
                if (this.classLoader == null && (this.state & RESOLVED_FLAGS) != 0) {
                    this.classLoader = this.secure.callGetClassLoader0(this);
                }
            }
        }
        return this.classLoader;
    }

    ClassLoader getClassLoader0() {
        ArrayList<BundleArchive> frags;
        if (this.isFragment()) {
            if (this.isAttached()) {
                if (this.isBootClassPathExtension()) {
                    ClassLoader root = ClassLoader.getSystemClassLoader();
                    while (root.getParent() != null) {
                        root = root.getParent();
                    }
                    return root;
                }
                return this.getFragmentHost().getClassLoader();
            }
            return null;
        }
        if (this.isFragmentHost()) {
            frags = new ArrayList<BundleArchive>();
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                frags.add(((BundleImpl)i.next()).archive);
            }
        } else {
            frags = null;
        }
        return new BundleClassLoader(this.bpkgs, this.archive, frags, this.protectionDomain, this.secure);
    }

    synchronized void setStateInstalled(boolean sendEvent) {
        if (this.isFragment()) {
            this.classLoader = null;
            this.fragment.setHost(null);
        } else {
            if (this.classLoader != null) {
                ((BundleClassLoader)this.classLoader).close();
                this.classLoader = null;
            }
            this.bpkgs.unregisterPackages(true);
            if (this.isFragmentHost()) {
                this.detachFragments(true);
            }
            this.bpkgs.registerPackages();
        }
        this.state = 2;
        if (sendEvent) {
            this.framework.listeners.bundleChanged(new BundleEvent(64, this));
        }
    }

    ClassLoader getClassLoader(BundlePackages ebpkgs) {
        if (this.bpkgs == ebpkgs) {
            return this.getClassLoader();
        }
        if (this.oldClassLoaders != null) {
            return (ClassLoader)this.oldClassLoaders.get(ebpkgs);
        }
        return null;
    }

    void purge() {
        if (this.state == 1) {
            this.framework.bundles.remove(this.location);
        }
        if (this.oldClassLoaders != null) {
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                ((BundleClassLoader)i.next()).purge();
            }
            this.oldClassLoaders = null;
        }
    }

    BundleArchive getBundleArchive(long gen, long frag) {
        if (gen == -1L || this.bpkgs != null && (long)this.bpkgs.generation == gen) {
            if (frag == -1L) {
                return this.archive;
            }
            return ((BundleClassLoader)this.getClassLoader()).getBundleArchive(frag);
        }
        Iterator i = this.oldClassLoaders.values().iterator();
        while (i.hasNext()) {
            BundleClassLoader cl = (BundleClassLoader)i.next();
            if ((long)cl.getBpkgs().generation != gen) continue;
            return cl.getBundleArchive(frag);
        }
        return null;
    }

    Iterator getExports() {
        if (this.oldClassLoaders != null) {
            HashSet res = new HashSet();
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                Iterator j = ((BundleClassLoader)i.next()).getBpkgs().getExports();
                while (j.hasNext()) {
                    res.add(j.next());
                }
            }
            if (this.bpkgs != null) {
                i = this.bpkgs.getExports();
                while (i.hasNext()) {
                    res.add(i.next());
                }
            }
            return res.iterator();
        }
        if (this.bpkgs != null) {
            return this.bpkgs.getExports();
        }
        return ((AbstractList)new ArrayList(0)).iterator();
    }

    Iterator getImports() {
        if (this.oldClassLoaders != null) {
            HashSet res = new HashSet();
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                Iterator j = ((BundleClassLoader)i.next()).getBpkgs().getImports();
                while (j.hasNext()) {
                    res.add(j.next());
                }
            }
            if (this.bpkgs != null) {
                i = this.bpkgs.getImports();
                while (i.hasNext()) {
                    res.add(i.next());
                }
            }
            return res.iterator();
        }
        if (this.bpkgs != null) {
            return this.bpkgs.getImports();
        }
        return ((AbstractList)new ArrayList(0)).iterator();
    }

    URL getURL(long gen, long frag, int bcpElem, String path) {
        try {
            StringBuffer u = new StringBuffer("bundle");
            u.append("://");
            u.append(this.id);
            if (gen != -1L) {
                u.append('.').append(gen);
            }
            if (frag != -1L && frag != this.id) {
                u.append('_').append(frag);
            }
            if (bcpElem >= 0) {
                u.append(':').append(bcpElem);
            }
            if (!path.startsWith("/")) {
                u.append('/');
            }
            u.append(path);
            return new URL(u.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void checkManifestHeaders() {
        this.v2Manifest = "2".equals(this.archive.getAttribute("Bundle-ManifestVersion"));
        Iterator i = Util.parseEntries("Bundle-SymbolicName", this.archive.getAttribute("Bundle-SymbolicName"), true, true, true);
        Map e = null;
        if (i.hasNext()) {
            e = (Map)i.next();
            this.symbolicName = (String)e.get("key");
        } else {
            if (this.v2Manifest) {
                throw new IllegalArgumentException("Bundle has no symbolic name, location=" + this.location);
            }
            this.symbolicName = null;
        }
        String mbv = this.archive.getAttribute("Bundle-Version");
        if (mbv != null) {
            try {
                this.version = new Version(mbv);
            }
            catch (Throwable ee) {
                if (this.v2Manifest) {
                    throw new IllegalArgumentException("Bundle does not specify a valid Bundle-Version header. Got exception: " + ee.getMessage());
                }
                this.version = Version.emptyVersion;
            }
        } else {
            this.version = Version.emptyVersion;
        }
        this.attachPolicy = "always";
        if (e != null) {
            this.singleton = "true".equals((String)e.get("singleton"));
            BundleImpl snb = this.framework.bundles.getBundle(this.symbolicName, this.version);
            String tmp = (String)e.get("fragment-attachment");
            String string = this.attachPolicy = tmp == null ? "always" : tmp;
            if (snb != null && snb != this) {
                throw new IllegalArgumentException("Bundle with same symbolic name and version is already installed (" + this.symbolicName + ", " + this.version);
            }
        } else {
            this.singleton = false;
        }
        if ((i = Util.parseEntries("Fragment-Host", this.archive.getAttribute("Fragment-Host"), true, true, true)).hasNext()) {
            if (this.archive.getAttribute("Bundle-Activator") != null) {
                throw new IllegalArgumentException("A fragment bundle can not have a Bundle-Activator.");
            }
            e = (Map)i.next();
            String extension = (String)e.get("extension");
            String key = (String)e.get("key");
            if ("framework".equals(extension) || "bootclasspath".equals(extension)) {
                if (!"system.bundle".equals(key) && !"org.knopflerfish.framework".equals(key)) {
                    throw new IllegalArgumentException("An extension bundle must target the system bundle(=system.bundle)");
                }
                if (this.archive.getAttribute("Import-Package") != null || this.archive.getAttribute("Require-Bundle") != null || this.archive.getAttribute("Bundle-NativeCode") != null || this.archive.getAttribute("DynamicImport-Package") != null || this.archive.getAttribute("Bundle-Activator") != null) {
                    throw new IllegalArgumentException("An extension bundle cannot specify: Import-Package, Require-Bundle, Bundle-NativeCode, DynamicImport-Package or Bundle-Activator");
                }
                if (!Framework.SUPPORTS_EXTENSION_BUNDLES) {
                    if (Framework.bIsMemoryStorage) {
                        throw new UnsupportedOperationException("Extension bundles are not supported in memory storage mode.");
                    }
                    if (!Framework.EXIT_ON_SHUTDOWN) {
                        throw new UnsupportedOperationException("Extension bundles require that the property org.knopflerfish.framework.exitonshutdown is set to \"true\"");
                    }
                    if (!Framework.USING_WRAPPER_SCRIPT) {
                        throw new UnsupportedOperationException("Extension bundles require the use of a wrapper script. Consult the documentation");
                    }
                    throw new UnsupportedOperationException("Extension bundles are not supported.");
                }
            } else if (extension != null) {
                throw new IllegalArgumentException("Did not recognize directive extension:=" + extension + ".");
            }
            if (this.fragment == null) {
                this.fragment = new Fragment(key, extension, (String)e.get("bundle-version"));
            }
        }
    }

    void startOnLaunch(boolean value) {
        try {
            this.archive.setStartOnLaunchFlag(value);
        }
        catch (IOException e) {
            this.framework.listeners.frameworkError(this, e);
        }
    }

    void setPersistent(boolean value) {
        try {
            this.archive.setPersistent(value);
        }
        catch (Exception e) {
            this.framework.listeners.frameworkError(this, e);
        }
    }

    void doExportImport() {
        this.bpkgs = new BundlePackages(this, this.generation++, this.archive.getAttribute("Export-Package"), this.archive.getAttribute("Import-Package"), this.archive.getAttribute("DynamicImport-Package"), this.archive.getAttribute("Require-Bundle"));
        if (!this.isFragment()) {
            this.bpkgs.registerPackages();
        }
    }

    private void removeBundleResources() {
        this.framework.listeners.removeAllListeners(this);
        Set srs = this.framework.services.getRegisteredByBundle(this);
        Iterator i = srs.iterator();
        while (i.hasNext()) {
            try {
                ((ServiceRegistration)i.next()).unregister();
            }
            catch (IllegalStateException ignore) {}
        }
        Set s = this.framework.services.getUsedByBundle(this);
        Iterator i2 = s.iterator();
        while (i2.hasNext()) {
            ((ServiceRegistrationImpl)i2.next()).reference.ungetService(this, false);
        }
    }

    private void saveZombiePackages() {
        if (this.oldClassLoaders == null) {
            this.oldClassLoaders = new HashMap();
        }
        this.oldClassLoaders.put(this.bpkgs, this.getClassLoader());
        this.classLoader = null;
    }

    boolean isPersistent() {
        return this.bDelayedStart || this.archive.isPersistent();
    }

    int getStartLevel() {
        if (this.archive != null) {
            return this.archive.getStartLevel();
        }
        return 0;
    }

    void setStartLevel(int n) {
        if (this.archive != null) {
            try {
                this.archive.setStartLevel(n);
            }
            catch (Exception e) {
                Debug.println("Failed to set start level on #" + this.getBundleId());
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int detail) {
        StringBuffer sb = new StringBuffer();
        sb.append("BundleImpl[");
        sb.append("id=" + this.getBundleId());
        if (detail > 0) {
            sb.append(", state=" + this.getState());
        }
        if (detail > 1) {
            sb.append(", startlevel=" + this.getStartLevel());
        }
        if (detail > 3) {
            sb.append(", bDelayedStart=" + this.bDelayedStart);
        }
        if (detail > 4) {
            try {
                sb.append(", bPersistant=" + this.isPersistent());
            }
            catch (Exception e) {
                sb.append(", bPersistant=" + e);
            }
        }
        if (detail > 4) {
            sb.append(", loc=" + this.location);
        }
        if (detail > 4) {
            sb.append(", symName=" + this.symbolicName);
        }
        sb.append("]");
        return sb.toString();
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        if (this.secure.okResourceAdminPerm(this)) {
            if (this.state == 2 && !this.framework.bundles.getFragmentBundles(this).isEmpty()) {
                this.getUpdatedState();
            }
            return this.secure.callFindEntries0(this, path, filePattern, recurse);
        }
        return null;
    }

    Enumeration findEntries0(String path, String filePattern, boolean recurse) {
        Vector res = new Vector();
        if (this.isFragmentHost()) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                BundleImpl fb = (BundleImpl)i.next();
                fb.addResourceEntries(res, path, filePattern, recurse);
            }
        }
        this.addResourceEntries(res, path, filePattern, recurse);
        return res.size() != 0 ? res.elements() : null;
    }

    void addResourceEntries(Vector res, String path, String pattern, boolean recurse) {
        Enumeration e = this.archive.findResourcesPath(path);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL url;
                String fp = (String)e.nextElement();
                if (fp.endsWith("/")) {
                    if (!recurse) continue;
                    this.addResourceEntries(res, fp, pattern, recurse);
                    continue;
                }
                int l = fp.lastIndexOf(47);
                if (pattern != null && !Util.filterMatch(pattern, fp.substring(l + 1)) || (url = this.getURL(-1L, -1L, -1, fp)) == null) continue;
                res.add(url);
            }
        }
    }

    public URL getEntry(String name) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            try {
                InputStream is = this.secure.callGetInputStream(this.archive, name, 0);
                if (is != null) {
                    is.close();
                    return this.getURL(-1L, -1L, -1, name);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Enumeration getEntryPaths(String path) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            return this.secure.callFindResourcesPath(this.archive, path);
        }
        return null;
    }

    private Dictionary getLocaleDictionary(String locale, String baseName) {
        String defaultLocale = Locale.getDefault().toString();
        if (locale == null) {
            locale = defaultLocale;
        } else if (locale.equals("")) {
            return null;
        }
        Hashtable localization_entries = new Hashtable();
        this.readLocalization("", localization_entries, baseName);
        this.readLocalization(Locale.getDefault().toString(), localization_entries, baseName);
        if (!locale.equals(defaultLocale)) {
            this.readLocalization(locale, localization_entries, baseName);
        }
        return localization_entries;
    }

    private HeaderDictionary localize(Dictionary localization_entries) {
        HeaderDictionary localized = (HeaderDictionary)this.cachedRawHeaders.clone();
        if (localization_entries != null) {
            Enumeration e = localized.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String unlocalizedEntry = (String)localized.get(key);
                if (!unlocalizedEntry.startsWith("%")) continue;
                String k = unlocalizedEntry.substring(1);
                String val = (String)localization_entries.get(k);
                if (val == null) {
                    localized.put(key, k);
                    continue;
                }
                localized.put(key, val);
            }
        }
        return localized;
    }

    /*
     * WARNING - void declaration
     */
    protected void readLocalization(String locale, Hashtable localization_entries, String baseName) {
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        int o = 0;
        String[] parts = Util.splitwords(locale, "_");
        String tmploc = "".equals(parts[0]) ? baseName : baseName + "_" + parts[0];
        while (true) {
            void var7_7;
            Hashtable tmp;
            if ((this.state & RESOLVED_FLAGS) != 0) {
                tmp = ((BundleClassLoader)this.getClassLoader()).getLocalizationEntries(tmploc + ".properties");
            } else if (this.archive != null) {
                tmp = this.archive.getLocalizationEntries(tmploc + ".properties");
            } else {
                return;
            }
            if (var7_7 != null) {
                localization_entries.putAll(var7_7);
            }
            if (++o >= parts.length) break;
            tmploc = tmploc + "_" + parts[o];
        }
    }

    public Dictionary getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        return this.secure.callGetHeaders0(this, locale);
    }

    HeaderDictionary getHeaders0(String locale) {
        if (this.cachedRawHeaders == null) {
            this.cachedRawHeaders = this.archive.getUnlocalizedAttributes();
        }
        if ("".equals(locale)) {
            return (HeaderDictionary)this.cachedRawHeaders.clone();
        }
        if (this.state == 1) {
            return (HeaderDictionary)this.cachedHeaders.clone();
        }
        String base = (String)this.cachedRawHeaders.get("Bundle-Localization");
        Dictionary d = this.isFragment() && this.fragment.host != null ? this.fragment.host.getLocaleDictionary(locale, base) : this.getLocaleDictionary(locale, base);
        return this.localize(d);
    }

    private void modified() {
        this.lastModified = System.currentTimeMillis();
        if (this.archive != null) {
            try {
                this.archive.setLastModified(this.lastModified);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Enumeration getResources(String name) throws IOException {
        BundleClassLoader cl;
        this.checkUninstalled();
        if (this.isFragment()) {
            return null;
        }
        if (this.state == 2 && !this.secure.okResourceAdminPerm(this)) {
            return null;
        }
        if (this.getUpdatedState() != 2 && (cl = (BundleClassLoader)this.getClassLoader()) != null) {
            return cl.getBundleResources(name, false);
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.secure.okClassAdminPerm(this)) {
            this.checkUninstalled();
            if (this.isFragment() && !this.isExtension()) {
                throw new ClassNotFoundException("Can not load classes from fragment bundles");
            }
            if (this.getUpdatedState() == 2) {
                this.framework.listeners.frameworkError(this, new BundleException("Unable to resolve bundle: " + this.bpkgs.getResolveFailReason()));
                throw new ClassNotFoundException("Unable to resolve bundle");
            }
            ClassLoader cl = this.getClassLoader();
            if (cl == null) {
                throw new IllegalStateException("state is uninstalled?");
            }
            return cl.loadClass(name);
        }
        throw new ClassNotFoundException("No AdminPermission to get class: " + name);
    }

    boolean isFragment() {
        return this.fragment != null;
    }

    boolean isExtension() {
        return this.isFragment() && this.fragment.extension != null;
    }

    boolean extensionNeedsRestart() {
        return this.isExtension() && (this.state & 3) != 0;
    }

    boolean isBootClassPathExtension() {
        return this.isExtension() && this.fragment.extension.equals("bootclasspath");
    }

    boolean isFrameworkExtension() {
        return this.isExtension() && this.fragment.extension.equals("framework");
    }

    boolean isAttached() {
        return this.isFragment() && this.fragment.host != null;
    }

    String getFragmentHostName() {
        if (this.isFragment()) {
            return this.fragment.name;
        }
        return null;
    }

    BundleImpl getFragmentHost() {
        return this.isFragment() ? this.fragment.targets() : null;
    }

    boolean isFragmentHost() {
        return this.fragments != null && this.fragments.size() > 0;
    }

    void attachFragments() {
        List hosting;
        if (!this.attachPolicy.equals("never") && (hosting = this.framework.bundles.getFragmentBundles(this)).size() > 0 && this.secure.okHostBundlePerm(this)) {
            Iterator iter = hosting.iterator();
            while (iter.hasNext()) {
                BundleImpl fb = (BundleImpl)iter.next();
                if (fb.state != 2) continue;
                fb.resolveFragment(this);
            }
        }
    }

    void attachFragment(BundleImpl fragmentBundle) {
        int i;
        this.checkUninstalled();
        if (this.attachPolicy.equals("never")) {
            throw new IllegalStateException("Bundle does not allow fragments to attach");
        }
        if (this.attachPolicy.equals("resolve-time") && (this.state & RESOLVED_FLAGS) != 0) {
            throw new IllegalStateException("Bundle does not allow fragments to attach dynamicly");
        }
        String failReason = this.bpkgs.attachFragment(fragmentBundle.bpkgs);
        if (failReason != null) {
            throw new IllegalStateException(failReason);
        }
        if (this.fragments == null) {
            this.fragments = new ArrayList();
        }
        for (i = 0; i < this.fragments.size(); ++i) {
            BundleImpl b = (BundleImpl)this.fragments.get(i);
            if (b.id > fragmentBundle.id) break;
        }
        this.fragments.add(i, fragmentBundle);
    }

    Iterator getFragments() {
        return this.fragments == null ? ((AbstractList)new ArrayList(0)).iterator() : ((AbstractList)this.fragments).iterator();
    }

    private void detachFragments(boolean sendEvent) {
        if (this.fragments != null) {
            while (this.fragments.size() > 0) {
                this.detachFragment((BundleImpl)this.fragments.get(0), sendEvent);
            }
        }
    }

    private void detachFragment(BundleImpl fb, boolean sendEvent) {
        if (((AbstractCollection)this.fragments).remove(fb)) {
            this.bpkgs.detachFragment(fb);
            if (fb.state != 1) {
                fb.setStateInstalled(sendEvent);
            }
        }
    }

    private void checkUninstalled() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is in UNINSTALLED state");
        }
    }

    class Fragment {
        final String name;
        final String extension;
        final VersionRange versionRange;
        BundleImpl host = null;

        Fragment(String name, String extension, String range) {
            this.name = name;
            this.extension = extension;
            this.versionRange = range == null ? VersionRange.defaultVersionRange : new VersionRange(range);
        }

        void setHost(BundleImpl host) {
            this.host = host;
        }

        BundleImpl targets() {
            if (this.host != null) {
                return this.host;
            }
            List bundles = BundleImpl.this.framework.bundles.getBundles(this.name, this.versionRange);
            if (bundles.isEmpty()) {
                return null;
            }
            BundleImpl best = null;
            Iterator iter = bundles.iterator();
            while (iter.hasNext()) {
                BundleImpl challenger = (BundleImpl)iter.next();
                if (challenger.state == 1 || challenger.attachPolicy.equals("never") || best != null && challenger.version.compareTo(best.version) <= 0) continue;
                best = challenger;
            }
            return best;
        }
    }
}

