/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.RequireBundle;
import org.knopflerfish.framework.Util;

class BundlePackages {
    final BundleImpl bundle;
    final int generation;
    private ClassLoader classLoader = null;
    private ArrayList exports = new ArrayList(1);
    private ArrayList imports = new ArrayList(1);
    private ArrayList dImportPatterns = new ArrayList(1);
    private HashMap fragments = null;
    ArrayList require;
    ArrayList requiredBy = null;
    private ArrayList okImports = null;
    private boolean registered = false;
    private String failReason = null;
    static final String EMPTY_STRING = "";
    static final Util.Comparator epComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ExportPkg a = (ExportPkg)oa;
            ExportPkg b = (ExportPkg)ob;
            return a.name.compareTo(b.name);
        }
    };
    static final Util.Comparator epFind = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ExportPkg a = (ExportPkg)oa;
            String b = (String)ob;
            return a.name.compareTo(b);
        }
    };
    static final Util.Comparator ipComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ImportPkg a = (ImportPkg)oa;
            ImportPkg b = (ImportPkg)ob;
            return a.name.compareTo(b.name);
        }
    };
    static final Util.Comparator ipFind = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ImportPkg a = (ImportPkg)oa;
            String b = (String)ob;
            return a.name.compareTo(b);
        }
    };

    BundlePackages(BundleImpl b, int gen, String exportStr, String importStr, String dimportStr, String requireStr) {
        Iterator pi;
        Map e;
        this.bundle = b;
        this.generation = gen;
        Iterator i = Util.parseEntries("Import-Package", importStr, false, true, false);
        block0: while (i.hasNext()) {
            e = (Map)i.next();
            pi = ((List)e.remove("keys")).iterator();
            ImportPkg ip = new ImportPkg((String)pi.next(), e, this);
            while (true) {
                int ii;
                if ((ii = Util.binarySearch(this.imports, ipComp, ip)) >= 0) {
                    throw new IllegalArgumentException("Duplicate import definitions for - " + ip.name);
                }
                this.imports.add(-ii - 1, ip);
                if (!pi.hasNext()) continue block0;
                ip = new ImportPkg(ip, (String)pi.next());
            }
        }
        i = Util.parseEntries("Export-Package", exportStr, false, true, false);
        block2: while (i.hasNext()) {
            e = (Map)i.next();
            pi = ((List)e.remove("keys")).iterator();
            ExportPkg ep = new ExportPkg((String)pi.next(), e, this);
            while (true) {
                ImportPkg ip;
                int ii;
                int ei = Math.abs(Util.binarySearch(this.exports, epComp, ep) + 1);
                this.exports.add(ei, ep);
                if (!b.v2Manifest && (ii = Util.binarySearch(this.imports, ipComp, ip = new ImportPkg(ep))) < 0) {
                    this.imports.add(-ii - 1, ip);
                }
                if (!pi.hasNext()) continue block2;
                ep = new ExportPkg(ep, (String)pi.next());
            }
        }
        i = Util.parseEntries("DynamicImport-Package", dimportStr, false, true, false);
        while (i.hasNext()) {
            e = (Map)i.next();
            if (e.containsKey("resolution")) {
                throw new IllegalArgumentException("DynamicImport-Package entry illegal contains a resolution directive.");
            }
            ImportPkg tmpl = null;
            Iterator pi2 = ((List)e.remove("keys")).iterator();
            while (pi2.hasNext()) {
                String key = (String)pi2.next();
                if (key.equals("*")) {
                    key = EMPTY_STRING;
                } else if (key.endsWith(".*")) {
                    key = key.substring(0, key.length() - 1);
                } else {
                    if (key.endsWith(".")) {
                        throw new IllegalArgumentException("DynamicImport-Package entry ends with '.': " + key);
                    }
                    if (key.indexOf("*") != -1) {
                        throw new IllegalArgumentException("DynamicImport-Package entry contains a '*': " + key);
                    }
                }
                if (tmpl != null) {
                    this.dImportPatterns.add(new ImportPkg(tmpl, key));
                    continue;
                }
                tmpl = new ImportPkg(key, e, this);
                this.dImportPatterns.add(tmpl);
            }
        }
        i = Util.parseEntries("Require-Bundle", requireStr, true, true, false);
        if (i.hasNext()) {
            this.require = new ArrayList();
            do {
                e = (Map)i.next();
                this.require.add(new RequireBundle(this, (String)e.get("key"), (String)e.get("visibility"), (String)e.get("resolution"), (String)e.get("bundle-version")));
            } while (i.hasNext());
        } else {
            this.require = null;
        }
    }

    void registerPackages() {
        this.bundle.framework.packages.registerPackages(((AbstractList)this.exports).iterator(), ((AbstractList)this.imports).iterator());
        this.registered = true;
    }

    synchronized boolean unregisterPackages(boolean force) {
        if (this.registered) {
            ArrayList i;
            ArrayList arrayList = i = this.okImports != null ? this.okImports : this.imports;
            if (this.bundle.framework.packages.unregisterPackages(this.exports, i, force)) {
                this.okImports = null;
                this.registered = false;
            } else {
                return false;
            }
        }
        return true;
    }

    boolean resolvePackages() {
        ArrayList permImports = new ArrayList(this.imports.size());
        this.failReason = this.bundle.framework.perm.missingMandatoryPackagePermissions(this, permImports);
        if (this.failReason != null) {
            return false;
        }
        this.failReason = this.bundle.framework.packages.resolve(this.bundle, ((AbstractList)permImports).iterator());
        if (this.failReason == null) {
            Iterator i = ((AbstractList)permImports).iterator();
            while (i.hasNext()) {
                ImportPkg ip = (ImportPkg)i.next();
                if (ip.provider != null) continue;
                i.remove();
            }
            this.okImports = permImports;
            return true;
        }
        return false;
    }

    String getResolveFailReason() {
        return this.failReason;
    }

    synchronized BundlePackages getProviderBundlePackages(String pkg) {
        if (this.okImports == null) {
            return null;
        }
        int ii = Util.binarySearch(this.okImports, ipFind, pkg);
        if (ii >= 0) {
            return ((ImportPkg)this.okImports.get((int)ii)).provider.bpkgs;
        }
        return null;
    }

    synchronized BundlePackages getDynamicProviderBundlePackages(String pkg) {
        if (this.okImports == null) {
            return null;
        }
        int ii = Util.binarySearch(this.okImports, ipFind, pkg);
        if (ii >= 0) {
            return ((ImportPkg)this.okImports.get((int)ii)).provider.bpkgs;
        }
        if (this.bundle.framework.perm.hasImportPackagePermission(this.bundle, pkg)) {
            Iterator i = ((AbstractList)this.dImportPatterns).iterator();
            while (i.hasNext()) {
                ImportPkg nip;
                ExportPkg ep;
                ImportPkg ip = (ImportPkg)i.next();
                if (ip.name != EMPTY_STRING && (!ip.name.endsWith(".") || !pkg.startsWith(ip.name)) && !pkg.equals(ip.name) || (ep = this.bundle.framework.packages.registerDynamicImport(nip = new ImportPkg(ip, pkg))) == null) continue;
                nip.provider = ep;
                this.okImports.add(-ii - 1, nip);
                return ep.bpkgs;
            }
        }
        return null;
    }

    ArrayList getRequiredBundlePackages(String pkg) {
        if (this.require != null) {
            ArrayList<BundlePackages> res = new ArrayList<BundlePackages>();
            Iterator i = ((AbstractList)this.require).iterator();
            while (i.hasNext()) {
                RequireBundle rb = (RequireBundle)i.next();
                if (rb.bpkgs == null || rb.bpkgs.getExport(pkg) == null) continue;
                res.add(rb.bpkgs);
            }
            if (!res.isEmpty()) {
                return res;
            }
        }
        return null;
    }

    List getRequiredBy() {
        if (this.requiredBy != null) {
            return (List)this.requiredBy.clone();
        }
        return new ArrayList(0);
    }

    void checkReExport(ExportPkg ep) {
        int i = Util.binarySearch(this.exports, epFind, ep.name);
        if (i < 0) {
            ExportPkg nep = new ExportPkg(ep, this);
            this.exports.add(-i - 1, nep);
            ep.pkg.addExporter(nep);
        }
    }

    ExportPkg getExport(String pkg) {
        int i = Util.binarySearch(this.exports, epFind, pkg);
        if (i >= 0) {
            return (ExportPkg)this.exports.get(i);
        }
        return null;
    }

    Iterator getExports() {
        return ((AbstractList)this.exports).iterator();
    }

    void addExport(ExportPkg pkg) {
        int ei = Math.abs(Util.binarySearch(this.exports, epComp, pkg) + 1);
        this.exports.add(ei, pkg);
    }

    void removeExport(ExportPkg pkg) {
        int ei = Util.binarySearch(this.exports, epComp, pkg);
        this.exports.remove(ei);
    }

    ImportPkg getImport(String pkg) {
        int i = Util.binarySearch(this.imports, ipFind, pkg);
        if (i >= 0) {
            return (ImportPkg)this.imports.get(i);
        }
        return null;
    }

    Iterator getImports() {
        return ((AbstractList)this.imports).iterator();
    }

    Iterator getActiveImports() {
        return ((AbstractList)this.okImports).iterator();
    }

    ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.bundle.getClassLoader(this);
        }
        return this.classLoader;
    }

    void invalidateClassLoader() {
        this.classLoader = null;
    }

    boolean isRegistered() {
        return this.registered;
    }

    String attachFragment(BundlePackages fbpkgs) {
        Iterator riter;
        if (this.fragments == null) {
            this.fragments = new HashMap();
        } else if (this.fragments.containsKey(fbpkgs.bundle)) {
            throw new RuntimeException("Fragments packages already attached: " + fbpkgs);
        }
        Iterator iiter = fbpkgs.getImports();
        while (iiter.hasNext()) {
            ImportPkg fip = (ImportPkg)iiter.next();
            ImportPkg ip = this.getImport(fip.name);
            if (ip == null && this.bundle.state != 2) {
                return "Can not dynamicly attach, because host has no import for: " + fip;
            }
            if (ip == null || fip.overlap(ip)) continue;
            return "Host bundle import package constraints need to be stricterthen the import package contraints in the attaching fragment.";
        }
        ArrayList<RequireBundle> newRequired = new ArrayList<RequireBundle>();
        if (fbpkgs.require != null) {
            Iterator iter = ((AbstractList)fbpkgs.require).iterator();
            while (iter.hasNext()) {
                RequireBundle fragReq = (RequireBundle)iter.next();
                boolean match = false;
                if (this.require != null) {
                    Iterator iter2 = ((AbstractList)this.require).iterator();
                    while (iter2.hasNext()) {
                        RequireBundle req = (RequireBundle)iter2.next();
                        if (!fragReq.name.equals(req.name)) continue;
                        if (fragReq.overlap(req)) {
                            match = true;
                            continue;
                        }
                        return "Fragment bundle required bundle does not completely overlap required bundle in host bundle.";
                    }
                }
                if (match) continue;
                if (this.bundle.state != 2) {
                    return "Can not attach a fragment with new required bundles to a resolved host";
                }
                newRequired.add(fragReq);
            }
        }
        if ((riter = ((AbstractList)newRequired).iterator()).hasNext()) {
            int rpos;
            if (this.require == null) {
                this.require = new ArrayList();
                rpos = 0;
            } else {
                for (rpos = this.require.size(); rpos > 0; --rpos) {
                    RequireBundle rb = (RequireBundle)this.require.get(rpos - 1);
                    if (this == rb.bpkgs || rb.bpkgs.bundle.id < fbpkgs.bundle.id) break;
                }
            }
            do {
                this.require.add(rpos++, (RequireBundle)riter.next());
            } while (riter.hasNext());
        }
        ArrayList<ExportPkg> newExports = new ArrayList<ExportPkg>();
        Iterator eiter = fbpkgs.getExports();
        while (eiter.hasNext()) {
            ExportPkg fep = (ExportPkg)eiter.next();
            int ei = Util.binarySearch(this.exports, epComp, fep);
            if (ei >= 0) continue;
            ExportPkg tmp = new ExportPkg(fep, this);
            this.exports.add(-ei - 1, tmp);
            newExports.add(tmp);
        }
        ArrayList<ImportPkg> newImports = new ArrayList<ImportPkg>();
        Iterator iiter2 = fbpkgs.getImports();
        while (iiter2.hasNext()) {
            ImportPkg fip = (ImportPkg)iiter2.next();
            int ii = Util.binarySearch(this.imports, ipComp, fip);
            if (ii >= 0) continue;
            ImportPkg tmp = new ImportPkg(fip, this);
            this.imports.add(-ii - 1, tmp);
            newImports.add(tmp);
        }
        this.bundle.framework.packages.registerPackages(((AbstractList)newExports).iterator(), ((AbstractList)newImports).iterator());
        this.fragments.put(fbpkgs.bundle, new ArrayList[]{newRequired, newExports, newImports});
        return null;
    }

    void detachFragment(BundleImpl fb) {
        if (this.registered) {
            throw new RuntimeException("NYI, detach when bpkgs are registered");
        }
        List[] added = (List[])this.fragments.remove(fb);
        Iterator riter = added[0].iterator();
        while (riter.hasNext()) {
            ((AbstractCollection)this.require).remove(riter.next());
        }
        Iterator eiter = added[1].iterator();
        while (eiter.hasNext()) {
            ((AbstractCollection)this.exports).remove(eiter.next());
        }
        Iterator iiter = added[2].iterator();
        while (iiter.hasNext()) {
            ((AbstractCollection)this.imports).remove(iiter.next());
        }
    }

    public String toString() {
        return "BundlePackages(id=" + this.bundle.id + ",gen=" + this.generation + ")";
    }
}

