/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collection;
import java.util.List;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ExportPkg;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
implements ExportedPackage {
    private final ExportPkg pkg;

    ExportedPackageImpl(ExportPkg pkg) {
        this.pkg = pkg;
    }

    public String getName() {
        return this.pkg.name;
    }

    public Bundle getExportingBundle() {
        if (this.pkg.pkg != null) {
            return this.pkg.bpkgs.bundle;
        }
        return null;
    }

    public Bundle[] getImportingBundles() {
        Collection imps = this.pkg.getPackageImporters();
        if (imps != null) {
            int size = imps.size();
            List rl = this.pkg.bpkgs.getRequiredBy();
            int rsize = rl.size();
            Bundle[] res = new Bundle[size + rsize];
            imps.toArray(res);
            for (int i = 0; i < rsize; ++i) {
                res[size + i] = ((BundlePackages)rl.get((int)i)).bundle;
            }
            return res;
        }
        return null;
    }

    public String getSpecificationVersion() {
        return this.pkg.version.toString();
    }

    public boolean isRemovalPending() {
        if (this.pkg.isProvider()) {
            return this.pkg.zombie;
        }
        return false;
    }

    public Version getVersion() {
        return this.pkg.version;
    }
}

