/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Version;

class ImportPkg {
    final String name;
    final BundlePackages bpkgs;
    final String resolution;
    final String bundleSymbolicName;
    final VersionRange packageRange;
    final VersionRange bundleRange;
    final Map attributes;
    Pkg pkg = null;
    ExportPkg provider = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ImportPkg(String name, Map tokens, BundlePackages b) {
        String rangeStr;
        this.bpkgs = b;
        this.name = name;
        if (name.startsWith("java.")) {
            throw new IllegalArgumentException("You can not import a java.* package");
        }
        String res = (String)tokens.remove("resolution");
        if (res != null) {
            if ("optional".equals(res)) {
                this.resolution = "optional";
            } else {
                if (!"mandatory".equals(res)) throw new IllegalArgumentException("Directive resolution, unexpected value: " + res);
                this.resolution = "mandatory";
            }
        } else {
            this.resolution = "mandatory";
        }
        this.bundleSymbolicName = (String)tokens.remove("bundle-symbolic-name");
        String versionStr = (String)tokens.remove("version");
        String specVersionStr = (String)tokens.remove("specification-version");
        if (specVersionStr != null) {
            this.packageRange = new VersionRange(specVersionStr);
            if (versionStr != null && !this.packageRange.equals(new VersionRange(versionStr))) {
                throw new IllegalArgumentException("Both version and specification-versionare specified, but differs");
            }
        } else {
            this.packageRange = versionStr != null ? new VersionRange(versionStr) : VersionRange.defaultVersionRange;
        }
        this.bundleRange = (rangeStr = (String)tokens.remove("bundle-version")) != null ? new VersionRange(rangeStr) : VersionRange.defaultVersionRange;
        this.attributes = tokens;
    }

    ImportPkg(ImportPkg ip, String name) {
        this.name = name;
        this.bpkgs = ip.bpkgs;
        this.resolution = ip.resolution;
        this.bundleSymbolicName = ip.bundleSymbolicName;
        this.packageRange = ip.packageRange;
        this.bundleRange = ip.bundleRange;
        this.attributes = ip.attributes;
    }

    ImportPkg(ImportPkg ip, BundlePackages bpkgs) {
        this.name = ip.name;
        this.bpkgs = bpkgs;
        this.resolution = ip.resolution;
        this.bundleSymbolicName = ip.bundleSymbolicName;
        this.packageRange = ip.packageRange;
        this.bundleRange = ip.bundleRange;
        this.attributes = ip.attributes;
    }

    ImportPkg(ExportPkg p) {
        this.name = p.name;
        this.bpkgs = p.bpkgs;
        this.resolution = "mandatory";
        this.bundleSymbolicName = null;
        this.packageRange = p.version == Version.emptyVersion ? VersionRange.defaultVersionRange : new VersionRange(p.version.toString());
        this.bundleRange = VersionRange.defaultVersionRange;
        this.attributes = p.attributes;
    }

    synchronized void attachPkg(Pkg p) {
        this.pkg = p;
    }

    synchronized void detachPkg() {
        this.pkg = null;
        this.provider = null;
    }

    public boolean okPackageVersion(Version ver) {
        return this.packageRange.withinRange(ver);
    }

    boolean checkMandatory(List mandatory) {
        if (mandatory != null) {
            Iterator i = mandatory.iterator();
            while (i.hasNext()) {
                String a = (String)i.next();
                if (!("version".equals(a) ? !this.packageRange.isSpecified() : ("bundle-symbolic-name".equals(a) ? this.bundleSymbolicName == null : ("bundle-version".equals(a) ? !this.bundleRange.isSpecified() : !this.attributes.containsKey(a))))) continue;
                return false;
            }
        }
        return true;
    }

    boolean overlap(ImportPkg ip) {
        if (ip.bundleSymbolicName == null ? this.bundleSymbolicName != null : !ip.bundleSymbolicName.equals(this.bundleSymbolicName)) {
            return false;
        }
        Iterator i = this.attributes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String a = (String)ip.attributes.get(e.getKey());
            if (a != null && a.equals(e.getValue())) continue;
            return false;
        }
        if (this.resolution.equals("mandatory") && !ip.resolution.equals("mandatory")) {
            return false;
        }
        if (!this.packageRange.withinRange(ip.packageRange)) {
            return false;
        }
        return this.bundleRange.withinRange(ip.bundleRange);
    }

    public String pkgString() {
        if (this.packageRange.isSpecified()) {
            return this.name + ";" + "version" + "=" + this.packageRange;
        }
        return this.name;
    }

    public String toString() {
        return this.pkgString() + "(" + this.bpkgs.bundle + ")";
    }
}

