/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Main;
import org.knopflerfish.framework.PackageAdminImpl;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.permissions.PermissionsHandle;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceRegistration;

class SecurePermissionOps
extends PermissionOps {
    private static final int AP_CLASS = 0;
    private static final int AP_EXECUTE = 1;
    private static final int AP_EXTENSIONLIFECYCLE = 2;
    private static final int AP_LIFECYCLE = 3;
    private static final int AP_LISTENER = 4;
    private static final int AP_METADATA = 5;
    private static final int AP_RESOURCE = 6;
    private static final int AP_MAX = 7;
    private static String[] AP_TO_STRING = new String[]{"class", "execute", "extensionLifecycle", "lifecycle", "listener", "metadata", "resource"};
    private final Framework framework;
    private final PermissionsHandle ph;
    private AdminPermission ap_resolve_perm = null;
    private AdminPermission ap_startlevel_perm = null;
    Hashtable adminPerms = new Hashtable();
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;

    SecurePermissionOps(Framework fw) {
        this.framework = fw;
        this.ph = new PermissionsHandle(fw);
    }

    void registerService() {
        String[] classes = new String[]{(class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = SecurePermissionOps.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName()};
        this.framework.services.register(this.framework.systemBundle, classes, this.ph.getPermissionAdminService(), null);
    }

    boolean checkPermissions() {
        return true;
    }

    boolean okClassAdminPerm(Bundle b) {
        try {
            AccessController.checkPermission(this.getAdminPermission(b, 0));
            return true;
        }
        catch (AccessControlException _ignore) {
            return false;
        }
    }

    void checkExecuteAdminPerm(Bundle b) {
        AccessController.checkPermission(this.getAdminPermission(b, 1));
    }

    void checkExtensionLifecycleAdminPerm(Bundle b) {
        AccessController.checkPermission(this.getAdminPermission(b, 2));
    }

    void checkExtensionLifecycleAdminPerm(Bundle b, Object checkContext) {
        ((AccessControlContext)checkContext).checkPermission(this.getAdminPermission(b, 2));
    }

    void checkLifecycleAdminPerm(Bundle b) {
        AccessController.checkPermission(this.getAdminPermission(b, 3));
    }

    void checkLifecycleAdminPerm(Bundle b, Object checkContext) {
        ((AccessControlContext)checkContext).checkPermission(this.getAdminPermission(b, 3));
    }

    void checkListenerAdminPerm(Bundle b) {
        AccessController.checkPermission(this.getAdminPermission(b, 4));
    }

    void checkMetadataAdminPerm(Bundle b) {
        AccessController.checkPermission(this.getAdminPermission(b, 5));
    }

    void checkResolveAdminPerm() {
        if (this.ap_resolve_perm == null) {
            this.ap_resolve_perm = new AdminPermission((Bundle)this.framework.systemBundle, "resolve");
        }
        AccessController.checkPermission(this.ap_resolve_perm);
    }

    void checkResourceAdminPerm(Bundle b) {
        AccessController.checkPermission(this.getAdminPermission(b, 6));
    }

    boolean okResourceAdminPerm(Bundle b) {
        try {
            this.checkResourceAdminPerm(b);
            return true;
        }
        catch (AccessControlException _ignore) {
            return false;
        }
    }

    void checkStartLevelAdminPerm() {
        if (this.ap_startlevel_perm == null) {
            this.ap_startlevel_perm = new AdminPermission((Bundle)this.framework.systemBundle, "startlevel");
        }
        AccessController.checkPermission(this.ap_startlevel_perm);
    }

    boolean okFragmentBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "fragment"));
    }

    boolean okHostBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "host"));
    }

    boolean okProvideBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "provide"));
    }

    boolean okRequireBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "require"));
    }

    boolean hasImportPackagePermission(BundleImpl b, String pkg) {
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new PackagePermission(pkg, "import"));
        }
        return true;
    }

    String missingMandatoryPackagePermissions(BundlePackages bpkgs, List okImports) {
        if (bpkgs.bundle.id == 0L) {
            return null;
        }
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(bpkgs.bundle.id));
        String e_res = null;
        Iterator i = bpkgs.getExports();
        while (i.hasNext()) {
            ExportPkg p = (ExportPkg)i.next();
            if (pc.implies(new PackagePermission(p.name, "export"))) continue;
            if (e_res != null) {
                e_res = e_res + ", " + p.name;
                continue;
            }
            e_res = "missing export permission for package(s): " + p.name;
            e_res = p.name;
        }
        String i_res = null;
        Iterator i2 = bpkgs.getImports();
        while (i2.hasNext()) {
            ImportPkg p = (ImportPkg)i2.next();
            if (!pc.implies(new PackagePermission(p.name, "import"))) {
                if (p.resolution == "optional") continue;
                if (i_res != null) {
                    i_res = i_res + ", " + p.name;
                    continue;
                }
                i_res = "missing import permission for package(s): " + p.name;
                continue;
            }
            okImports.add(p);
        }
        if (e_res != null) {
            if (i_res != null) {
                return e_res + "; " + i_res;
            }
            return e_res;
        }
        return i_res;
    }

    void checkRegisterServicePerm(String clazz) {
        AccessController.checkPermission(new ServicePermission(clazz, "register"));
    }

    boolean okGetServicePerm(String clazz) {
        String c = clazz != null ? clazz : "*";
        try {
            AccessController.checkPermission(new ServicePermission(c, "get"));
            return true;
        }
        catch (AccessControlException _ignore) {
            return false;
        }
    }

    void checkGetServicePerms(String[] classes) {
        if (!this.okGetServicePerms(classes)) {
            throw new SecurityException("Missing permission to get the service.");
        }
    }

    boolean okGetServicePerms(String[] classes) {
        AccessControlContext acc = AccessController.getContext();
        return this.okGetServicePerms(acc, classes);
    }

    private boolean okGetServicePerms(AccessControlContext acc, String[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            try {
                acc.checkPermission(new ServicePermission(classes[i], "get"));
                return true;
            }
            catch (AccessControlException ignore) {
                continue;
            }
        }
        return false;
    }

    void filterGetServicePermission(Set srs) {
        AccessControlContext acc = AccessController.getContext();
        Iterator i = srs.iterator();
        while (i.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)i.next();
            String[] classes = (String[])sr.properties.get("objectClass");
            if (this.okGetServicePerms(acc, classes)) continue;
            i.remove();
        }
    }

    InputStream callGetInputStream(final BundleArchive archive, final String name, final int ix) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return archive.getInputStream(name, ix);
            }
        });
    }

    Enumeration callFindResourcesPath(final BundleArchive archive, final String path) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return archive.findResourcesPath(path);
            }
        });
    }

    Object callSearchFor(final BundleClassLoader cl, final String name, final String pkg, final String path, final BundleClassLoader.SearchAction action, final boolean onlyFirst, final BundleClassLoader requestor, final HashSet visited) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.searchFor(name, pkg, path, action, onlyFirst, requestor, visited);
            }
        });
    }

    void callStart0(final BundleImpl b) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    b.start0();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    BundleException callStop0(final BundleImpl b, final boolean resetPersistent) {
        return (BundleException)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return b.stop0(resetPersistent);
            }
        });
    }

    void callUpdate0(final BundleImpl b, final InputStream in, final boolean wasActive) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    b.update0(in, wasActive);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    void callUninstall0(final BundleImpl b) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                b.uninstall0();
                return null;
            }
        });
    }

    void callStartOnLaunch(final BundleImpl b, final boolean flag) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                b.startOnLaunch(flag);
                return null;
            }
        });
    }

    void callSetPersistent(final BundleImpl b, final boolean flag) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                b.setPersistent(flag);
                return null;
            }
        });
    }

    ClassLoader callGetClassLoader0(final BundleImpl b) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return b.getClassLoader0();
            }
        });
    }

    HeaderDictionary callGetHeaders0(final BundleImpl b, final String locale) {
        return (HeaderDictionary)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return b.getHeaders0(locale);
            }
        });
    }

    Enumeration callFindEntries0(final BundleImpl b, final String path, final String filePattern, final boolean recurse) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return b.findEntries0(path, filePattern, recurse);
            }
        });
    }

    BundleImpl callInstall0(final Bundles bs, final String location, final InputStream in) throws BundleException {
        try {
            final AccessControlContext acc = AccessController.getContext();
            return (BundleImpl)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    return bs.install0(location, in, acc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    void callBundleChanged(final BundleListener bl, final BundleEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                bl.bundleChanged(evt);
                return null;
            }
        });
    }

    void callFrameworkEvent(final FrameworkListener fl, final FrameworkEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fl.frameworkEvent(evt);
                return null;
            }
        });
    }

    void callServiceChanged(final ServiceListener sl, final ServiceEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sl.serviceChanged(evt);
                return null;
            }
        });
    }

    void callMainRestart() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Main.restart();
                return null;
            }
        });
    }

    void callMainShutdown(final int exitcode) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Main.shutdown(exitcode);
                return null;
            }
        });
    }

    void callRefreshPackages0(final PackageAdminImpl pa, final Bundle[] bundles) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                pa.refreshPackages0(bundles);
                return null;
            }
        });
    }

    Object callGetService(final ServiceFactory sf, final Bundle b, final ServiceRegistration sr) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sf.getService(b, sr);
            }
        });
    }

    void callUnregister0(final ServiceRegistrationImpl sr) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sr.unregister0();
                return null;
            }
        });
    }

    ProtectionDomain getProtectionDomain(BundleImpl b) {
        try {
            String h = Long.toString(b.id) + "." + Long.toString(b.generation);
            URL bundleUrl = new URL("bundle", h, "");
            InputStream pis = b.archive.getInputStream("OSGI-INF/permissions.perm", 0);
            PermissionCollection pc = this.ph.createPermissionCollection(b.location, b, pis);
            return new ProtectionDomain(new CodeSource(bundleUrl, (Certificate[])null), pc);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    void purge(BundleImpl b, ProtectionDomain pd) {
        if (this.ph.purgePermissionCollection(new Long(b.id), pd.getPermissions())) {
            this.adminPerms.remove(b);
        }
    }

    AdminPermission getAdminPermission(Bundle b, int ti) {
        AdminPermission[] res = (AdminPermission[])this.adminPerms.get(b);
        if (res != null) {
            if (res[ti] != null) {
                return res[ti];
            }
        } else {
            res = new AdminPermission[7];
            this.adminPerms.put(b, res);
        }
        res[ti] = new AdminPermission(b, AP_TO_STRING[ti]);
        return res[ti];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

