/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    BundleImpl bundle;
    Object service;
    ServiceReferenceImpl reference;
    PropertiesDictionary properties;
    HashMap dependents = new HashMap();
    HashMap serviceInstances = new HashMap();
    boolean available;
    private Object eventLock = new Object();

    ServiceRegistrationImpl(BundleImpl b, Object s, PropertiesDictionary props) {
        this.bundle = b;
        this.service = s;
        this.properties = props;
        this.reference = new ServiceReferenceImpl(this);
        this.available = true;
    }

    public ServiceReference getReference() {
        ServiceReferenceImpl res = this.reference;
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Service is unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        Object object = this.eventLock;
        synchronized (object) {
            PropertiesDictionary propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                if (!this.available) {
                    throw new IllegalStateException("Service is unregistered");
                }
                String[] classes = (String[])this.properties.get("objectClass");
                Long sid = (Long)this.properties.get("service.id");
                this.properties = new PropertiesDictionary(props, classes, sid);
            }
            this.bundle.framework.listeners.serviceChanged(new ServiceEvent(2, this.reference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Object object = this.eventLock;
        synchronized (object) {
            if (!Framework.UNREGISTERSERVICE_VALID_DURING_UNREGISTERING) {
                this.unregister_removeService();
            }
            this.bundle.framework.listeners.serviceChanged(new ServiceEvent(4, this.reference));
            if (Framework.UNREGISTERSERVICE_VALID_DURING_UNREGISTERING) {
                this.unregister_removeService();
            }
        }
        this.bundle.framework.perm.callUnregister0(this);
        object = this.properties;
        synchronized (object) {
            this.bundle = null;
            this.dependents = null;
            this.reference = null;
            this.service = null;
            this.serviceInstances = null;
        }
    }

    void unregister0() {
        Iterator i = this.serviceInstances.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            try {
                ((ServiceFactory)this.service).ungetService((Bundle)e.getKey(), this, e.getValue());
            }
            catch (Throwable ue) {
                this.bundle.framework.listeners.frameworkEvent(new FrameworkEvent(2, this.bundle, ue));
            }
        }
    }

    boolean isUsedByBundle(Bundle b) {
        HashMap deps = this.dependents;
        if (deps != null) {
            return deps.containsKey(b);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister_removeService() {
        PropertiesDictionary propertiesDictionary = this.properties;
        synchronized (propertiesDictionary) {
            if (!this.available) {
                throw new IllegalStateException("Service is unregistered");
            }
            this.bundle.framework.services.removeServiceRegistration(this);
            this.available = false;
        }
    }
}

