/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.LDAPExpr;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

class Services {
    private HashMap services = new HashMap();
    private HashMap classServices = new HashMap();
    private PermissionOps secure;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;

    Services(PermissionOps perm) {
        this.secure = perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistration register(BundleImpl bundle, String[] classes, Object service, Dictionary properties) {
        ServiceRegistrationImpl res;
        if (service == null) {
            throw new IllegalArgumentException("Can't register null as a service");
        }
        Services services = this;
        synchronized (services) {
            int i;
            Class<?> sc = service.getClass();
            ClassLoader scl = sc.getClassLoader();
            for (i = 0; i < classes.length; ++i) {
                String cls = classes[i];
                if (cls == null) {
                    throw new IllegalArgumentException("Can't register as null class");
                }
                this.secure.checkRegisterServicePerm(cls);
                if (bundle.id != 0L) {
                    if (cls.equals((class$org$osgi$service$packageadmin$PackageAdmin == null ? Services.class$("org.osgi.service.packageadmin.PackageAdmin") : class$org$osgi$service$packageadmin$PackageAdmin).getName())) {
                        throw new IllegalArgumentException("Registeration of a PackageAdmin service is not allowed");
                    }
                    if (cls.equals((class$org$osgi$service$permissionadmin$PermissionAdmin == null ? Services.class$("org.osgi.service.permissionadmin.PermissionAdmin") : class$org$osgi$service$permissionadmin$PermissionAdmin).getName())) {
                        throw new IllegalArgumentException("Registeration of a PermissionAdmin service is not allowed");
                    }
                }
                if (service instanceof ServiceFactory) continue;
                ClassLoader cl = sc.getClassLoader();
                Class<?> c = null;
                boolean ok = false;
                try {
                    c = cl != null ? cl.loadClass(cls) : Class.forName(cls);
                    ok = c.isInstance(service);
                }
                catch (ClassNotFoundException e) {
                    block6: for (Class<?> csc = sc; csc != null; csc = csc.getSuperclass()) {
                        if (cls.equals(csc.getName())) {
                            ok = true;
                            break;
                        }
                        Class<?>[] ic = csc.getInterfaces();
                        for (int iic = ic.length - 1; iic >= 0; --iic) {
                            if (!cls.equals(ic[iic].getName())) continue;
                            ok = true;
                            continue block6;
                        }
                    }
                }
                if (ok) continue;
                throw new IllegalArgumentException("Service object is not an instance of " + cls);
            }
            res = new ServiceRegistrationImpl(bundle, service, new PropertiesDictionary(properties, classes, null));
            this.services.put(res, classes);
            for (i = 0; i < classes.length; ++i) {
                ArrayList<ServiceRegistrationImpl> s = (ArrayList<ServiceRegistrationImpl>)this.classServices.get(classes[i]);
                if (s == null) {
                    s = new ArrayList<ServiceRegistrationImpl>(1);
                    this.classServices.put(classes[i], s);
                }
                s.add(res);
            }
        }
        bundle.framework.listeners.serviceChanged(new ServiceEvent(1, res.getReference()));
        return res;
    }

    synchronized ServiceReference get(BundleImpl bundle, String clazz) {
        ArrayList v = (ArrayList)this.classServices.get(clazz);
        if (v != null) {
            ServiceReference lowestId;
            ServiceReference res = lowestId = ((ServiceRegistration)v.get(0)).getReference();
            int size = v.size();
            if (size > 1) {
                int rank_res = this.ranking(res);
                for (int i = 1; i < size; ++i) {
                    ServiceReference s = ((ServiceRegistration)v.get(i)).getReference();
                    int rank_s = this.ranking(s);
                    if (rank_s <= rank_res || !s.isAssignableTo(bundle, clazz)) continue;
                    res = s;
                    rank_res = rank_s;
                }
            }
            if (res == lowestId) {
                if (res.isAssignableTo(bundle, clazz)) {
                    return res;
                }
                return null;
            }
            return res;
        }
        return null;
    }

    synchronized ServiceReference[] get(String clazz, String filter, BundleImpl bundle, boolean doAssignableToTest) throws InvalidSyntaxException {
        Iterator<Object> s;
        if (clazz == null) {
            s = this.services.keySet().iterator();
            if (s == null) {
                return null;
            }
        } else {
            ArrayList v = (ArrayList)this.classServices.get(clazz);
            if (v != null) {
                s = ((AbstractList)v).iterator();
            } else {
                return null;
            }
        }
        ArrayList<ServiceReference> res = new ArrayList<ServiceReference>();
        while (s.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)s.next();
            String[] classes = (String[])this.services.get(sr);
            if (classes == null) {
                return null;
            }
            if (!this.secure.okGetServicePerms(classes) || filter != null && !LDAPExpr.query(filter, sr.properties)) continue;
            if (doAssignableToTest) {
                int i;
                int length = classes.length;
                for (i = 0; i < length && sr.getReference().isAssignableTo(bundle, classes[i]); ++i) {
                }
                if (i != length) continue;
                res.add(sr.getReference());
                continue;
            }
            res.add(sr.getReference());
        }
        if (res.isEmpty()) {
            return null;
        }
        ServiceReference[] a = new ServiceReference[res.size()];
        res.toArray((Object[])a);
        return a;
    }

    synchronized void removeServiceRegistration(ServiceRegistrationImpl sr) {
        String[] classes = (String[])sr.properties.get("objectClass");
        this.services.remove(sr);
        for (int i = 0; i < classes.length; ++i) {
            ArrayList s = (ArrayList)this.classServices.get(classes[i]);
            if (s.size() > 1) {
                ((AbstractCollection)s).remove(sr);
                continue;
            }
            this.classServices.remove(classes[i]);
        }
    }

    synchronized Set getRegisteredByBundle(Bundle b) {
        HashSet<ServiceRegistrationImpl> res = new HashSet<ServiceRegistrationImpl>();
        Iterator e = this.services.keySet().iterator();
        while (e.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)e.next();
            if (sr.bundle != b) continue;
            res.add(sr);
        }
        return res;
    }

    synchronized Set getUsedByBundle(Bundle b) {
        HashSet<ServiceRegistrationImpl> res = new HashSet<ServiceRegistrationImpl>();
        Iterator e = this.services.keySet().iterator();
        while (e.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)e.next();
            if (!sr.isUsedByBundle(b)) continue;
            res.add(sr);
        }
        return res;
    }

    private int ranking(ServiceReference s) {
        Object v = s.getProperty("service.ranking");
        if (v != null && v instanceof Integer) {
            return (Integer)v;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

