/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Framework;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLStreamHandlerWrapper
extends URLStreamHandler
implements URLStreamHandlerSetter {
    Framework framework;
    String protocol;
    String filter;
    private ServiceReference best;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;

    URLStreamHandlerWrapper(Framework fw, String proto) {
        this.framework = fw;
        this.protocol = proto;
        this.filter = "(&(objectClass=" + (class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLStreamHandlerWrapper.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName() + ")" + "(" + "url.handler.protocol" + "=" + this.protocol + ")" + ")";
        ServiceListener serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent evt) {
                ServiceReference ref = evt.getServiceReference();
                switch (evt.getType()) {
                    case 1: 
                    case 2: {
                        if (URLStreamHandlerWrapper.this.best == null) {
                            URLStreamHandlerWrapper.this.updateBest();
                            return;
                        }
                        if (URLStreamHandlerWrapper.this.compare(URLStreamHandlerWrapper.this.best, ref) <= 0) break;
                        URLStreamHandlerWrapper.this.best = ref;
                        break;
                    }
                    case 4: {
                        if (!URLStreamHandlerWrapper.this.best.equals(ref)) break;
                        URLStreamHandlerWrapper.this.best = null;
                    }
                }
            }
        };
        try {
            this.framework.systemBC.addServiceListener(serviceListener, this.filter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not register service listener for url handler: " + e);
        }
        if (Debug.url) {
            Debug.println("created wrapper for " + this.protocol + ", filter=" + this.filter + ", " + this.toString());
        }
    }

    private int compare(ServiceReference ref1, ServiceReference ref2) {
        int r2;
        Object tmp1 = ref1.getProperty("service.ranking");
        Object tmp2 = ref2.getProperty("service.ranking");
        int r1 = tmp1 instanceof Integer ? (Integer)tmp1 : 0;
        int n = r2 = tmp2 instanceof Integer ? (Integer)tmp2 : 0;
        if (r2 == r1) {
            Long i1 = (Long)ref1.getProperty("service.id");
            Long i2 = (Long)ref2.getProperty("service.id");
            return i1.compareTo(i2);
        }
        return r2 - r1;
    }

    private void updateBest() {
        try {
            ServiceReference[] refs = this.framework.systemBC.getServiceReferences((class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLStreamHandlerWrapper.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName(), this.filter);
            if (refs != null) {
                this.best = refs[0];
            }
            for (int i = 1; i < refs.length; ++i) {
                if (this.compare(this.best, refs[i]) <= 0) continue;
                this.best = refs[i];
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not register url handler: " + e);
        }
    }

    private URLStreamHandlerService getService() {
        URLStreamHandlerService obj;
        try {
            if (this.best == null) {
                this.updateBest();
            }
            if (this.best == null) {
                throw new IllegalStateException("null: Lost service for protocol=" + this.protocol);
            }
            obj = (URLStreamHandlerService)this.framework.systemBC.getService(this.best);
            if (obj == null) {
                throw new IllegalStateException("null: Lost service for protocol=" + this.protocol);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("null: Lost service for protocol=" + this.protocol);
        }
        return obj;
    }

    public boolean equals(URL u1, URL u2) {
        return this.getService().equals(u1, u2);
    }

    protected int getDefaultPort() {
        return this.getService().getDefaultPort();
    }

    protected InetAddress getHostAddress(URL u) {
        return this.getService().getHostAddress(u);
    }

    protected int hashCode(URL u) {
        return this.getService().hashCode(u);
    }

    protected boolean hostsEqual(URL u1, URL u2) {
        return this.getService().hostsEqual(u1, u2);
    }

    protected URLConnection openConnection(URL u) throws IOException {
        try {
            return this.getService().openConnection(u);
        }
        catch (IllegalStateException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        this.getService().parseURL(this, u, spec, start, limit);
    }

    protected boolean sameFile(URL u1, URL u2) {
        return this.getService().sameFile(u1, u2);
    }

    public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
        String authority = null;
        String userInfo = null;
        if (host != null && host.length() != 0) {
            authority = port == -1 ? host : host + ":" + port;
            int ix = host.lastIndexOf(64);
            if (ix != -1) {
                userInfo = host.substring(0, ix);
                host = host.substring(ix + 1);
            }
        }
        String path = null;
        String query = null;
        if (file != null) {
            int ix = file.lastIndexOf(63);
            if (ix != -1) {
                query = file.substring(ix + 1);
                path = file.substring(0, ix);
            } else {
                path = file;
            }
        }
        this.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }

    public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }

    protected String toExternalForm(URL u) {
        return this.getService().toExternalForm(u);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("URLStreamHandlerWrapper[");
        ServiceReference ref = this.best;
        sb.append("protocol=" + this.protocol);
        if (ref != null) {
            sb.append(", id=" + ref.getProperty("service.id"));
            sb.append(", rank=" + ref.getProperty("service.ranking"));
        } else {
            sb.append(" no service tracked");
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

