/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Util;

class Archive {
    private static final String ARCHIVE = "jar";
    private static final String SUBDIR = "sub";
    private static final String OSGI_OPT_DIR = "OSGI-OPT/";
    private static final boolean unpack = new Boolean(System.getProperty("org.knopflerfish.framework.bundlestorage.file.unpack", "true"));
    private static final boolean alwaysUnpack = new Boolean(System.getProperty("org.knopflerfish.framework.bundlestorage.file.always_unpack", "false"));
    boolean bReference = new Boolean(System.getProperty("org.knopflerfish.framework.bundlestorage.file.reference", "false"));
    private FileTree file;
    private ZipFile jar;
    Manifest manifest;
    private ZipEntry subJar;
    FileTree refFile = null;
    boolean bClosed = false;

    Archive(File dir, int rev, InputStream is) throws IOException {
        this(dir, rev, is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Archive(File dir, int rev, InputStream is, URL source) throws IOException {
        BufferedInputStream bis = System.getProperty("java.vendor").startsWith("Skelmir") ? new BufferedInputStream(is, is.available()) : new BufferedInputStream(is, 8192);
        ZipInputStream zi = null;
        if (source != null && "reference".equals(source.getProtocol())) {
            this.bReference = true;
        }
        if (alwaysUnpack) {
            zi = new ZipInputStream(bis);
        } else if (unpack) {
            if (System.getProperty("java.vendor").startsWith("Skelmir")) {
                bis.mark(98304);
            } else {
                bis.mark(16000);
            }
            JarInputStream ji = new JarInputStream(bis);
            this.manifest = ji.getManifest();
            if (this.manifest != null) {
                if (this.checkManifest()) {
                    zi = ji;
                } else {
                    bis.reset();
                }
            } else {
                bis.reset();
            }
        }
        this.file = new FileTree(dir, ARCHIVE + rev);
        if (zi != null) {
            ZipEntry ze;
            File f;
            this.file.mkdirs();
            if (this.manifest != null) {
                f = new File(this.file, "META-INF");
                f.mkdir();
                BufferedOutputStream o = new BufferedOutputStream(new FileOutputStream(new File(f, "MANIFEST.MF")));
                try {
                    this.manifest.write(o);
                }
                finally {
                    o.close();
                }
            }
            while ((ze = zi.getNextEntry()) != null) {
                if (ze.isDirectory() || this.isSkipped(ze.getName())) continue;
                StringTokenizer st = new StringTokenizer(ze.getName(), "/");
                f = new File(this.file, st.nextToken());
                while (st.hasMoreTokens()) {
                    f.mkdir();
                    f = new File(f, st.nextToken());
                }
                this.loadFile(f, zi, true);
            }
            this.jar = null;
        } else if (source != null && this.bReference && "file".equals(source.getProtocol())) {
            this.refFile = new FileTree(source.getFile());
            this.jar = new ZipFile(this.refFile);
        } else {
            this.loadFile(this.file, bis, true);
            this.jar = new ZipFile(this.file);
        }
        if (this.manifest == null) {
            this.manifest = this.getManifest();
            this.checkManifest();
        }
    }

    boolean isSkipped(String pathName) {
        return pathName.startsWith(OSGI_OPT_DIR);
    }

    Archive(File dir, int rev, String location) throws IOException {
        int i;
        String[] f = dir.list();
        this.file = null;
        if (rev != -1) {
            this.file = new FileTree(dir, ARCHIVE + rev);
        } else {
            rev = Integer.MAX_VALUE;
            for (i = 0; i < f.length; ++i) {
                if (!f[i].startsWith(ARCHIVE)) continue;
                try {
                    int c = Integer.parseInt(f[i].substring(ARCHIVE.length()));
                    if (c >= rev) continue;
                    rev = c;
                    this.file = new FileTree(dir, f[i]);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < f.length; ++i) {
            if (f[i].startsWith(ARCHIVE)) {
                try {
                    int c = Integer.parseInt(f[i].substring(ARCHIVE.length()));
                    if (c != rev) {
                        new FileTree(dir, f[i]).delete();
                    }
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (!f[i].startsWith(SUBDIR)) continue;
            try {
                int c = Integer.parseInt(f[i].substring(SUBDIR.length()));
                if (c == rev) continue;
                new FileTree(dir, f[i]).delete();
                continue;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if (this.file == null || !this.file.exists()) {
            if (this.bReference && location != null) {
                try {
                    URL source = new URL(location);
                    if ("file".equals(source.getProtocol())) {
                        this.refFile = this.file = new FileTree(source.getFile());
                    }
                }
                catch (Exception e) {
                    throw new IOException("Bad file URL stored in referenced jar in: " + dir.getAbsolutePath() + ", location=" + location);
                }
            }
            if (this.file == null || !this.file.exists()) {
                throw new IOException("No saved jar file found in: " + dir.getAbsolutePath() + ", old location=" + location);
            }
        }
        this.jar = this.file.isDirectory() ? null : new ZipFile(this.file);
        this.manifest = this.getManifest();
    }

    Archive(Archive a, String path) throws IOException {
        if (a.jar != null) {
            this.jar = a.jar;
            this.subJar = this.jar.getEntry(path);
            if (this.subJar == null) {
                throw new IOException("No such JAR component: " + path);
            }
            if (this.subJar.isDirectory() && !path.endsWith("/")) {
                this.subJar = this.jar.getEntry(path + "/");
            }
            this.file = a.file;
        } else {
            this.file = this.findFile(a.file, path);
            this.jar = this.file.isDirectory() ? null : new ZipFile(this.file);
        }
    }

    public String toString() {
        if (this.subJar != null) {
            return this.file.getAbsolutePath() + "(" + this.subJar.getName() + ")";
        }
        return this.file.getAbsolutePath();
    }

    int getRevision() {
        try {
            return Integer.parseInt(this.file.getName().substring(ARCHIVE.length()));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    String getAttribute(String key) {
        Attributes a = this.manifest.getMainAttributes();
        if (a != null) {
            return a.getValue(key);
        }
        return null;
    }

    byte[] getClassBytes(String classFile) throws IOException {
        if (this.bClosed) {
            return null;
        }
        InputFlow cif = this.getInputFlow(classFile);
        if (cif != null) {
            byte[] bytes;
            if (cif.length >= 0L) {
                bytes = new byte[(int)cif.length];
                DataInputStream dis = new DataInputStream(cif.is);
                dis.readFully(bytes);
            } else {
                bytes = new byte[]{};
                byte[] tmp = new byte[8192];
                try {
                    int len;
                    while ((len = cif.is.read(tmp)) > 0) {
                        byte[] oldbytes = bytes;
                        bytes = new byte[oldbytes.length + len];
                        System.arraycopy(oldbytes, 0, bytes, 0, oldbytes.length);
                        System.arraycopy(tmp, 0, bytes, oldbytes.length, len);
                    }
                }
                catch (EOFException ignore) {
                    // empty catch block
                }
            }
            cif.is.close();
            return bytes;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputFlow getInputFlow(String component) {
        JarEntry ze;
        JarInputStream ji;
        if (this.bClosed) {
            return null;
        }
        if (component.startsWith("/")) {
            throw new RuntimeException("Assert! Path should never start with / here");
        }
        try {
            block7: {
                block5: {
                    ZipEntry ze2;
                    block8: {
                        block6: {
                            if (this.jar == null) break block5;
                            if (this.subJar == null) break block6;
                            if (!this.subJar.isDirectory()) break block7;
                            ze2 = this.jar.getEntry(this.subJar.getName() + component);
                            break block8;
                        }
                        ze2 = this.jar.getEntry(component);
                    }
                    if (ze2 == null) return null;
                    InputFlow inputFlow = new InputFlow(this.jar.getInputStream(ze2), ze2.getSize());
                    return inputFlow;
                }
                FileTree f = this.findFile(this.file, component);
                if (!f.exists()) return null;
                InputFlow inputFlow = new InputFlow(new FileInputStream(f), f.length());
                return inputFlow;
            }
            ji = new JarInputStream(this.jar.getInputStream(this.subJar));
        }
        catch (IOException ignore) {
            return null;
        }
        do {
            if ((ze = ji.getNextJarEntry()) != null) continue;
            ji.close();
            return null;
        } while (!component.equals(ze.getName()));
        return new InputFlow(ji, ze.getSize());
    }

    Enumeration findResourcesPath(String path) {
        Vector<String> answer = new Vector<String>();
        if (this.jar != null) {
            path.replace('\\', '/');
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/") && path.length() > 1) {
                path = path + "/";
            }
            Enumeration<? extends ZipEntry> entries = this.jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                int idx = name.lastIndexOf(47);
                if (entry.isDirectory()) {
                    idx = name.substring(0, idx).lastIndexOf(47);
                }
                if (idx > 0) {
                    if (!name.substring(0, idx + 1).equals(path)) continue;
                    answer.add(name);
                    continue;
                }
                if (!path.equals("")) continue;
                answer.add(name);
            }
        } else {
            FileTree f = this.findFile(this.file, path);
            if (!f.exists()) {
                return null;
            }
            if (!f.isDirectory()) {
                return null;
            }
            File[] files = f.listFiles();
            int length = files.length;
            for (int i = 0; i < length; ++i) {
                String filePath = files[i].getPath();
                filePath = filePath.substring(this.file.getPath().length() + 1);
                filePath.replace(File.separatorChar, '/');
                if (files[i].isDirectory()) {
                    filePath = filePath + "/";
                }
                answer.add(filePath);
            }
        }
        if (answer.size() == 0) {
            return null;
        }
        return answer.elements();
    }

    Archive getSubArchive(String path) throws IOException {
        if (this.bClosed) {
            return null;
        }
        return new Archive(this, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getNativeLibrary(String path) throws IOException {
        File lib;
        if (this.bClosed) {
            throw new IOException("Archive is closed");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.jar != null) {
            lib = this.getSubFile(this, path);
            if (lib.exists()) return lib.getAbsolutePath();
            new File(lib.getParent()).mkdirs();
            ZipEntry ze = this.jar.getEntry(path);
            if (ze == null) throw new FileNotFoundException("No such sub-archive: " + path);
            InputStream is = this.jar.getInputStream(ze);
            try {
                this.loadFile(lib, is, false);
                return lib.getAbsolutePath();
            }
            finally {
                is.close();
            }
        } else {
            lib = this.findFile(this.file, path);
            if (lib.exists() || lib.getParent() == null) return lib.getAbsolutePath();
            final String libname = lib.getName();
            File[] list = lib.getParentFile().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    int pos = name.lastIndexOf(libname);
                    return pos > 1 && name.charAt(pos - 1) == '_';
                }
            });
            if (list.length <= 0) return lib.getAbsolutePath();
            list[0].renameTo(lib);
        }
        return lib.getAbsolutePath();
    }

    void purge() {
        this.close();
        this.file.delete();
        this.getSubFileTree(this).delete();
    }

    void close() {
        this.bClosed = true;
        if (this.subJar == null && this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkManifest() {
        Attributes a = this.manifest.getMainAttributes();
        Util.parseEntries("Export-Package", a.getValue("Export-Package"), false, true, false);
        Util.parseEntries("Import-Package", a.getValue("Import-Package"), false, true, false);
        Iterator nc = Util.parseEntries("Bundle-NativeCode", a.getValue("Bundle-NativeCode"), false, false, false);
        String bc = a.getValue("Bundle-ClassPath");
        return bc != null && !bc.trim().equals(".") || nc.hasNext();
    }

    private FileTree findFile(File root, String path) {
        return new FileTree(root, path.replace('/', File.separatorChar));
    }

    private Manifest getManifest() throws IOException {
        InputFlow mif = this.getInputFlow("META-INF/MANIFEST.MF");
        if (mif != null) {
            return new Manifest(mif.is);
        }
        throw new IOException("Manifest is missing");
    }

    private FileTree getSubFileTree(Archive archive) {
        return new FileTree(archive.file.getParent(), SUBDIR + archive.file.getName().substring(ARCHIVE.length()));
    }

    private File getSubFile(Archive archive, String path) {
        return new File(this.getSubFileTree(archive), path.replace('/', '-'));
    }

    private void loadFile(File output, InputStream is, boolean verify) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(output);
            byte[] buf = new byte[8192];
            try {
                int n;
                while ((n = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, n);
                }
            }
            catch (EOFException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            output.delete();
            throw e;
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    String getPath() {
        return this.file.getAbsolutePath();
    }

    class InputFlow {
        final InputStream is;
        final long length;

        InputFlow(InputStream is, long length) {
            this.is = is;
            this.length = length;
        }
    }
}

