/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FilterImpl;
import org.knopflerfish.framework.Framework;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.VersionRange;
import org.knopflerfish.framework.bundlestorage.file.Archive;
import org.knopflerfish.framework.bundlestorage.file.BundleStorageImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

class BundleArchiveImpl
implements BundleArchive {
    private static final String LOCATION_FILE = "location";
    private static final String REV_FILE = "revision";
    private static final String STOP_FILE = "stopped";
    private static final String STARTLEVEL_FILE = "startlevel";
    private static final String PERSISTENT_FILE = "persistent";
    private static final String LAST_MODIFIED_FILE = "lastModifed";
    private static Method mapLibraryName;
    private Archive archive;
    private long id;
    private String location;
    private boolean startOnLaunch;
    private FileTree bundleDir;
    private BundleStorageImpl storage;
    private Archive[] archives;
    private Map nativeLibs;
    private Map renameLibs;
    private int startLevel = -1;
    private boolean bPersistent;
    private long lastModified = 0L;
    private ArrayList failedPath = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$System;

    BundleArchiveImpl(BundleStorageImpl bundleStorage, FileTree dir, InputStream is, String bundleLocation, long bundleId) throws Exception {
        URL source = null;
        try {
            source = new URL(bundleLocation);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.bundleDir = dir;
        this.archive = new Archive(this.bundleDir, 0, is, source);
        this.storage = bundleStorage;
        this.id = bundleId;
        this.location = bundleLocation;
        this.startOnLaunch = false;
        this.nativeLibs = this.getNativeCode();
        this.setClassPath();
        this.putContent(STOP_FILE, new Boolean(!this.startOnLaunch).toString());
        this.putContent(LOCATION_FILE, this.location);
    }

    BundleArchiveImpl(BundleStorageImpl bundleStorage, FileTree dir, long bundleId) throws Exception {
        this.bundleDir = dir;
        this.location = this.getContent(LOCATION_FILE);
        if (this.location == null || this.location.length() == 0) {
            throw new IOException("No bundle location information found");
        }
        int rev = -1;
        String s = this.getContent(REV_FILE);
        if (s != null) {
            try {
                rev = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = this.getContent(STARTLEVEL_FILE)) != null) {
            try {
                this.startLevel = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.bPersistent = "true".equals(this.getContent(PERSISTENT_FILE));
        s = this.getContent(LAST_MODIFIED_FILE);
        if (s != null) {
            try {
                this.lastModified = Long.parseLong(s);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.archive = new Archive((File)this.bundleDir, rev, this.location);
        this.id = bundleId;
        this.storage = bundleStorage;
        this.startOnLaunch = new Boolean(this.getContent(STOP_FILE)) == false;
        this.nativeLibs = this.getNativeCode();
        this.setClassPath();
    }

    BundleArchiveImpl(BundleArchiveImpl old, InputStream is) throws Exception {
        this.bundleDir = old.bundleDir;
        this.location = old.location;
        this.storage = old.storage;
        this.id = old.id;
        this.startOnLaunch = old.startOnLaunch;
        this.bPersistent = old.bPersistent;
        int rev = old.archive.getRevision() + 1;
        this.archive = new Archive((File)this.bundleDir, rev, is);
        this.nativeLibs = this.getNativeCode();
        this.setClassPath();
        this.putContent(REV_FILE, Integer.toString(rev));
    }

    public String getAttribute(String key) {
        return this.archive.getAttribute(key);
    }

    public Hashtable getLocalizationEntries(String localeFile) {
        Archive.InputFlow aif = this.archive.getInputFlow(localeFile);
        if (aif != null) {
            Properties l = new Properties();
            try {
                l.load(aif.is);
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            try {
                aif.is.close();
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            return l;
        }
        return null;
    }

    public HeaderDictionary getUnlocalizedAttributes() {
        return new HeaderDictionary(this.archive.manifest.getMainAttributes());
    }

    public long getBundleId() {
        return this.id;
    }

    public String getBundleLocation() {
        return this.location;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int level) throws IOException {
        if (this.startLevel != level) {
            this.startLevel = level;
            this.putContent(STARTLEVEL_FILE, Integer.toString(this.startLevel));
        }
    }

    public void setPersistent(boolean b) throws IOException {
        if (this.bPersistent != b) {
            this.bPersistent = b;
            this.putContent(PERSISTENT_FILE, b ? "true" : "false");
        }
    }

    public boolean isPersistent() {
        return this.bPersistent;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long timemillisecs) throws IOException {
        this.lastModified = timemillisecs;
        this.putContent(LAST_MODIFIED_FILE, Long.toString(timemillisecs));
    }

    public byte[] getClassBytes(Integer sub, String path) throws IOException {
        return this.archives[sub].getClassBytes(path);
    }

    public Vector componentExists(String component, boolean onlyFirst) {
        Vector<Integer> v = null;
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        for (int i = 0; i < this.archives.length; ++i) {
            Archive.InputFlow aif = this.archives[i].getInputFlow(component);
            if (aif == null) continue;
            if (v == null) {
                v = new Vector<Integer>();
            }
            v.addElement(new Integer(i));
            try {
                aif.is.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            if (onlyFirst) break;
        }
        return v;
    }

    public InputStream getInputStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        Archive.InputFlow aif = ix == -1 ? this.archive.getInputFlow(component) : this.archives[ix].getInputFlow(component);
        return aif != null ? aif.is : null;
    }

    public String getNativeLibrary(String libName) {
        if (this.nativeLibs != null) {
            try {
                String key = (String)mapLibraryName.invoke(null, libName);
                String val = (String)this.nativeLibs.get(key);
                File file1 = new File(val);
                if (file1.exists() && file1.isFile()) {
                    File file2;
                    if (this.renameLibs.containsKey(key) && file1.renameTo(file2 = new File((String)this.renameLibs.get(key)))) {
                        val = file2.getAbsolutePath();
                        this.nativeLibs.put(key, val);
                    }
                    StringBuffer rename = new StringBuffer(val);
                    int index0 = val.lastIndexOf(File.separatorChar) + 1;
                    int index1 = val.indexOf("_", index0);
                    if (index1 > index0 && index1 == val.length() - key.length() - 1) {
                        try {
                            int prefix = Integer.parseInt(val.substring(index0, index1));
                            rename.replace(index0, index1, Integer.toString(prefix + 1));
                        }
                        catch (Throwable t) {
                            rename.insert(index0, "0_");
                        }
                    } else {
                        rename.insert(index0, "0_");
                    }
                    this.renameLibs.put(key, rename.toString());
                }
                return val;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean getStartOnLaunchFlag() {
        return this.startOnLaunch;
    }

    public void setStartOnLaunchFlag(boolean value) throws IOException {
        if (this.startOnLaunch != value) {
            this.startOnLaunch = value;
            this.putContent(STOP_FILE, new Boolean(!this.startOnLaunch).toString());
        }
    }

    public void purge() {
        this.close();
        if (this.storage.removeArchive(this)) {
            new File(this.bundleDir, LOCATION_FILE).delete();
            new File(this.bundleDir, STOP_FILE).delete();
            new File(this.bundleDir, REV_FILE).delete();
            new File(this.bundleDir, STARTLEVEL_FILE).delete();
            new File(this.bundleDir, PERSISTENT_FILE).delete();
            new File(this.bundleDir, LAST_MODIFIED_FILE).delete();
        }
        this.archive.purge();
        if (this.bundleDir.list().length == 0) {
            this.bundleDir.delete();
        }
    }

    public void close() {
        for (int i = 0; i < this.archives.length; ++i) {
            this.archives[i].close();
        }
        this.archive.close();
    }

    public List getFailedClassPathEntries() {
        return this.failedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getContent(String f) {
        FilterInputStream in = null;
        in = new DataInputStream(new FileInputStream(new File(this.bundleDir, f)));
        String string = ((DataInputStream)in).readUTF();
        Object var5_5 = null;
        if (in == null) return string;
        try {
            in.close();
            return string;
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return string;
        catch (IOException iOException) {
            try {
                Object var5_6 = null;
                if (in == null) return null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
                return null;
            }
            catch (IOException ignore) {}
            return null;
        }
    }

    static boolean isUninstalled(File dir) {
        String s = BundleArchiveImpl.getContent(dir, LAST_MODIFIED_FILE);
        if (s == null || s.length() == 0) {
            return true;
        }
        s = BundleArchiveImpl.getContent(dir, STARTLEVEL_FILE);
        int n = -1;
        try {
            n = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n == -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getContent(File dir, String f) {
        FilterInputStream in = null;
        in = new DataInputStream(new FileInputStream(new File(dir, f)));
        String string = ((DataInputStream)in).readUTF();
        Object var5_5 = null;
        if (in == null) return string;
        try {
            in.close();
            return string;
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return string;
        catch (IOException iOException) {
            try {
                Object var5_6 = null;
                if (in == null) return null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
                return null;
            }
            catch (IOException ignore) {}
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putContent(String f, String content) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(new File(this.bundleDir, f)));
            ((DataOutputStream)out).writeUTF(content);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void setClassPath() throws IOException {
        String bcp = this.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            ArrayList<Archive> a = new ArrayList<Archive>();
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                if (".".equals(path)) {
                    a.add(this.archive);
                    continue;
                }
                try {
                    a.add(this.archive.getSubArchive(path));
                }
                catch (IOException ioe) {
                    if (this.failedPath == null) {
                        this.failedPath = new ArrayList(1);
                    }
                    this.failedPath.add(path);
                }
            }
            this.archives = a.toArray(new Archive[a.size()]);
        } else {
            this.archives = new Archive[]{this.archive};
        }
    }

    private Map getNativeCode() throws Exception {
        String bnc = this.getAttribute("Bundle-NativeCode");
        if (bnc != null) {
            if (mapLibraryName == null) {
                throw new Exception("Native-Code: Not supported on non Java 2 platforms.");
            }
            String proc = Framework.getProperty("org.osgi.framework.processor");
            String os = Framework.getProperty("org.osgi.framework.os.name");
            Version osVer = new Version(Framework.getProperty("org.osgi.framework.os.version"));
            String osLang = Framework.getProperty("org.osgi.framework.language");
            boolean optional = false;
            List best = null;
            VersionRange bestVer = null;
            boolean bestLang = false;
            Iterator i = Util.parseEntries("Bundle-NativeCode", bnc, false, false, false);
            while (i.hasNext()) {
                FilterImpl filter;
                List sf;
                List lang;
                List ol;
                VersionRange matchVer = null;
                boolean matchLang = false;
                Map params = (Map)i.next();
                List keys = (List)params.get("keys");
                if (keys.size() == 1 && "*".equals(keys.get(0)) && !i.hasNext()) {
                    optional = true;
                    break;
                }
                List pl = (List)params.get("processor");
                if (pl == null || !this.containsIgnoreCase(pl, Alias.unifyProcessor(proc)) || (ol = (List)params.get("osname")) == null || !this.containsIgnoreCase(ol, Alias.unifyOsName(os))) continue;
                List ver = (List)params.get("osversion");
                if (ver != null) {
                    boolean okVer = false;
                    Iterator v = ver.iterator();
                    while (v.hasNext()) {
                        matchVer = new VersionRange((String)v.next());
                        if (!matchVer.withinRange(osVer)) continue;
                        okVer = true;
                        break;
                    }
                    if (!okVer) continue;
                }
                if ((lang = (List)params.get("language")) != null) {
                    Iterator l = lang.iterator();
                    while (l.hasNext()) {
                        if (!osLang.equalsIgnoreCase((String)l.next())) continue;
                        matchLang = true;
                        break;
                    }
                    if (!matchLang) continue;
                }
                if ((sf = (List)params.get("selection-filter")) != null && sf.size() == 1 && !(filter = new FilterImpl((String)sf.get(0))).match(Framework.getProperties())) continue;
                if (best != null) {
                    boolean verEqual = false;
                    if (bestVer != null) {
                        if (matchVer == null) continue;
                        int d = bestVer.compareTo(matchVer);
                        if (d == 0) {
                            verEqual = true;
                        } else if (d > 0) {
                            continue;
                        }
                    } else if (matchVer == null) {
                        verEqual = true;
                    }
                    if (verEqual && (!matchLang || bestLang)) continue;
                }
                best = keys;
                bestVer = matchVer;
                bestLang = matchLang;
            }
            if (best == null) {
                if (optional) {
                    return null;
                }
                throw new BundleException("Native-Code: No matching libraries found.");
            }
            this.renameLibs = new HashMap();
            HashMap<String, String> res = new HashMap<String, String>();
            Iterator p = best.iterator();
            while (p.hasNext()) {
                String name = (String)p.next();
                int sp = name.lastIndexOf(47);
                String key = sp != -1 ? name.substring(sp + 1) : name;
                res.put(key, this.archive.getNativeLibrary(name));
            }
            return res;
        }
        return null;
    }

    private boolean containsIgnoreCase(List l, List l2) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            Iterator j = l2.iterator();
            while (j.hasNext()) {
                if (!s.equalsIgnoreCase((String)j.next())) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration findResourcesPath(String path) {
        return this.archive.findResourcesPath(path);
    }

    public String getJarLocation() {
        return this.archive.getPath();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            mapLibraryName = (class$java$lang$System == null ? (class$java$lang$System = BundleArchiveImpl.class$("java.lang.System")) : class$java$lang$System).getDeclaredMethod("mapLibraryName", class$java$lang$String == null ? (class$java$lang$String = BundleArchiveImpl.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException ignore) {
            mapLibraryName = null;
        }
    }
}

