/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();
    private boolean addedAll = false;
    private int allMask;

    public void add(Permission permission) {
        AdminPermission existing;
        if (this.isReadOnly()) {
            throw new SecurityException("read only PermissionCollection");
        }
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        AdminPermission ap = (AdminPermission)permission;
        String name = null;
        if (ap.bundle != null) {
            existing = (AdminPermission)this.permissions.get(ap.bundle);
        } else {
            name = ap.getName();
            existing = (AdminPermission)this.permissions.get(name);
        }
        if (existing != null) {
            int oldMask = existing.actionMask;
            int newMask = ap.actionMask;
            if (oldMask != newMask) {
                if (ap.bundle != null) {
                    this.permissions.put(ap.bundle, new AdminPermission(ap.bundle, oldMask | newMask));
                } else {
                    this.permissions.put(name, new AdminPermission(name, oldMask | newMask));
                }
            }
        } else if (ap.bundle != null) {
            this.permissions.put(ap.bundle, permission);
        } else {
            this.permissions.put(name, permission);
        }
        if (name != null && name.equals("*")) {
            this.addedAll = true;
            this.allMask |= ap.actionMask;
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission ap = (AdminPermission)permission;
        if (this.addedAll && (this.allMask | ap.actionMask) == this.allMask) {
            return true;
        }
        if (ap.bundle != null) {
            Permission inTable = (Permission)this.permissions.get(ap.bundle);
            if (inTable == null) {
                return false;
            }
            return inTable.implies(ap);
        }
        Enumeration enume = this.permissions.keys();
        while (enume.hasMoreElements()) {
            if (!((Permission)this.permissions.get(enume.nextElement())).implies(permission)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

