/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitfinex.BitfinexErrorAdapter;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexAccountServiceRaw;
import org.knowm.xchange.bitfinex.service.BitfinexAdapters;
import org.knowm.xchange.bitfinex.v1.BitfinexUtils;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexDepositAddressResponse;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.MoneroWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BitfinexAccountService
extends BitfinexAccountServiceRaw
implements AccountService {
    public BitfinexAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(BitfinexAdapters.adaptWallets(this.getBitfinexAccountInfo()));
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            String type = BitfinexUtils.convertToBitfinexWithdrawalType(currency.toString());
            String walletSelected = "exchange";
            return this.withdraw(type, walletSelected, amount, address);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address, String tagOrPaymentId) throws IOException {
        try {
            String type = BitfinexUtils.convertToBitfinexWithdrawalType(currency.toString());
            String walletSelected = "exchange";
            return this.withdraw(type, walletSelected, amount, address, tagOrPaymentId);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        try {
            if (params instanceof RippleWithdrawFundsParams) {
                RippleWithdrawFundsParams xrpParams = (RippleWithdrawFundsParams)params;
                return this.withdrawFunds(xrpParams.getCurrency(), xrpParams.getAmount(), xrpParams.getAddress(), xrpParams.getTag());
            }
            if (params instanceof MoneroWithdrawFundsParams) {
                MoneroWithdrawFundsParams xmrParams = (MoneroWithdrawFundsParams)params;
                return this.withdrawFunds(xmrParams.getCurrency(), xmrParams.getAmount(), xmrParams.getAddress(), xmrParams.getPaymentId());
            }
            if (params instanceof DefaultWithdrawFundsParams) {
                DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
                return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
            }
            throw new IllegalStateException("Don't know how to withdraw: " + params);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        try {
            BitfinexDepositAddressResponse response = super.requestDepositAddressRaw(currency.getCurrencyCode());
            return response.getAddress();
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BitfinexFundingHistoryParams(null, null, null, Currency.BTC);
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        try {
            String currency = null;
            if (!(params instanceof TradeHistoryParamCurrency) || ((TradeHistoryParamCurrency)params).getCurrency() == null) {
                throw new ExchangeException("Currency must be supplied");
            }
            currency = ((TradeHistoryParamCurrency)params).getCurrency().getCurrencyCode();
            Date startTime = null;
            Date endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                startTime = ((TradeHistoryParamsTimeSpan)params).getStartTime();
                endTime = ((TradeHistoryParamsTimeSpan)params).getEndTime();
            }
            Integer limit = null;
            if (params instanceof TradeHistoryParamLimit) {
                TradeHistoryParamLimit limitParams = (TradeHistoryParamLimit)params;
                limit = limitParams.getLimit();
            }
            return BitfinexAdapters.adaptFundingHistory(this.getDepositWithdrawalHistory(currency, null, startTime, endTime, limit));
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        try {
            List allCurrencyPairs = this.exchange.getExchangeSymbols();
            return BitfinexAdapters.adaptDynamicTradingFees(this.getBitfinexDynamicTradingFees(), allCurrencyPairs);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public static class BitfinexFundingHistoryParams
    extends DefaultTradeHistoryParamsTimeSpan
    implements TradeHistoryParamCurrency,
    TradeHistoryParamLimit {
        private Integer limit;
        private Currency currency;

        public BitfinexFundingHistoryParams(Date startTime, Date endTime, Integer limit, Currency currency) {
            super(startTime, endTime);
            this.limit = limit;
            this.currency = currency;
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }
    }
}

