/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitfinex.BitfinexErrorAdapter;
import org.knowm.xchange.bitfinex.BitfinexResilience;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexAccountService;
import org.knowm.xchange.bitfinex.service.BitfinexAdapters;
import org.knowm.xchange.bitfinex.service.BitfinexMarketDataService;
import org.knowm.xchange.bitfinex.service.BitfinexMarketDataServiceRaw;
import org.knowm.xchange.bitfinex.service.BitfinexTradeService;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexAccountFeesResponse;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexSymbolDetail;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexAccountInfosResponse;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.nonce.AtomicLongIncrementalTime2013NonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitfinexExchange
extends BaseExchange
implements Exchange {
    private static ResilienceRegistries RESILIENCE_REGISTRIES;
    private SynchronizedValueFactory<Long> nonceFactory = new AtomicLongIncrementalTime2013NonceFactory();

    protected void initServices() {
        this.marketDataService = new BitfinexMarketDataService(this, this.getResilienceRegistries());
        this.accountService = new BitfinexAccountService(this, this.getResilienceRegistries());
        this.tradeService = new BitfinexTradeService(this, this.getResilienceRegistries());
    }

    public ResilienceRegistries getResilienceRegistries() {
        if (RESILIENCE_REGISTRIES == null) {
            RESILIENCE_REGISTRIES = BitfinexResilience.createRegistries();
        }
        return RESILIENCE_REGISTRIES;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://api.bitfinex.com/");
        exchangeSpecification.setHost("api.bitfinex.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("BitFinex");
        exchangeSpecification.setExchangeDescription("BitFinex is a bitcoin exchange.");
        exchangeSpecification.getResilience().setRateLimiterEnabled(true);
        exchangeSpecification.getResilience().setRetryEnabled(true);
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public void remoteInit() throws IOException, ExchangeException {
        try {
            BitfinexMarketDataServiceRaw dataService = (BitfinexMarketDataServiceRaw)this.marketDataService;
            List<CurrencyPair> currencyPairs = dataService.getExchangeSymbols();
            this.exchangeMetaData = BitfinexAdapters.adaptMetaData(currencyPairs, this.exchangeMetaData);
            Map<CurrencyPair, BigDecimal> lastPrices = Arrays.stream(dataService.getBitfinexTickers(null)).map(BitfinexAdapters::adaptTicker).collect(Collectors.toMap(t -> t.getCurrencyPair(), t -> t.getLast()));
            List<BitfinexSymbolDetail> symbolDetails = dataService.getSymbolDetails();
            this.exchangeMetaData = BitfinexAdapters.adaptMetaData(this.exchangeMetaData, symbolDetails, lastPrices);
            if (this.exchangeSpecification.getApiKey() != null && this.exchangeSpecification.getSecretKey() != null) {
                Integer bitfinexPlatformStatusData = dataService.getBitfinexPlatformStatus()[0];
                boolean bitfinexPlatformStatusPresent = bitfinexPlatformStatusData != null;
                int bitfinexPlatformStatus = bitfinexPlatformStatusPresent ? bitfinexPlatformStatusData : 0;
                BitfinexAccountService accountService = (BitfinexAccountService)this.accountService;
                BitfinexAccountFeesResponse accountFees = accountService.getAccountFees();
                this.exchangeMetaData = BitfinexAdapters.adaptMetaData(accountFees, bitfinexPlatformStatus, bitfinexPlatformStatusPresent, this.exchangeMetaData);
                BitfinexTradeService tradeService = (BitfinexTradeService)this.tradeService;
                BitfinexAccountInfosResponse[] bitfinexAccountInfos = tradeService.getBitfinexAccountInfos();
                this.exchangeMetaData = BitfinexAdapters.adaptMetaData(bitfinexAccountInfos, this.exchangeMetaData);
            }
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }
}

