/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.knowm.xchange.bitfinex.BitfinexExchange;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexAdapters;
import org.knowm.xchange.bitfinex.service.BitfinexBaseService;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLend;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLendDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexSymbolDetail;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexCandle;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexFundingOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexFundingRawOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexPublicFundingTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexPublicTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexStats;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTradingOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTradingRawOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BookPrecision;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.Status;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import si.mazi.rescu.HttpStatusIOException;

public class BitfinexMarketDataServiceRaw
extends BitfinexBaseService {
    public BitfinexMarketDataServiceRaw(BitfinexExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker getBitfinexTicker(String pair) throws IOException {
        org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker bitfinexTicker = (org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker)this.decorateApiCall(() -> this.bitfinex.getTicker(pair)).withRetry(this.retry("market-ticker")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        return bitfinexTicker;
    }

    public BitfinexDepth getBitfinexOrderBook(String pair, Integer limitBids, Integer limitAsks) throws IOException {
        BitfinexDepth bitfinexDepth = limitBids == null && limitAsks == null ? (BitfinexDepth)this.decorateApiCall(() -> this.bitfinex.getBook(pair)).withRetry(this.retry("market-book")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call() : (BitfinexDepth)this.decorateApiCall(() -> this.bitfinex.getBook(pair, limitBids, limitAsks)).withRetry(this.retry("market-book")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        return bitfinexDepth;
    }

    public BitfinexLendDepth getBitfinexLendBook(String currency, int limitBids, int limitAsks) throws IOException {
        BitfinexLendDepth bitfinexLendDepth = (BitfinexLendDepth)this.decorateApiCall(() -> this.bitfinex.getLendBook(currency, limitBids, limitAsks)).withRetry(this.retry("market-lendBook")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        return bitfinexLendDepth;
    }

    public BitfinexTrade[] getBitfinexTrades(String pair, long sinceTimestamp) throws IOException {
        BitfinexTrade[] bitfinexTrades = (BitfinexTrade[])this.decorateApiCall(() -> this.bitfinex.getTrades(pair, sinceTimestamp)).withRetry(this.retry("market-trades")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        return bitfinexTrades;
    }

    public BitfinexLend[] getBitfinexLends(String currency, long sinceTimestamp, int limitTrades) throws IOException {
        BitfinexLend[] bitfinexLends = (BitfinexLend[])this.decorateApiCall(() -> this.bitfinex.getLends(currency, sinceTimestamp, limitTrades)).withRetry(this.retry("market-lends")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        return bitfinexLends;
    }

    public Collection<String> getBitfinexSymbols() throws IOException {
        return (Collection)this.decorateApiCall(() -> this.bitfinex.getSymbols()).withRetry(this.retry("market-symbols")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<CurrencyPair> getExchangeSymbols() throws IOException {
        ArrayList<CurrencyPair> currencyPairs = new ArrayList<CurrencyPair>();
        for (String symbol : this.bitfinex.getSymbols()) {
            currencyPairs.add(BitfinexAdapters.adaptCurrencyPair(symbol));
        }
        return currencyPairs;
    }

    public List<BitfinexSymbolDetail> getSymbolDetails() throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinex.getSymbolsDetails()).withRetry(this.retry("market-symbolDetail")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public Integer[] getBitfinexPlatformStatus() throws IOException {
        return (Integer[])this.decorateApiCall(this.bitfinexV2::getPlatformStatus).withRetry(this.retry("platform-status")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public BitfinexTicker[] getBitfinexTickers(Collection<CurrencyPair> currencyPairs) throws IOException {
        List tickers = (List)this.decorateApiCall(() -> this.bitfinexV2.getTickers(BitfinexAdapters.adaptCurrencyPairsToTickersParam(currencyPairs))).withRetry(this.retry("market-tickers")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        return BitfinexAdapters.adoptBitfinexTickers(tickers);
    }

    public BitfinexTicker getBitfinexTickerV2(CurrencyPair currencyPair) throws IOException {
        List tickers = (List)this.decorateApiCall(() -> this.bitfinexV2.getTickers(BitfinexAdapters.adaptCurrencyPairsToTickersParam(Collections.singletonList(currencyPair)))).withRetry(this.retry("market-ticker")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        BitfinexTicker[] ticker = BitfinexAdapters.adoptBitfinexTickers(tickers);
        if (ticker.length == 0) {
            throw new BitfinexException("Unknown Symbol");
        }
        return ticker[0];
    }

    public BitfinexPublicTrade[] getBitfinexPublicTrades(CurrencyPair currencyPair, int limitTrades, long startTimestamp, long endTimestamp, int sort) throws IOException {
        try {
            return (BitfinexPublicTrade[])this.decorateApiCall(() -> this.bitfinexV2.getPublicTrades(BitfinexAdapters.adaptCurrencyPair(currencyPair), limitTrades, startTimestamp, endTimestamp, sort)).withRetry(this.retry("market-trades")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        }
        catch (HttpStatusIOException e) {
            throw new BitfinexException(e.getHttpBody());
        }
    }

    public BitfinexPublicFundingTrade[] getBitfinexPublicFundingTrades(Currency currency, int limitTrades, long startTimestamp, long endTimestamp, int sort) throws IOException {
        try {
            return (BitfinexPublicFundingTrade[])this.decorateApiCall(() -> this.bitfinexV2.getPublicFundingTrades("f" + currency.toString(), limitTrades, startTimestamp, endTimestamp, sort)).withRetry(this.retry("market-fundingTrades")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        }
        catch (HttpStatusIOException e) {
            throw new BitfinexException(e.getHttpBody());
        }
    }

    public List<Status> getStatus(List<CurrencyPair> pairs) throws IOException {
        try {
            return (List)this.decorateApiCall(() -> this.bitfinexV2.getStatus("deriv", BitfinexAdapters.adaptCurrencyPairsToTickersParam(pairs))).withRetry(this.retry("market-status")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        }
        catch (HttpStatusIOException e) {
            throw new BitfinexException(e.getHttpBody());
        }
    }

    public List<BitfinexCandle> getFundingHistoricCandles(String candlePeriod, String pair, int fundingPeriod, int numOfCandles) throws IOException {
        String fundingPeriodStr = "p" + fundingPeriod;
        return (List)this.decorateApiCall(() -> this.bitfinexV2.getHistoricFundingCandles(candlePeriod, pair, fundingPeriodStr, numOfCandles)).withRetry(this.retry("market-fundingHistoricCandles")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<BitfinexCandle> getHistoricCandles(String candlePeriod, CurrencyPair currencyPair, Integer limit, Long startTimestamp, Long endTimestamp, Integer sort) throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.getHistoricCandles(candlePeriod, BitfinexAdapters.adaptCurrencyPair(currencyPair), limit, startTimestamp, endTimestamp, sort)).withRetry(this.retry("market-historicCandles")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<BitfinexStats> getStats(String key, String size, String symbol, String side, Integer sort, Long startTimestamp, Long endTimestamp, Integer limit) throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.getStats(key, size, symbol, side, sort, startTimestamp, endTimestamp, limit)).withRetry(this.retry("market-stats")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<BitfinexTradingOrder> tradingBook(String symbol, BookPrecision precision, Integer len) throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.tradingBook(symbol, precision, len)).withRetry(this.retry("market-tradingBook")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<BitfinexTradingRawOrder> tradingBookRaw(String symbol, Integer len) throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.tradingBookRaw(symbol, len)).withRetry(this.retry("market-tradingBook")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<BitfinexFundingOrder> fundingBook(String symbol, BookPrecision precision, Integer len) throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.fundingBook(symbol, precision, len)).withRetry(this.retry("market-fundingBook")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<BitfinexFundingRawOrder> fundingBookRaw(String symbol, Integer len) throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.fundingBookRaw(symbol, len)).withRetry(this.retry("market-fundingBook")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }
}

