/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.bitfinex.BitfinexErrorAdapter;
import org.knowm.xchange.bitfinex.BitfinexExchange;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexAdapters;
import org.knowm.xchange.bitfinex.service.BitfinexTradeServiceRaw;
import org.knowm.xchange.bitfinex.v1.BitfinexOrderType;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderFlags;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderStatusResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexReplaceOrderRequest;
import org.knowm.xchange.bitfinex.v2.dto.trade.Trade;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelAllOrders;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.DateUtils;

public class BitfinexTradeService
extends BitfinexTradeServiceRaw
implements TradeService {
    private static final OpenOrders noOpenOrders = new OpenOrders(new ArrayList());

    public BitfinexTradeService(BitfinexExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        try {
            BitfinexOrderStatusResponse[] activeOrders = this.getBitfinexOpenOrders();
            if (activeOrders.length <= 0) {
                return noOpenOrders;
            }
            return this.filterOrders(BitfinexAdapters.adaptOrders(activeOrders), params);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    private OpenOrders filterOrders(OpenOrders rawOpenOrders, OpenOrdersParams params) {
        if (params == null) {
            return rawOpenOrders;
        }
        List openOrdersList = rawOpenOrders.getOpenOrders();
        openOrdersList.removeIf(openOrder -> !params.accept(openOrder));
        return new OpenOrders(openOrdersList, rawOpenOrders.getHiddenOrders());
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        try {
            BitfinexOrderStatusResponse newOrder = marketOrder.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.MARGIN) ? this.placeBitfinexMarketOrder(marketOrder, BitfinexOrderType.MARGIN_MARKET) : this.placeBitfinexMarketOrder(marketOrder, BitfinexOrderType.MARKET);
            return String.valueOf(newOrder.getId());
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        try {
            BitfinexOrderType type = BitfinexAdapters.adaptOrderFlagsToType(limitOrder.getOrderFlags());
            BitfinexOrderStatusResponse newOrder = this.placeBitfinexLimitOrder(limitOrder, type);
            return String.valueOf(newOrder.getId());
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public String changeOrder(LimitOrder order) throws IOException {
        boolean useRemaining = order.getOriginalAmount() == null || order.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.USE_REMAINING);
        BitfinexReplaceOrderRequest request = new BitfinexReplaceOrderRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue()), Long.valueOf(order.getId()), BitfinexAdapters.adaptCurrencyPair(order.getCurrencyPair()), order.getOriginalAmount(), order.getLimitPrice(), "bitfinex", BitfinexAdapters.adaptOrderType(order.getType()), BitfinexAdapters.adaptOrderFlagsToType(order.getOrderFlags()).getValue(), order.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.HIDDEN), order.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.POST_ONLY), useRemaining);
        try {
            BitfinexOrderStatusResponse response = this.bitfinex.replaceOrder(this.apiKey, this.payloadCreator, this.signatureCreator, request);
            return String.valueOf(response.getId());
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        if (stopOrder.getLimitPrice() != null) {
            throw new NotYetImplementedForExchangeException("Limit stops are not supported by the Bitfinex v1 API.");
        }
        LimitOrder limitOrder = new LimitOrder(stopOrder.getType(), stopOrder.getOriginalAmount(), (Instrument)stopOrder.getCurrencyPair(), stopOrder.getId(), stopOrder.getTimestamp(), stopOrder.getStopPrice());
        limitOrder.setOrderFlags(stopOrder.getOrderFlags());
        limitOrder.setLeverage(stopOrder.getLeverage());
        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.STOP);
        return this.placeLimitOrder(limitOrder);
    }

    public boolean cancelOrder(String orderId) throws IOException {
        try {
            return this.cancelBitfinexOrder(orderId);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        try {
            if (orderParams instanceof CancelOrderByIdParams) {
                return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
            }
            if (orderParams instanceof CancelAllOrders) {
                return this.cancelAllBitfinexOrders();
            }
            throw new IllegalArgumentException(String.format("Unknown parameter type: %s", orderParams.getClass()));
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        try {
            TradeHistoryParamLimit tradeHistoryParamLimit;
            String symbol = null;
            if (params instanceof TradeHistoryParamCurrencyPair && ((TradeHistoryParamCurrencyPair)params).getCurrencyPair() != null) {
                symbol = BitfinexAdapters.adaptCurrencyPair(((TradeHistoryParamCurrencyPair)params).getCurrencyPair());
            }
            Long startTime = 0L;
            Long endTime = null;
            Long limit = 50L;
            Long sort = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                TradeHistoryParamsTimeSpan paramsTimeSpan = (TradeHistoryParamsTimeSpan)params;
                startTime = DateUtils.toMillisNullSafe((Date)paramsTimeSpan.getStartTime());
                endTime = DateUtils.toMillisNullSafe((Date)paramsTimeSpan.getEndTime());
            }
            if (params instanceof TradeHistoryParamLimit && (tradeHistoryParamLimit = (TradeHistoryParamLimit)params).getLimit() != null) {
                limit = (long)tradeHistoryParamLimit.getLimit();
            }
            if (params instanceof TradeHistoryParamsSorted) {
                TradeHistoryParamsSorted tradeHistoryParamsSorted = (TradeHistoryParamsSorted)params;
                sort = tradeHistoryParamsSorted.getOrder() == TradeHistoryParamsSorted.Order.asc ? 1L : -1L;
            }
            List<Trade> trades = this.getBitfinexTradesV2(symbol, startTime, endTime, limit, sort);
            return BitfinexAdapters.adaptTradeHistoryV2(trades);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new BitfinexTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        try {
            ArrayList<Order> openOrders = new ArrayList<Order>();
            for (String orderId : orderIds) {
                BitfinexOrderStatusResponse orderStatus = this.getBitfinexOrderStatus(orderId);
                BitfinexOrderStatusResponse[] orderStatuses = new BitfinexOrderStatusResponse[1];
                if (orderStatus == null) continue;
                orderStatuses[0] = orderStatus;
                OpenOrders orders = BitfinexAdapters.adaptOrders(orderStatuses);
                openOrders.add((Order)orders.getOpenOrders().get(0));
            }
            return openOrders;
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public BigDecimal getMakerFee() throws IOException {
        return this.getBitfinexAccountInfos()[0].getMakerFees();
    }

    public BigDecimal getTakerFee() throws IOException {
        return this.getBitfinexAccountInfos()[0].getTakerFees();
    }

    public static class BitfinexTradeHistoryParams
    extends DefaultTradeHistoryParamsTimeSpan
    implements TradeHistoryParamCurrencyPair,
    TradeHistoryParamLimit,
    TradeHistoryParamsSorted {
        private CurrencyPair pair;
        private Integer limit;
        private TradeHistoryParamsSorted.Order order;

        public CurrencyPair getCurrencyPair() {
            return this.pair;
        }

        public void setCurrencyPair(CurrencyPair pair) {
            this.pair = pair;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public TradeHistoryParamsSorted.Order getOrder() {
            return this.order;
        }

        public void setOrder(TradeHistoryParamsSorted.Order order) {
            this.order = order;
        }
    }
}

