/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v1.dto.trade;

import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderStatusResponse;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class BitfinexLimitOrder
extends LimitOrder {
    private BigDecimal myOcoStopLimit;
    private BitfinexOrderStatusResponse response = null;

    public BitfinexLimitOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal limitPrice) {
        this(type, originalAmount, currencyPair, id, timestamp, limitPrice, null);
    }

    public BitfinexLimitOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal limitPrice, BigDecimal ocoStopLimit) {
        super(type, originalAmount, (Instrument)currencyPair, id, timestamp, limitPrice);
        this.myOcoStopLimit = ocoStopLimit;
    }

    public BitfinexOrderStatusResponse getResponse() {
        return this.response;
    }

    public void setResponse(BitfinexOrderStatusResponse value) {
        this.response = value;
    }

    public BigDecimal getOcoStopLimit() {
        return this.myOcoStopLimit;
    }

    public void setOcoStopLimit(BigDecimal ocoStopLimit) {
        this.myOcoStopLimit = ocoStopLimit;
    }

    public static class Builder
    extends LimitOrder.Builder {
        public Builder(Order.OrderType orderType, CurrencyPair currencyPair) {
            super(orderType, (Instrument)currencyPair);
        }

        public BitfinexLimitOrder build() {
            BitfinexLimitOrder order = new BitfinexLimitOrder(this.orderType, this.originalAmount, (CurrencyPair)this.instrument, this.id, this.timestamp, this.limitPrice);
            order.setOrderFlags(this.flags);
            return order;
        }
    }
}

