/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v2;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bitfinex.v2.Bitfinex;
import org.knowm.xchange.bitfinex.v2.dto.BitfinexExceptionV2;
import org.knowm.xchange.bitfinex.v2.dto.EmptyRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.LedgerEntry;
import org.knowm.xchange.bitfinex.v2.dto.account.LedgerRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.Movement;
import org.knowm.xchange.bitfinex.v2.dto.account.TransferBetweenWalletsRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.TransferBetweenWalletsResponse;
import org.knowm.xchange.bitfinex.v2.dto.account.UpdateCollateralDerivativePositionRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.Wallet;
import org.knowm.xchange.bitfinex.v2.dto.trade.ActiveOrder;
import org.knowm.xchange.bitfinex.v2.dto.trade.OrderTrade;
import org.knowm.xchange.bitfinex.v2.dto.trade.Position;
import org.knowm.xchange.bitfinex.v2.dto.trade.Trade;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="v2")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface BitfinexAuthenticated
extends Bitfinex {
    public static final String BFX_APIKEY = "bfx-apikey";
    public static final String BFX_SIGNATURE = "bfx-signature";
    public static final String BFX_NONCE = "bfx-nonce";

    @POST
    @Path(value="auth/r/positions")
    public List<Position> activePositions(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, EmptyRequest var4) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/wallets")
    public List<Wallet> getWallets(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, EmptyRequest var4) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/trades/hist")
    public List<Trade> getTrades(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @QueryParam(value="start") Long var4, @QueryParam(value="end") Long var5, @QueryParam(value="limit") Long var6, @QueryParam(value="sort") Long var7, EmptyRequest var8) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/trades/{symbol}/hist")
    public List<Trade> getTrades(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @PathParam(value="symbol") String var4, @QueryParam(value="start") Long var5, @QueryParam(value="end") Long var6, @QueryParam(value="limit") Long var7, @QueryParam(value="sort") Long var8, EmptyRequest var9) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/orders/{symbol}")
    public List<ActiveOrder> getActiveOrders(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @PathParam(value="symbol") String var4, EmptyRequest var5) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/ledgers/hist")
    public List<LedgerEntry> getLedgerEntries(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @QueryParam(value="start") Long var4, @QueryParam(value="end") Long var5, @QueryParam(value="limit") Long var6, LedgerRequest var7) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/ledgers/{currency}/hist")
    public List<LedgerEntry> getLedgerEntries(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @PathParam(value="currency") String var4, @QueryParam(value="start") Long var5, @QueryParam(value="end") Long var6, @QueryParam(value="limit") Long var7, LedgerRequest var8) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="auth/r/order/{symbol}:{orderId}/trades")
    public List<OrderTrade> getOrderTrades(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @PathParam(value="symbol") String var4, @PathParam(value="orderId") Long var5, EmptyRequest var6) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="/auth/r/movements/{symbol}/hist")
    public List<Movement> getMovementsHistory(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @PathParam(value="symbol") String var4, @QueryParam(value="start") Long var5, @QueryParam(value="end") Long var6, @QueryParam(value="limit") Integer var7, EmptyRequest var8) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="/auth/r/movements/hist")
    public List<Movement> getMovementsHistory(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, @QueryParam(value="start") Long var4, @QueryParam(value="end") Long var5, @QueryParam(value="limit") Integer var6, EmptyRequest var7) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="/auth/w/transfer")
    public TransferBetweenWalletsResponse transferBetweenWallets(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, TransferBetweenWalletsRequest var4) throws IOException, BitfinexExceptionV2;

    @POST
    @Path(value="/auth/w/deriv/collateral/set")
    public List<List<Integer>> updateCollateralDerivativePosition(@HeaderParam(value="bfx-nonce") SynchronizedValueFactory<Long> var1, @HeaderParam(value="bfx-apikey") String var2, @HeaderParam(value="bfx-signature") ParamsDigest var3, UpdateCollateralDerivativePositionRequest var4) throws IOException, BitfinexExceptionV2;
}

