/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v2.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
@JsonDeserialize(builder=BitfinexCandleBuilder.class)
public class BitfinexCandle {
    private final long millisecondTimestamp;
    private final double open;
    private final double close;
    private final double high;
    private final double low;
    private final double volume;

    public ZonedDateTime getCandleDateTime() {
        Instant instant = Instant.ofEpochMilli(this.millisecondTimestamp);
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    BitfinexCandle(long millisecondTimestamp, double open, double close, double high, double low, double volume) {
        this.millisecondTimestamp = millisecondTimestamp;
        this.open = open;
        this.close = close;
        this.high = high;
        this.low = low;
        this.volume = volume;
    }

    public static BitfinexCandleBuilder builder() {
        return new BitfinexCandleBuilder();
    }

    public long getMillisecondTimestamp() {
        return this.millisecondTimestamp;
    }

    public double getOpen() {
        return this.open;
    }

    public double getClose() {
        return this.close;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getVolume() {
        return this.volume;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitfinexCandle)) {
            return false;
        }
        BitfinexCandle other = (BitfinexCandle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMillisecondTimestamp() != other.getMillisecondTimestamp()) {
            return false;
        }
        if (Double.compare(this.getOpen(), other.getOpen()) != 0) {
            return false;
        }
        if (Double.compare(this.getClose(), other.getClose()) != 0) {
            return false;
        }
        if (Double.compare(this.getHigh(), other.getHigh()) != 0) {
            return false;
        }
        if (Double.compare(this.getLow(), other.getLow()) != 0) {
            return false;
        }
        return Double.compare(this.getVolume(), other.getVolume()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitfinexCandle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $millisecondTimestamp = this.getMillisecondTimestamp();
        result = result * 59 + (int)($millisecondTimestamp >>> 32 ^ $millisecondTimestamp);
        long $open = Double.doubleToLongBits(this.getOpen());
        result = result * 59 + (int)($open >>> 32 ^ $open);
        long $close = Double.doubleToLongBits(this.getClose());
        result = result * 59 + (int)($close >>> 32 ^ $close);
        long $high = Double.doubleToLongBits(this.getHigh());
        result = result * 59 + (int)($high >>> 32 ^ $high);
        long $low = Double.doubleToLongBits(this.getLow());
        result = result * 59 + (int)($low >>> 32 ^ $low);
        long $volume = Double.doubleToLongBits(this.getVolume());
        result = result * 59 + (int)($volume >>> 32 ^ $volume);
        return result;
    }

    public String toString() {
        return "BitfinexCandle(millisecondTimestamp=" + this.getMillisecondTimestamp() + ", open=" + this.getOpen() + ", close=" + this.getClose() + ", high=" + this.getHigh() + ", low=" + this.getLow() + ", volume=" + this.getVolume() + ")";
    }

    @JsonFormat(shape=JsonFormat.Shape.ARRAY)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BitfinexCandleBuilder {
        private long millisecondTimestamp;
        private double open;
        private double close;
        private double high;
        private double low;
        private double volume;

        BitfinexCandleBuilder() {
        }

        public BitfinexCandleBuilder millisecondTimestamp(long millisecondTimestamp) {
            this.millisecondTimestamp = millisecondTimestamp;
            return this;
        }

        public BitfinexCandleBuilder open(double open) {
            this.open = open;
            return this;
        }

        public BitfinexCandleBuilder close(double close) {
            this.close = close;
            return this;
        }

        public BitfinexCandleBuilder high(double high) {
            this.high = high;
            return this;
        }

        public BitfinexCandleBuilder low(double low) {
            this.low = low;
            return this;
        }

        public BitfinexCandleBuilder volume(double volume) {
            this.volume = volume;
            return this;
        }

        public BitfinexCandle build() {
            return new BitfinexCandle(this.millisecondTimestamp, this.open, this.close, this.high, this.low, this.volume);
        }

        public String toString() {
            return "BitfinexCandle.BitfinexCandleBuilder(millisecondTimestamp=" + this.millisecondTimestamp + ", open=" + this.open + ", close=" + this.close + ", high=" + this.high + ", low=" + this.low + ", volume=" + this.volume + ")";
        }
    }
}

