/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import org.knowm.xchange.exceptions.NonceException;
import org.knowm.xchange.exceptions.RateLimitExceededException;

public class BitfinexErrorAdapter {
    private BitfinexErrorAdapter() {
    }

    public static ExchangeException adapt(BitfinexException e) {
        String message = e.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return new ExchangeException((Throwable)e);
        }
        if ((message = message.toLowerCase()).contains("unknown symbol") || message.contains("symbol: invalid")) {
            return new CurrencyPairNotValidException(message, (Throwable)e);
        }
        if (message.contains("not enough exchange balance")) {
            return new FundsExceededException(message, (Throwable)e);
        }
        if (message.contains("err_rate_limit") || message.contains("ratelimit")) {
            return new RateLimitExceededException((Throwable)e);
        }
        if (message.contains("nonce")) {
            return new NonceException((Throwable)e);
        }
        return new ExchangeException(message, (Throwable)e);
    }
}

