/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.bitfinex.BitfinexExchange;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexBaseService;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexAccountFeesResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexBalanceHistoryRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexBalanceHistoryResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexBalancesRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexBalancesResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexDepositAddressRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexDepositAddressResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexDepositWithdrawalHistoryRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexDepositWithdrawalHistoryResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexMarginInfosRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexMarginInfosResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexTradingFeeResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexTradingFeesRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexWithdrawalRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexWithdrawalResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNonceOnlyRequest;
import org.knowm.xchange.bitfinex.v2.dto.EmptyRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.LedgerEntry;
import org.knowm.xchange.bitfinex.v2.dto.account.LedgerRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.Movement;
import org.knowm.xchange.bitfinex.v2.dto.account.TransferBetweenWalletsRequest;
import org.knowm.xchange.bitfinex.v2.dto.account.TransferBetweenWalletsResponse;
import org.knowm.xchange.bitfinex.v2.dto.account.Wallet;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.ParamsDigest;

public class BitfinexAccountServiceRaw
extends BitfinexBaseService {
    public BitfinexAccountServiceRaw(BitfinexExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public BitfinexTradingFeeResponse[] getBitfinexDynamicTradingFees() throws IOException {
        try {
            return (BitfinexTradingFeeResponse[])this.decorateApiCall(() -> this.bitfinex.tradingFees(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexTradingFeesRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue())))).withRetry(this.retry("account-tradingFees")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        }
        catch (BitfinexException e) {
            throw new ExchangeException((Throwable)e);
        }
    }

    public BitfinexBalancesResponse[] getBitfinexAccountInfo() throws IOException {
        return (BitfinexBalancesResponse[])this.decorateApiCall(() -> this.bitfinex.balances(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexBalancesRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue())))).withRetry(this.retry("account-accountInfo")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public BitfinexMarginInfosResponse[] getBitfinexMarginInfos() throws IOException {
        return (BitfinexMarginInfosResponse[])this.decorateApiCall(() -> this.bitfinex.marginInfos(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexMarginInfosRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue())))).withRetry(this.retry("account-marginInfo")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public BitfinexDepositWithdrawalHistoryResponse[] getDepositWithdrawalHistory(String currency, String method, Date since, Date until, Integer limit) throws IOException {
        BitfinexDepositWithdrawalHistoryRequest request = new BitfinexDepositWithdrawalHistoryRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue()), currency, method, since, until, limit);
        return (BitfinexDepositWithdrawalHistoryResponse[])this.decorateApiCall(() -> this.bitfinex.depositWithdrawalHistory(this.apiKey, this.payloadCreator, this.signatureCreator, request)).withRetry(this.retry("account-withdrawalHistory")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public String withdraw(String withdrawType, String walletSelected, BigDecimal amount, String address) throws IOException {
        return this.withdraw(withdrawType, walletSelected, amount, address, null);
    }

    public String withdraw(String withdrawType, String walletSelected, BigDecimal amount, String address, String tagOrPaymentId) throws IOException {
        return this.withdraw(withdrawType, walletSelected, amount, address, tagOrPaymentId, null);
    }

    public String withdraw(String withdrawType, String walletSelected, BigDecimal amount, String address, String tagOrPaymentId, String currency) throws IOException {
        BitfinexWithdrawalRequest req = new BitfinexWithdrawalRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue()), withdrawType, walletSelected, amount, address, tagOrPaymentId);
        req.setCurrency(currency);
        BitfinexWithdrawalResponse[] withdrawResponse = (BitfinexWithdrawalResponse[])this.decorateApiCall(() -> this.bitfinex.withdraw(this.apiKey, this.payloadCreator, this.signatureCreator, req)).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        if ("error".equalsIgnoreCase(withdrawResponse[0].getStatus())) {
            throw new ExchangeException(withdrawResponse[0].getMessage());
        }
        return withdrawResponse[0].getWithdrawalId();
    }

    public BitfinexDepositAddressResponse requestDepositAddressRaw(String currency) throws IOException {
        String type = "unknown";
        if ("BTC".equalsIgnoreCase(currency)) {
            type = "bitcoin";
        } else if ("LTC".equalsIgnoreCase(currency)) {
            type = "litecoin";
        } else if ("ETH".equalsIgnoreCase(currency)) {
            type = "ethereum";
        } else if ("IOT".equalsIgnoreCase(currency)) {
            type = "iota";
        } else if ("BCH".equalsIgnoreCase(currency)) {
            type = "bab";
        } else if ("BTG".equalsIgnoreCase(currency)) {
            type = "bgold";
        } else if ("DASH".equalsIgnoreCase(currency)) {
            type = "dash";
        } else if ("EOS".equalsIgnoreCase(currency)) {
            type = "eos";
        } else if ("XMR".equalsIgnoreCase(currency)) {
            type = "monero";
        } else if ("NEO".equalsIgnoreCase(currency)) {
            type = "neo";
        } else if ("XRP".equalsIgnoreCase(currency)) {
            type = "ripple";
        } else if ("XLM".equalsIgnoreCase(currency)) {
            type = "xlm";
        } else if ("TRX".equalsIgnoreCase(currency)) {
            type = "trx";
        } else if ("ZEC".equalsIgnoreCase(currency)) {
            type = "zcash";
        }
        String finalType = type;
        return (BitfinexDepositAddressResponse)this.decorateApiCall(() -> this.bitfinex.requestDeposit(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexDepositAddressRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue()), finalType, "exchange", 0))).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public BitfinexAccountFeesResponse getAccountFees() throws IOException {
        return (BitfinexAccountFeesResponse)this.decorateApiCall(() -> this.bitfinex.accountFees(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNonceOnlyRequest("/v1/account_fees", String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue())))).withRetry(this.retry("account-accountFees")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public BitfinexBalanceHistoryResponse[] getBitfinexBalanceHistory(String currency, String wallet, Long since, Long until, int limit) throws IOException {
        return (BitfinexBalanceHistoryResponse[])this.decorateApiCall(() -> this.bitfinex.balanceHistory(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexBalanceHistoryRequest(String.valueOf(((BitfinexExchange)this.exchange).getNonceFactory().createValue()), currency, since, until, limit, wallet))).withRetry(this.retry("account-balanceHistory")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<LedgerEntry> getLedgerEntries(String currency, Long startTimeMillis, Long endTimeMillis, Long limit, Long category) throws IOException {
        if (StringUtils.isBlank((CharSequence)currency)) {
            return (List)this.decorateApiCall(() -> this.bitfinexV2.getLedgerEntries(((BitfinexExchange)this.exchange).getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, startTimeMillis, endTimeMillis, limit, new LedgerRequest(category))).withRetry(this.retry("account-ledgerEntries")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        }
        return (List)this.decorateApiCall(() -> this.bitfinexV2.getLedgerEntries(((BitfinexExchange)this.exchange).getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, currency, startTimeMillis, endTimeMillis, limit, new LedgerRequest(category))).withRetry(this.retry("account-ledgerEntries")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<Movement> getMovementHistory(String currency, Long startTimeMillis, Long endTimeMillis, Integer limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)currency)) {
            return (List)this.decorateApiCall(() -> this.bitfinexV2.getMovementsHistory(((BitfinexExchange)this.exchange).getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, startTimeMillis, endTimeMillis, limit, EmptyRequest.INSTANCE)).withRetry(this.retry("account-movementHistory")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
        }
        return (List)this.decorateApiCall(() -> this.bitfinexV2.getMovementsHistory(((BitfinexExchange)this.exchange).getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, currency, startTimeMillis, endTimeMillis, limit, EmptyRequest.INSTANCE)).withRetry(this.retry("account-movementHistory")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public List<Wallet> getWallets() throws IOException {
        return (List)this.decorateApiCall(() -> this.bitfinexV2.getWallets(((BitfinexExchange)this.exchange).getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, EmptyRequest.INSTANCE)).withRetry(this.retry("account-wallets")).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }

    public TransferBetweenWalletsResponse transferBetweenWallets(TransferBetweenWalletsRequest req) throws IOException {
        return (TransferBetweenWalletsResponse)this.decorateApiCall(() -> this.bitfinexV2.transferBetweenWallets(((BitfinexExchange)this.exchange).getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, req)).withRateLimiter(this.rateLimiter("bitfinexRateLimiter")).call();
    }
}

