/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.knowm.xchange.bitfinex.v1.BitfinexOrderType;
import org.knowm.xchange.bitfinex.v1.BitfinexUtils;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexAccountFeesResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexBalancesResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexDepositWithdrawalHistoryResponse;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexTradingFeeResponse;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLendLevel;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLevel;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexSymbolDetail;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTrade;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexAccountInfosResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderFlags;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderStatusResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexTradeResponse;
import org.knowm.xchange.bitfinex.v2.dto.account.Movement;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexPublicTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTickerFundingCurrency;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTickerTraidingPair;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.FloatingRateLoanOrder;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitfinexAdapters {
    public static final Logger log = LoggerFactory.getLogger(BitfinexAdapters.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final AtomicBoolean warnedStopLimit = new AtomicBoolean();

    private BitfinexAdapters() {
    }

    public static Map<CurrencyPair, Fee> adaptDynamicTradingFees(BitfinexTradingFeeResponse[] responses, List<CurrencyPair> currencyPairs) {
        HashMap<CurrencyPair, Fee> result = new HashMap<CurrencyPair, Fee>();
        for (BitfinexTradingFeeResponse response : responses) {
            BitfinexTradingFeeResponse.BitfinexTradingFeeResponseRow[] responseRows;
            for (BitfinexTradingFeeResponse.BitfinexTradingFeeResponseRow responseRow : responseRows = response.getTradingFees()) {
                Currency currency = Currency.getInstance((String)responseRow.getCurrency());
                BigDecimal percentToFraction = BigDecimal.ONE.divide(BigDecimal.ONE.scaleByPowerOfTen(2));
                Fee fee = new Fee(responseRow.getMakerFee().multiply(percentToFraction), responseRow.getTakerFee().multiply(percentToFraction));
                for (CurrencyPair pair : currencyPairs) {
                    if (!pair.base.equals((Object)currency) || result.put(pair, fee) == null) continue;
                    throw new IllegalStateException("Fee for currency pair " + pair + " is overspecified");
                }
            }
        }
        return result;
    }

    public static String adaptBitfinexCurrency(String bitfinexSymbol) {
        return bitfinexSymbol.toUpperCase();
    }

    public static String adaptOrderType(Order.OrderType type) {
        switch (type) {
            case BID: 
            case EXIT_BID: {
                return "buy";
            }
            case ASK: 
            case EXIT_ASK: {
                return "sell";
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected type of order: %s", type));
    }

    public static BitfinexOrderType adaptOrderFlagsToType(Set<Order.IOrderFlags> flags) {
        if (flags.contains((Object)BitfinexOrderFlags.MARGIN)) {
            if (flags.contains((Object)BitfinexOrderFlags.FILL_OR_KILL)) {
                return BitfinexOrderType.MARGIN_FILL_OR_KILL;
            }
            if (flags.contains((Object)BitfinexOrderFlags.TRAILING_STOP)) {
                return BitfinexOrderType.MARGIN_TRAILING_STOP;
            }
            if (flags.contains((Object)BitfinexOrderFlags.STOP)) {
                return BitfinexOrderType.MARGIN_STOP;
            }
            return BitfinexOrderType.MARGIN_LIMIT;
        }
        if (flags.contains((Object)BitfinexOrderFlags.FILL_OR_KILL)) {
            return BitfinexOrderType.FILL_OR_KILL;
        }
        if (flags.contains((Object)BitfinexOrderFlags.TRAILING_STOP)) {
            return BitfinexOrderType.TRAILING_STOP;
        }
        if (flags.contains((Object)BitfinexOrderFlags.STOP)) {
            return BitfinexOrderType.STOP;
        }
        return BitfinexOrderType.LIMIT;
    }

    public static CurrencyPair adaptCurrencyPair(String bitfinexSymbol) {
        String transactionCurrency;
        String tradableIdentifier;
        int startIndex;
        int n = startIndex = bitfinexSymbol.startsWith("t") && Character.isUpperCase(bitfinexSymbol.charAt(1)) ? 1 : 0;
        if (bitfinexSymbol.contains(":")) {
            int idx = bitfinexSymbol.indexOf(":");
            tradableIdentifier = bitfinexSymbol.substring(startIndex, idx);
            transactionCurrency = bitfinexSymbol.substring(idx + 1);
        } else {
            tradableIdentifier = bitfinexSymbol.substring(startIndex, startIndex + 3);
            transactionCurrency = bitfinexSymbol.substring(startIndex + 3);
        }
        return new CurrencyPair(BitfinexAdapters.adaptBitfinexCurrency(tradableIdentifier), BitfinexAdapters.adaptBitfinexCurrency(transactionCurrency));
    }

    public static Order.OrderStatus adaptOrderStatus(BitfinexOrderStatusResponse order) {
        if (order.isCancelled()) {
            return Order.OrderStatus.CANCELED;
        }
        if (order.getExecutedAmount().compareTo(BigDecimal.ZERO) == 0) {
            return Order.OrderStatus.NEW;
        }
        if (order.getExecutedAmount().compareTo(order.getOriginalAmount()) < 0) {
            return Order.OrderStatus.PARTIALLY_FILLED;
        }
        if (order.getExecutedAmount().compareTo(order.getOriginalAmount()) == 0) {
            return Order.OrderStatus.FILLED;
        }
        return null;
    }

    public static String adaptCurrencyPair(CurrencyPair pair) {
        return BitfinexUtils.toPairString(pair);
    }

    public static OrderBook adaptOrderBook(BitfinexDepth btceDepth, CurrencyPair currencyPair) {
        OrdersContainer asksOrdersContainer = BitfinexAdapters.adaptOrders(btceDepth.getAsks(), currencyPair, Order.OrderType.ASK);
        OrdersContainer bidsOrdersContainer = BitfinexAdapters.adaptOrders(btceDepth.getBids(), currencyPair, Order.OrderType.BID);
        return new OrderBook(new Date(Math.max(asksOrdersContainer.getTimestamp(), bidsOrdersContainer.getTimestamp())), asksOrdersContainer.getLimitOrders(), bidsOrdersContainer.getLimitOrders());
    }

    public static OrdersContainer adaptOrders(BitfinexLevel[] bitfinexLevels, CurrencyPair currencyPair, Order.OrderType orderType) {
        BigDecimal maxTimestamp = new BigDecimal(Long.MIN_VALUE);
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(bitfinexLevels.length);
        for (BitfinexLevel bitfinexLevel : bitfinexLevels) {
            if (bitfinexLevel.getTimestamp().compareTo(maxTimestamp) > 0) {
                maxTimestamp = bitfinexLevel.getTimestamp();
            }
            Date timestamp = BitfinexAdapters.convertBigDecimalTimestampToDate(bitfinexLevel.getTimestamp());
            limitOrders.add(BitfinexAdapters.adaptOrder(bitfinexLevel.getAmount(), bitfinexLevel.getPrice(), currencyPair, orderType, timestamp));
        }
        long maxTimestampInMillis = maxTimestamp.multiply(new BigDecimal(1000L)).longValue();
        return new OrdersContainer(maxTimestampInMillis, limitOrders);
    }

    public static LimitOrder adaptOrder(BigDecimal originalAmount, BigDecimal price, CurrencyPair currencyPair, Order.OrderType orderType, Date timestamp) {
        return new LimitOrder(orderType, originalAmount, (Instrument)currencyPair, "", timestamp, price);
    }

    public static List<FixedRateLoanOrder> adaptFixedRateLoanOrders(BitfinexLendLevel[] orders, String currency, String orderType, String id) {
        ArrayList<FixedRateLoanOrder> loanOrders = new ArrayList<FixedRateLoanOrder>(orders.length);
        for (BitfinexLendLevel order : orders) {
            if ("yes".equalsIgnoreCase(order.getFrr())) continue;
            if (orderType.equalsIgnoreCase("loan")) {
                loanOrders.add(0, BitfinexAdapters.adaptFixedRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
                continue;
            }
            loanOrders.add(BitfinexAdapters.adaptFixedRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
        }
        return loanOrders;
    }

    public static FixedRateLoanOrder adaptFixedRateLoanOrder(String currency, BigDecimal amount, int dayPeriod, String direction, String id, BigDecimal rate) {
        Order.OrderType orderType = direction.equalsIgnoreCase("loan") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new FixedRateLoanOrder(orderType, currency, amount, dayPeriod, id, null, rate);
    }

    public static List<FloatingRateLoanOrder> adaptFloatingRateLoanOrders(BitfinexLendLevel[] orders, String currency, String orderType, String id) {
        ArrayList<FloatingRateLoanOrder> loanOrders = new ArrayList<FloatingRateLoanOrder>(orders.length);
        for (BitfinexLendLevel order : orders) {
            if ("no".equals(order.getFrr())) continue;
            if (orderType.equalsIgnoreCase("loan")) {
                loanOrders.add(0, BitfinexAdapters.adaptFloatingRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
                continue;
            }
            loanOrders.add(BitfinexAdapters.adaptFloatingRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
        }
        return loanOrders;
    }

    public static FloatingRateLoanOrder adaptFloatingRateLoanOrder(String currency, BigDecimal amount, int dayPeriod, String direction, String id, BigDecimal rate) {
        Order.OrderType orderType = direction.equalsIgnoreCase("loan") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new FloatingRateLoanOrder(orderType, currency, amount, dayPeriod, id, null, rate);
    }

    public static Trade adaptTrade(BitfinexTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = trade.getType().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getAmount();
        BigDecimal price = trade.getPrice();
        Date date = DateUtils.fromMillisUtc((long)(trade.getTimestamp() * 1000L));
        String tradeId = String.valueOf(trade.getTradeId());
        return new Trade.Builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(date).id(tradeId).build();
    }

    public static Trades adaptTrades(BitfinexTrade[] trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.length);
        long lastTradeId = 0L;
        for (BitfinexTrade trade : trades) {
            long tradeId = trade.getTradeId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(BitfinexAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Ticker adaptTicker(BitfinexTicker bitfinexTicker, CurrencyPair currencyPair) {
        BigDecimal last = bitfinexTicker.getLast_price();
        BigDecimal bid = bitfinexTicker.getBid();
        BigDecimal bidSize = bitfinexTicker.getBidSize();
        BigDecimal ask = bitfinexTicker.getAsk();
        BigDecimal askSize = bitfinexTicker.getAskSize();
        BigDecimal high = bitfinexTicker.getHigh();
        BigDecimal low = bitfinexTicker.getLow();
        BigDecimal volume = bitfinexTicker.getVolume();
        Date timestamp = DateUtils.fromMillisUtc((long)((long)(bitfinexTicker.getTimestamp() * 1000.0)));
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).bidSize(bidSize).ask(ask).askSize(askSize).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }

    public static List<Wallet> adaptWallets(BitfinexBalancesResponse[] response) {
        HashMap walletsBalancesMap = new HashMap();
        for (BitfinexBalancesResponse balance : response) {
            String currencyName;
            Map balancesByCurrency;
            BigDecimal[] balanceDetail;
            String walletId = balance.getType();
            if (!walletsBalancesMap.containsKey(walletId)) {
                walletsBalancesMap.put(walletId, new HashMap());
            }
            if ((balanceDetail = (BigDecimal[])(balancesByCurrency = (Map)walletsBalancesMap.get(walletId)).get(currencyName = BitfinexAdapters.adaptBitfinexCurrency(balance.getCurrency()))) == null) {
                balanceDetail = new BigDecimal[]{balance.getAmount(), balance.getAvailable()};
            } else {
                balanceDetail[0] = balanceDetail[0].add(balance.getAmount());
                balanceDetail[1] = balanceDetail[1].add(balance.getAvailable());
            }
            balancesByCurrency.put(currencyName, balanceDetail);
        }
        ArrayList<Wallet> wallets = new ArrayList<Wallet>();
        for (Map.Entry walletData : walletsBalancesMap.entrySet()) {
            Map balancesByCurrency = (Map)walletData.getValue();
            ArrayList<Balance> balances = new ArrayList<Balance>(balancesByCurrency.size());
            for (Map.Entry entry : balancesByCurrency.entrySet()) {
                String currencyName = (String)entry.getKey();
                BigDecimal[] balanceDetail = (BigDecimal[])entry.getValue();
                BigDecimal balanceTotal = balanceDetail[0];
                BigDecimal balanceAvailable = balanceDetail[1];
                balances.add(new Balance(Currency.getInstance((String)currencyName), balanceTotal, balanceAvailable));
            }
            wallets.add(Wallet.Builder.from(balances).id((String)walletData.getKey()).build());
        }
        return wallets;
    }

    public static OpenOrders adaptOrders(BitfinexOrderStatusResponse[] activeOrders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        ArrayList<Object> hiddenOrders = new ArrayList<Object>();
        for (BitfinexOrderStatusResponse order : activeOrders) {
            Order.OrderType orderType = order.getSide().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            Order.OrderStatus status = BitfinexAdapters.adaptOrderStatus(order);
            CurrencyPair currencyPair = BitfinexAdapters.adaptCurrencyPair(order.getSymbol());
            Date timestamp = BitfinexAdapters.convertBigDecimalTimestampToDate(order.getTimestamp());
            Supplier<MarketOrder> marketOrderCreator = () -> new MarketOrder(orderType, order.getOriginalAmount(), (Instrument)currencyPair, String.valueOf(order.getId()), timestamp, order.getAvgExecutionPrice(), order.getExecutedAmount(), null, status);
            Supplier<LimitOrder> limitOrderCreator = () -> new LimitOrder(orderType, order.getOriginalAmount(), (Instrument)currencyPair, String.valueOf(order.getId()), timestamp, order.getPrice(), order.getAvgExecutionPrice(), order.getExecutedAmount(), null, status);
            Supplier<StopOrder> stopOrderCreator = () -> new StopOrder(orderType, order.getOriginalAmount(), (Instrument)currencyPair, String.valueOf(order.getId()), timestamp, order.getPrice(), null, order.getAvgExecutionPrice(), order.getExecutedAmount(), status);
            LimitOrder limitOrder = null;
            StopOrder stopOrder = null;
            MarketOrder marketOrder = null;
            Optional<BitfinexOrderType> bitfinexOrderType = Arrays.stream(BitfinexOrderType.values()).filter(v -> v.getValue().equals(order.getType())).findFirst();
            if (bitfinexOrderType.isPresent()) {
                switch (bitfinexOrderType.get()) {
                    case FILL_OR_KILL: {
                        limitOrder = limitOrderCreator.get();
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.FILL_OR_KILL);
                        break;
                    }
                    case MARGIN_FILL_OR_KILL: {
                        limitOrder = limitOrderCreator.get();
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.FILL_OR_KILL);
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.MARGIN);
                        break;
                    }
                    case MARGIN_LIMIT: {
                        limitOrder = limitOrderCreator.get();
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.MARGIN);
                        break;
                    }
                    case MARGIN_STOP: {
                        stopOrder = stopOrderCreator.get();
                        stopOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.STOP);
                        stopOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.MARGIN);
                        break;
                    }
                    case MARGIN_STOP_LIMIT: {
                        BitfinexAdapters.stopLimitWarning();
                        stopOrder = stopOrderCreator.get();
                        stopOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.STOP);
                        stopOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.MARGIN);
                        break;
                    }
                    case MARGIN_TRAILING_STOP: {
                        limitOrder = limitOrderCreator.get();
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.TRAILING_STOP);
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.MARGIN);
                        break;
                    }
                    case STOP: {
                        stopOrder = stopOrderCreator.get();
                        stopOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.STOP);
                        break;
                    }
                    case STOP_LIMIT: {
                        BitfinexAdapters.stopLimitWarning();
                        stopOrder = stopOrderCreator.get();
                        stopOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.STOP);
                        break;
                    }
                    case TRAILING_STOP: {
                        limitOrder = limitOrderCreator.get();
                        limitOrder.addOrderFlag((Order.IOrderFlags)BitfinexOrderFlags.TRAILING_STOP);
                        break;
                    }
                    case LIMIT: {
                        limitOrder = limitOrderCreator.get();
                        break;
                    }
                    case MARGIN_MARKET: 
                    case MARKET: {
                        marketOrder = marketOrderCreator.get();
                        break;
                    }
                    default: {
                        log.warn("Unhandled Bitfinex order type [{}]. Defaulting to limit order", (Object)order.getType());
                        limitOrder = limitOrderCreator.get();
                        break;
                    }
                }
            } else {
                log.warn("Unknown Bitfinex order type [{}]. Defaulting to limit order", (Object)order.getType());
                limitOrder = limitOrderCreator.get();
            }
            if (limitOrder != null) {
                limitOrders.add(limitOrder);
                continue;
            }
            if (stopOrder != null) {
                hiddenOrders.add(stopOrder);
                continue;
            }
            if (marketOrder == null) continue;
            hiddenOrders.add(marketOrder);
        }
        return new OpenOrders(limitOrders, hiddenOrders);
    }

    private static void stopLimitWarning() {
        if (warnedStopLimit.compareAndSet(false, true)) {
            log.warn("Found a stop-limit order. Bitfinex v1 API does not return limit prices for stop-limit orders so these are returned as stop-at-market orders. This warning will only appear once.");
        }
    }

    public static UserTrades adaptTradeHistory(BitfinexTradeResponse[] trades, String symbol) {
        ArrayList<UserTrade> pastTrades = new ArrayList<UserTrade>(trades.length);
        CurrencyPair currencyPair = BitfinexAdapters.adaptCurrencyPair(symbol);
        for (BitfinexTradeResponse trade : trades) {
            Order.OrderType orderType = trade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            Date timestamp = BitfinexAdapters.convertBigDecimalTimestampToDate(trade.getTimestamp());
            BigDecimal fee = trade.getFeeAmount() == null ? null : trade.getFeeAmount().negate();
            pastTrades.add(new UserTrade.Builder().type(orderType).originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(timestamp).id(trade.getTradeId()).orderId(trade.getOrderId()).feeAmount(fee).feeCurrency(Currency.getInstance((String)trade.getFeeCurrency())).build());
        }
        return new UserTrades(pastTrades, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrades adaptTradeHistoryV2(List<org.knowm.xchange.bitfinex.v2.dto.trade.Trade> trades) {
        ArrayList<UserTrade> pastTrades = new ArrayList<UserTrade>(trades.size());
        for (org.knowm.xchange.bitfinex.v2.dto.trade.Trade trade : trades) {
            Order.OrderType orderType = trade.getExecAmount().signum() >= 0 ? Order.OrderType.BID : Order.OrderType.ASK;
            BigDecimal amount = trade.getExecAmount().signum() == -1 ? trade.getExecAmount().negate() : trade.getExecAmount();
            BigDecimal fee = trade.getFee() != null ? trade.getFee().negate() : null;
            pastTrades.add(new UserTrade.Builder().type(orderType).originalAmount(amount).currencyPair(BitfinexAdapters.adaptCurrencyPair(trade.getSymbol())).price(trade.getExecPrice()).timestamp(trade.getTimestamp()).id(trade.getId()).orderId(trade.getOrderId()).feeAmount(fee).feeCurrency(Currency.getInstance((String)trade.getFeeCurrency())).build());
        }
        return new UserTrades(pastTrades, Trades.TradeSortType.SortByTimestamp);
    }

    private static Date convertBigDecimalTimestampToDate(BigDecimal timestamp) {
        BigDecimal timestampInMillis = timestamp.multiply(new BigDecimal("1000"));
        return new Date(timestampInMillis.longValue());
    }

    public static ExchangeMetaData adaptMetaData(List<CurrencyPair> currencyPairs, ExchangeMetaData metaData) {
        Map pairsMap = metaData.getCurrencyPairs();
        Map currenciesMap = metaData.getCurrencies();
        pairsMap.keySet().retainAll(currencyPairs);
        Set currencies = currencyPairs.stream().flatMap(pair -> Stream.of(pair.base, pair.counter)).collect(Collectors.toSet());
        currenciesMap.keySet().retainAll(currencies);
        for (CurrencyPair c : currencyPairs) {
            if (!pairsMap.containsKey(c)) {
                pairsMap.put(c, null);
            }
            if (!currenciesMap.containsKey(c.base)) {
                currenciesMap.put(c.base, new CurrencyMetaData(Integer.valueOf(2), null));
            }
            if (currenciesMap.containsKey(c.counter)) continue;
            currenciesMap.put(c.counter, new CurrencyMetaData(Integer.valueOf(2), null));
        }
        return metaData;
    }

    public static ExchangeMetaData adaptMetaData(ExchangeMetaData exchangeMetaData, List<BitfinexSymbolDetail> symbolDetails, Map<CurrencyPair, BigDecimal> lastPrices) {
        Map currencyPairs = exchangeMetaData.getCurrencyPairs();
        symbolDetails.parallelStream().forEach(bitfinexSymbolDetail -> {
            CurrencyPair currencyPair = BitfinexAdapters.adaptCurrencyPair(bitfinexSymbolDetail.getPair());
            BigDecimal last = (BigDecimal)lastPrices.get(currencyPair);
            if (last != null) {
                int pricePercision = bitfinexSymbolDetail.getPrice_precision();
                int priceScale = last.scale() + (pricePercision - last.precision());
                CurrencyPairMetaData newMetaData = new CurrencyPairMetaData(currencyPairs.get(currencyPair) == null ? null : ((CurrencyPairMetaData)currencyPairs.get(currencyPair)).getTradingFee(), bitfinexSymbolDetail.getMinimum_order_size(), bitfinexSymbolDetail.getMaximum_order_size(), Integer.valueOf(priceScale), null);
                currencyPairs.put(currencyPair, newMetaData);
            }
        });
        return exchangeMetaData;
    }

    public static ExchangeMetaData adaptMetaData(BitfinexAccountFeesResponse accountFeesResponse, ExchangeMetaData metaData) {
        Map currencies = metaData.getCurrencies();
        Map<Currency, BigDecimal> withdrawFees = accountFeesResponse.getWithdraw();
        withdrawFees.forEach((currency, withdrawalFee) -> {
            CurrencyMetaData newMetaData = new CurrencyMetaData(Integer.valueOf(currencies.get(currency) == null ? withdrawalFee.scale() : Math.max(withdrawalFee.scale(), ((CurrencyMetaData)currencies.get(currency)).getScale())), withdrawalFee);
            currencies.put(currency, newMetaData);
        });
        return metaData;
    }

    public static ExchangeMetaData adaptMetaData(BitfinexAccountInfosResponse[] bitfinexAccountInfos, ExchangeMetaData exchangeMetaData) {
        Map currencyPairs = exchangeMetaData.getCurrencyPairs();
        CurrencyPairMetaData metaData = new CurrencyPairMetaData(bitfinexAccountInfos[0].getTakerFees().movePointLeft(2), null, null, null, null);
        currencyPairs.keySet().parallelStream().forEach(currencyPair -> currencyPairs.merge(currencyPair, metaData, (oldMetaData, newMetaData) -> new CurrencyPairMetaData(newMetaData.getTradingFee(), oldMetaData.getMinimumAmount(), oldMetaData.getMaximumAmount(), oldMetaData.getPriceScale(), oldMetaData.getFeeTiers())));
        return exchangeMetaData;
    }

    public static List<FundingRecord> adaptFundingHistory(List<Movement> movementHistorys) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (Movement movement : movementHistorys) {
            Currency currency = Currency.getInstance((String)movement.getCurency());
            FundingRecord.Type type = movement.getAmount().compareTo(BigDecimal.ZERO) < 0 ? FundingRecord.Type.WITHDRAWAL : FundingRecord.Type.DEPOSIT;
            FundingRecord.Status status = FundingRecord.Status.resolveStatus((String)movement.getStatus());
            if (status == null && movement.getStatus().equalsIgnoreCase("CANCELED")) {
                status = FundingRecord.Status.CANCELLED;
            }
            BigDecimal amount = movement.getAmount().abs();
            BigDecimal fee = movement.getFees().abs();
            if (fee != null && type.isOutflowing()) {
                amount = amount.add(fee);
            }
            FundingRecord fundingRecordEntry = new FundingRecord(movement.getDestinationAddress(), null, movement.getMtsUpdated(), currency, amount, movement.getId(), movement.getTransactionId(), type, status, null, fee, null);
            fundingRecords.add(fundingRecordEntry);
        }
        return fundingRecords;
    }

    public static List<FundingRecord> adaptFundingHistory(BitfinexDepositWithdrawalHistoryResponse[] bitfinexDepositWithdrawalHistoryResponses) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (BitfinexDepositWithdrawalHistoryResponse responseEntry : bitfinexDepositWithdrawalHistoryResponses) {
            String address = responseEntry.getAddress();
            String description = responseEntry.getDescription();
            Currency currency = Currency.getInstance((String)responseEntry.getCurrency());
            FundingRecord.Status status = FundingRecord.Status.resolveStatus((String)responseEntry.getStatus());
            if (status == null && responseEntry.getStatus().equalsIgnoreCase("CANCELED")) {
                status = FundingRecord.Status.CANCELLED;
            }
            String txnId = null;
            if (status == null || !status.equals((Object)FundingRecord.Status.CANCELLED)) {
                String cleanedDescription = description.replace(",", "").replace("txid:", "").trim().toLowerCase();
                if (address != null) {
                    cleanedDescription = cleanedDescription.replace(address.toLowerCase(), "").trim();
                }
                if (cleanedDescription.matches("^(0x)?[0-9a-f]+$")) {
                    txnId = cleanedDescription;
                }
            }
            FundingRecord fundingRecordEntry = new FundingRecord(address, responseEntry.getTimestamp(), currency, responseEntry.getAmount(), String.valueOf(responseEntry.getId()), txnId, responseEntry.getType(), status, null, null, description);
            fundingRecords.add(fundingRecordEntry);
        }
        return fundingRecords;
    }

    public static String adaptCurrencyPairsToTickersParam(Collection<CurrencyPair> currencyPairs) {
        return currencyPairs == null || currencyPairs.isEmpty() ? "ALL" : currencyPairs.stream().map(BitfinexAdapters::adaptCurrencyPair).collect(Collectors.joining(","));
    }

    public static Ticker adaptTicker(org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker bitfinexTicker) {
        BigDecimal last = bitfinexTicker.getLastPrice();
        BigDecimal bid = bitfinexTicker.getBid();
        BigDecimal bidSize = bitfinexTicker.getBidSize();
        BigDecimal ask = bitfinexTicker.getAsk();
        BigDecimal askSize = bitfinexTicker.getAskSize();
        BigDecimal high = bitfinexTicker.getHigh();
        BigDecimal low = bitfinexTicker.getLow();
        BigDecimal volume = bitfinexTicker.getVolume();
        BigDecimal percentageChange = bitfinexTicker.getDailyChangePerc().multiply(new BigDecimal("100"), new MathContext(8));
        CurrencyPair currencyPair = CurrencyPairDeserializer.getCurrencyPairFromString((String)bitfinexTicker.getSymbol().substring(1));
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).bidSize(bidSize).askSize(askSize).percentageChange(percentageChange).build();
    }

    public static Trade adaptPublicTrade(BitfinexPublicTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = trade.getType();
        BigDecimal amount = trade.getAmount();
        BigDecimal price = trade.getPrice();
        Date date = DateUtils.fromMillisUtc((long)trade.getTimestamp());
        String tradeId = String.valueOf(trade.getTradeId());
        return new Trade.Builder().type(orderType).originalAmount(amount == null ? null : amount.abs()).currencyPair(currencyPair).price(price).timestamp(date).id(tradeId).build();
    }

    public static Trades adaptPublicTrades(BitfinexPublicTrade[] trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.length);
        long lastTradeId = 0L;
        for (BitfinexPublicTrade trade : trades) {
            long tradeId = trade.getTradeId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(BitfinexAdapters.adaptPublicTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker[] adoptBitfinexTickers(List<ArrayNode> tickers) throws IOException {
        return (org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker[])tickers.stream().map(array -> {
            try {
                String symbol = array.get(0).asText();
                switch (symbol.charAt(0)) {
                    case 't': {
                        return (org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker)mapper.treeToValue((TreeNode)array, BitfinexTickerTraidingPair.class);
                    }
                    case 'f': {
                        return (org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker)mapper.treeToValue((TreeNode)array, BitfinexTickerFundingCurrency.class);
                    }
                }
                throw new RuntimeException("Invalid symbol <" + symbol + ">, it must start with 't' or 'f'.");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Could not convert ticker.", e);
            }
        }).toArray(org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker[]::new);
    }

    public static class OrdersContainer {
        private final long timestamp;
        private final List<LimitOrder> limitOrders;

        public OrdersContainer(long timestamp, List<LimitOrder> limitOrders) {
            this.timestamp = timestamp;
            this.limitOrders = limitOrders;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<LimitOrder> getLimitOrders() {
            return this.limitOrders;
        }
    }
}

