/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v2;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bitfinex.v2.dto.BitfinexExceptionV2;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexCandle;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexFundingOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexFundingRawOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexPublicFundingTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexPublicTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexStats;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTradingOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTradingRawOrder;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BookPrecision;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.Status;

@Path(value="v2")
@Produces(value={"application/json"})
public interface Bitfinex {
    @GET
    @Path(value="tickers")
    public List<ArrayNode> getTickers(@QueryParam(value="symbols") String var1) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="status/{type}")
    public List<Status> getStatus(@PathParam(value="type") String var1, @QueryParam(value="keys") String var2) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="/trades/{symbol}/hist")
    public BitfinexPublicFundingTrade[] getPublicFundingTrades(@PathParam(value="symbol") String var1, @QueryParam(value="limit") int var2, @QueryParam(value="start") long var3, @QueryParam(value="end") long var5, @QueryParam(value="sort") int var7) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="/trades/{symbol}/hist")
    public BitfinexPublicTrade[] getPublicTrades(@PathParam(value="symbol") String var1, @QueryParam(value="limit") int var2, @QueryParam(value="start") long var3, @QueryParam(value="end") long var5, @QueryParam(value="sort") int var7) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="candles/trade:{candlePeriod}:{symbol}:{fundingPeriod}/hist")
    public List<BitfinexCandle> getHistoricFundingCandles(@PathParam(value="candlePeriod") String var1, @PathParam(value="symbol") String var2, @PathParam(value="fundingPeriod") String var3, @QueryParam(value="limit") int var4) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="/candles/trade:{candlePeriod}:{symbol}/hist")
    public List<BitfinexCandle> getHistoricCandles(@PathParam(value="candlePeriod") String var1, @PathParam(value="symbol") String var2, @QueryParam(value="limit") Integer var3, @QueryParam(value="start") Long var4, @QueryParam(value="end") Long var5, @QueryParam(value="sort") Integer var6) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="stats1/{key}:{size}:{symbol}:{side}/hist")
    public List<BitfinexStats> getStats(@PathParam(value="key") String var1, @PathParam(value="size") String var2, @PathParam(value="symbol") String var3, @PathParam(value="side") String var4, @QueryParam(value="sort") Integer var5, @QueryParam(value="start") Long var6, @QueryParam(value="end") Long var7, @QueryParam(value="limit") Integer var8) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="book/{symbol}/{precision}")
    public List<BitfinexTradingOrder> tradingBook(@PathParam(value="symbol") String var1, @PathParam(value="precision") BookPrecision var2, @QueryParam(value="len") Integer var3) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="book/{symbol}/R0")
    public List<BitfinexTradingRawOrder> tradingBookRaw(@PathParam(value="symbol") String var1, @QueryParam(value="len") Integer var2) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="book/{symbol}/{precision}")
    public List<BitfinexFundingOrder> fundingBook(@PathParam(value="symbol") String var1, @PathParam(value="precision") BookPrecision var2, @QueryParam(value="len") Integer var3) throws IOException, BitfinexExceptionV2;

    @GET
    @Path(value="book/{symbol}/R0")
    public List<BitfinexFundingRawOrder> fundingBookRaw(@PathParam(value="symbol") String var1, @QueryParam(value="len") Integer var2) throws IOException, BitfinexExceptionV2;
}

