/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v2.dto.account;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class TransferBetweenWalletsRequest {
    @NonNull
    private final String from;
    @NonNull
    private final String to;
    @NonNull
    private final String currency;
    @JsonProperty(value="currency_to")
    private final String currencyTo;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @NonNull
    private final BigDecimal amount;
    @JsonProperty(value="email_dst")
    private final String emailDestination;

    public static TransferBetweenWalletsRequestBuilder builder() {
        return new TransferBetweenWalletsRequestBuilder();
    }

    @NonNull
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getCurrency() {
        return this.currency;
    }

    public String getCurrencyTo() {
        return this.currencyTo;
    }

    @NonNull
    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getEmailDestination() {
        return this.emailDestination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferBetweenWalletsRequest)) {
            return false;
        }
        TransferBetweenWalletsRequest other = (TransferBetweenWalletsRequest)o;
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$currencyTo = this.getCurrencyTo();
        String other$currencyTo = other.getCurrencyTo();
        if (this$currencyTo == null ? other$currencyTo != null : !this$currencyTo.equals(other$currencyTo)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$emailDestination = this.getEmailDestination();
        String other$emailDestination = other.getEmailDestination();
        return !(this$emailDestination == null ? other$emailDestination != null : !this$emailDestination.equals(other$emailDestination));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $currencyTo = this.getCurrencyTo();
        result = result * 59 + ($currencyTo == null ? 43 : $currencyTo.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $emailDestination = this.getEmailDestination();
        result = result * 59 + ($emailDestination == null ? 43 : $emailDestination.hashCode());
        return result;
    }

    public String toString() {
        return "TransferBetweenWalletsRequest(from=" + this.getFrom() + ", to=" + this.getTo() + ", currency=" + this.getCurrency() + ", currencyTo=" + this.getCurrencyTo() + ", amount=" + this.getAmount() + ", emailDestination=" + this.getEmailDestination() + ")";
    }

    private TransferBetweenWalletsRequest(@NonNull String from, @NonNull String to, @NonNull String currency, String currencyTo, @NonNull BigDecimal amount, String emailDestination) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
        this.currency = currency;
        this.currencyTo = currencyTo;
        this.amount = amount;
        this.emailDestination = emailDestination;
    }

    public static class TransferBetweenWalletsRequestBuilder {
        private String from;
        private String to;
        private String currency;
        private String currencyTo;
        private BigDecimal amount;
        private String emailDestination;

        TransferBetweenWalletsRequestBuilder() {
        }

        public TransferBetweenWalletsRequestBuilder from(@NonNull String from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from = from;
            return this;
        }

        public TransferBetweenWalletsRequestBuilder to(@NonNull String to) {
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            this.to = to;
            return this;
        }

        public TransferBetweenWalletsRequestBuilder currency(@NonNull String currency) {
            if (currency == null) {
                throw new NullPointerException("currency is marked non-null but is null");
            }
            this.currency = currency;
            return this;
        }

        @JsonProperty(value="currency_to")
        public TransferBetweenWalletsRequestBuilder currencyTo(String currencyTo) {
            this.currencyTo = currencyTo;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING)
        public TransferBetweenWalletsRequestBuilder amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="email_dst")
        public TransferBetweenWalletsRequestBuilder emailDestination(String emailDestination) {
            this.emailDestination = emailDestination;
            return this;
        }

        public TransferBetweenWalletsRequest build() {
            return new TransferBetweenWalletsRequest(this.from, this.to, this.currency, this.currencyTo, this.amount, this.emailDestination);
        }

        public String toString() {
            return "TransferBetweenWalletsRequest.TransferBetweenWalletsRequestBuilder(from=" + this.from + ", to=" + this.to + ", currency=" + this.currency + ", currencyTo=" + this.currencyTo + ", amount=" + this.amount + ", emailDestination=" + this.emailDestination + ")";
        }
    }
}

