/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v2.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import org.knowm.xchange.dto.Order;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class BitfinexPublicTrade {
    private long tradeId;
    private long timestamp;
    private BigDecimal amount;
    private BigDecimal price;

    public BitfinexPublicTrade() {
    }

    public BitfinexPublicTrade(long tradeId, long timestamp, BigDecimal amount, BigDecimal price) {
        this.tradeId = tradeId;
        this.timestamp = timestamp;
        this.amount = amount;
        this.price = price;
    }

    public long getTradeId() {
        return this.tradeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Order.OrderType getType() {
        return this.getAmount().signum() == -1 ? Order.OrderType.ASK : Order.OrderType.BID;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BitfinexPublicTrade [tradeId=");
        builder.append(this.tradeId);
        builder.append(", timestamp=");
        builder.append(this.timestamp);
        builder.append(", amount=");
        builder.append(this.amount);
        builder.append(", price=");
        builder.append(this.price);
        builder.append("]");
        return builder.toString();
    }
}

