/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bitflyer.dto.BitflyerException;
import org.knowm.xchange.bitflyer.dto.account.BitflyerAddress;
import org.knowm.xchange.bitflyer.dto.account.BitflyerBalance;
import org.knowm.xchange.bitflyer.dto.account.BitflyerBankAccount;
import org.knowm.xchange.bitflyer.dto.account.BitflyerCoinHistory;
import org.knowm.xchange.bitflyer.dto.account.BitflyerDepositOrWithdrawal;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarginAccount;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarginStatus;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarginTransaction;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarket;
import org.knowm.xchange.bitflyer.dto.account.BitflyerWithdrawRequest;
import org.knowm.xchange.bitflyer.dto.account.BitflyerWithdrawResponse;
import org.knowm.xchange.bitflyer.dto.marketdata.BitflyerOrderbook;
import org.knowm.xchange.bitflyer.dto.marketdata.BitflyerTicker;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerChildOrder;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerExecution;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerParentOrder;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerPosition;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerChildOrderAcceptance;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerParentOrderAcceptance;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerQueryChildOrderResult;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerTradingCommission;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="/v1")
@Produces(value={"application/json"})
public interface Bitflyer {
    public static final String ACCESS_KEY = "ACCESS-KEY";
    public static final String ACCESS_TIMESTAMP = "ACCESS-TIMESTAMP";
    public static final String ACCESS_SIGN = "ACCESS-SIGN";

    @GET
    @Path(value="getmarkets")
    public List<BitflyerMarket> getMarkets() throws IOException, BitflyerException;

    @GET
    @Path(value="getticker")
    public BitflyerTicker getTicker() throws IOException, BitflyerException;

    @GET
    @Path(value="getticker")
    public BitflyerTicker getTicker(@QueryParam(value="product_code") String var1) throws IOException, BitflyerException;

    @GET
    @Path(value="getboard")
    public BitflyerOrderbook getBoard() throws IOException, BitflyerException;

    @GET
    @Path(value="getboard")
    public BitflyerOrderbook getBoard(@QueryParam(value="product_code") String var1) throws IOException, BitflyerException;

    @GET
    @Path(value="getexecutions")
    public List<BitflyerExecution> getExecutions() throws IOException, BitflyerException;

    @GET
    @Path(value="getexecutions")
    public List<BitflyerExecution> getExecutions(@QueryParam(value="product_code") String var1) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getpermissions")
    public List<String> getPermissions(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="/me/getbalance")
    public List<BitflyerBalance> getBalances(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getcollateral")
    public BitflyerMarginStatus getMarginStatus(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getcollateralaccounts")
    public List<BitflyerMarginAccount> getMarginAccounts(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getaddresses")
    @Produces(value={"application/json"})
    public List<BitflyerAddress> getAddresses(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getcoinins")
    public List<BitflyerCoinHistory> getCoinIns(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getcoinouts")
    public List<BitflyerCoinHistory> getCoinOuts(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getbankaccounts")
    public List<BitflyerBankAccount> getBankAccounts(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getdeposits")
    public List<BitflyerDepositOrWithdrawal> getCashDeposits(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @POST
    @Path(value="me/withdraw")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public BitflyerWithdrawResponse withdrawFunds(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3, BitflyerWithdrawRequest var4) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getwithdrawals")
    public List<BitflyerDepositOrWithdrawal> getWithdrawals(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getpositions")
    public List<BitflyerPosition> getPositions(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3, @QueryParam(value="product_code") String var4) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getcollateralhistory")
    public List<BitflyerMarginTransaction> getMarginHistory(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3) throws IOException, BitflyerException;

    @GET
    @Path(value="me/gettradingcommission")
    public BitflyerTradingCommission getTradingCommission(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3, @QueryParam(value="product_code") String var4) throws IOException, BitflyerException;

    @GET
    @Path(value="me/getchildorders")
    public List<BitflyerQueryChildOrderResult> getChildOrders(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3, @QueryParam(value="product_code") String var4, @QueryParam(value="child_order_state") String var5) throws IOException, BitflyerException;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="me/sendparentorder")
    public BitflyerParentOrderAcceptance sendParentOrder(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3, BitflyerParentOrder var4) throws IOException, BitflyerException;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="me/sendchildorder")
    public BitflyerChildOrderAcceptance sendChildOrder(@HeaderParam(value="ACCESS-KEY") String var1, @HeaderParam(value="ACCESS-TIMESTAMP") SynchronizedValueFactory<Long> var2, @HeaderParam(value="ACCESS-SIGN") ParamsDigest var3, BitflyerChildOrder var4) throws IOException, BitflyerException;
}

