/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.bitflyer.BitflyerUtils;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerOrderMethod;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerParentOrderConditionType;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerParentOrderParameter;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerSide;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerTimeInForce;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitflyerParentOrder {
    private BitflyerOrderMethod orderMethod;
    private Long minuteToExpire;
    private BitflyerTimeInForce timeInForce;
    private List<BitflyerParentOrderParameter> parameters;

    public BitflyerParentOrder(BitflyerOrderMethod orderMethod, Long minuteToExpire, BitflyerTimeInForce timeInForce, List<BitflyerParentOrderParameter> parameters) {
        this.orderMethod = orderMethod;
        this.minuteToExpire = minuteToExpire;
        this.timeInForce = timeInForce;
        this.parameters = parameters;
    }

    public static BitflyerParentOrderBuilder getOrderBuilder() {
        return new BitflyerParentOrderBuilder();
    }

    @JsonProperty(value="order_method")
    public BitflyerOrderMethod getOrderMethod() {
        return this.orderMethod;
    }

    public void setOrderMethod(BitflyerOrderMethod orderMethod) {
        this.orderMethod = orderMethod;
    }

    @JsonProperty(value="minute_to_expire")
    public Long getMinuteToExpire() {
        return this.minuteToExpire;
    }

    public void setMinuteToExpire(Long minuteToExpire) {
        this.minuteToExpire = minuteToExpire;
    }

    @JsonProperty(value="time_in_force")
    public BitflyerTimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public void setTimeInForce(BitflyerTimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    @JsonProperty(value="parameters")
    public List<BitflyerParentOrderParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<BitflyerParentOrderParameter> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return "BitflyerParentOrder{orderMethod=" + (Object)((Object)this.orderMethod) + ", minuteToExpire=" + this.minuteToExpire + ", timeInForce=" + (Object)((Object)this.timeInForce) + ", parameters=" + this.parameters + '}';
    }

    public static class BitflyerParentOrderBuilder {
        private BitflyerOrderMethod orderMethod = BitflyerOrderMethod.SIMPLE;
        private Long minuteToExpire = null;
        private BitflyerTimeInForce timeInForce = BitflyerTimeInForce.GTC;
        private List<BitflyerParentOrderParameter> parameters = new ArrayList<BitflyerParentOrderParameter>();

        public BitflyerParentOrderBuilder withOrderMethod(BitflyerOrderMethod orderMethod) {
            this.orderMethod = orderMethod;
            return this;
        }

        public BitflyerParentOrderBuilder withMinuteToExpire(Long minuteToExpire) {
            this.minuteToExpire = minuteToExpire;
            return this;
        }

        public BitflyerParentOrderBuilder withTimeInForce(BitflyerTimeInForce timeInForce) {
            this.timeInForce = timeInForce;
            return this;
        }

        public BitflyerParentOrderBuilder withParameter(CurrencyPair productCode, BitflyerParentOrderConditionType conditionType, Order.OrderType side, BigDecimal price, BigDecimal triggerPrice, BigDecimal size, BigDecimal offset) {
            BitflyerParentOrderParameter parameter = new BitflyerParentOrderParameter(BitflyerUtils.bitflyerProductCode(productCode), conditionType, BitflyerSide.fromOrderType(side), price, triggerPrice, size, offset);
            this.parameters.add(parameter);
            return this;
        }

        public BitflyerParentOrder buildOrder() {
            return new BitflyerParentOrder(this.orderMethod, this.minuteToExpire, this.timeInForce, this.parameters);
        }
    }
}

