/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerParentOrderConditionType;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerSide;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitflyerParentOrderParameter {
    private static final int CURRENCY_SCALE = 2;
    private static final int SIZE_SCALE = 8;
    private String productCode;
    private BitflyerParentOrderConditionType conditionType;
    private BitflyerSide side;
    private BigDecimal price;
    private BigDecimal triggerPrice;
    private BigDecimal size;
    private BigDecimal offset;

    public BitflyerParentOrderParameter(String productCode, BitflyerParentOrderConditionType conditionType, BitflyerSide side, BigDecimal price, BigDecimal triggerPrice, BigDecimal size, BigDecimal offset) {
        this.productCode = productCode;
        this.conditionType = conditionType;
        this.side = side;
        this.price = price != null ? price.setScale(2, RoundingMode.HALF_EVEN) : null;
        this.triggerPrice = triggerPrice != null ? triggerPrice.setScale(2, RoundingMode.HALF_EVEN) : null;
        this.size = size != null ? size.setScale(8, RoundingMode.HALF_EVEN) : null;
        this.offset = offset != null ? offset.setScale(2, RoundingMode.HALF_EVEN) : null;
    }

    @JsonProperty(value="product_code")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @JsonProperty(value="condition_type")
    public BitflyerParentOrderConditionType getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(BitflyerParentOrderConditionType conditionType) {
        this.conditionType = conditionType;
    }

    @JsonProperty(value="side")
    public BitflyerSide getSide() {
        return this.side;
    }

    public void setSide(BitflyerSide side) {
        this.side = side;
    }

    @JsonProperty(value="price")
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @JsonProperty(value="trigger_price")
    public BigDecimal getTriggerPrice() {
        return this.triggerPrice;
    }

    public void setTriggerPrice(BigDecimal triggerPrice) {
        this.triggerPrice = triggerPrice;
    }

    @JsonProperty(value="size")
    public BigDecimal getSize() {
        return this.size;
    }

    public void setSize(BigDecimal size) {
        this.size = size;
    }

    @JsonProperty(value="offset")
    public BigDecimal getOffset() {
        return this.offset;
    }

    public void setOffset(BigDecimal offset) {
        this.offset = offset;
    }

    public String toString() {
        return "BitflyerParentOrderParameter{productCode='" + this.productCode + '\'' + ", conditionType=" + (Object)((Object)this.conditionType) + ", side=" + (Object)((Object)this.side) + ", price=" + this.price + ", triggerPrice=" + this.triggerPrice + ", size=" + this.size + ", offset=" + this.offset + '}';
    }
}

