/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitflyer.dto.BitflyerException;
import org.knowm.xchange.bitflyer.dto.account.BitflyerAddress;
import org.knowm.xchange.bitflyer.dto.account.BitflyerBalance;
import org.knowm.xchange.bitflyer.dto.account.BitflyerBankAccount;
import org.knowm.xchange.bitflyer.dto.account.BitflyerCoinHistory;
import org.knowm.xchange.bitflyer.dto.account.BitflyerDepositOrWithdrawal;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarginAccount;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarginStatus;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarginTransaction;
import org.knowm.xchange.bitflyer.dto.account.BitflyerWithdrawRequest;
import org.knowm.xchange.bitflyer.dto.account.BitflyerWithdrawResponse;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerTradingCommission;
import org.knowm.xchange.bitflyer.service.BitflyerBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitflyerAccountServiceRaw
extends BitflyerBaseService {
    public BitflyerAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<String> getPermissions() throws IOException {
        try {
            return this.bitflyer.getPermissions(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerAddress> getAddresses() throws IOException {
        try {
            return this.bitflyer.getAddresses(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerCoinHistory> getCoinIns() throws IOException {
        try {
            return this.bitflyer.getCoinIns(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerCoinHistory> getCoinOuts() throws IOException {
        try {
            return this.bitflyer.getCoinOuts(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerBankAccount> getBankAccounts() throws IOException {
        try {
            return this.bitflyer.getBankAccounts(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerDepositOrWithdrawal> getCashDeposits() throws IOException {
        try {
            return this.bitflyer.getCashDeposits(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public BitflyerWithdrawResponse withdrawFunds(String currencyCode, String bankAccountID, BigDecimal amount) throws IOException {
        try {
            return this.bitflyer.withdrawFunds(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator, new BitflyerWithdrawRequest(currencyCode, bankAccountID, amount));
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerDepositOrWithdrawal> getWithdrawals() throws IOException {
        try {
            return this.bitflyer.getWithdrawals(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public BitflyerMarginStatus getBitflyerMarginStatus() throws IOException {
        try {
            return this.bitflyer.getMarginStatus(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerMarginAccount> getBitflyerMarginAccounts() throws IOException {
        try {
            return this.bitflyer.getMarginAccounts(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerBalance> getBitflyerBalances() throws IOException {
        try {
            return this.bitflyer.getBalances(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public List<BitflyerMarginTransaction> getBitflyerMarginHistory() throws IOException {
        try {
            return this.bitflyer.getMarginHistory(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }

    public BitflyerTradingCommission getTradingCommission(String productCode) throws IOException {
        try {
            return this.bitflyer.getTradingCommission(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator, productCode);
        }
        catch (BitflyerException e) {
            throw this.handleError(e);
        }
    }
}

