/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.service;

import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class BitflyerDigest
extends BaseParamsDigest {
    private String apiKey;

    private BitflyerDigest(String secretKeyBase64, String apiKey) {
        super(secretKeyBase64, "HmacSHA256");
        this.apiKey = apiKey;
    }

    public static BitflyerDigest createInstance(String secretKeyBase64, String apiKey) {
        return secretKeyBase64 == null ? null : new BitflyerDigest(secretKeyBase64, apiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        String queryString = restInvocation.getQueryString();
        String httpMethod = restInvocation.getHttpMethod();
        String uri = restInvocation.getPath();
        if (queryString != null && queryString.length() > 0) {
            uri = uri + "?" + restInvocation.getQueryString();
        }
        String requestBody = restInvocation.getRequestBody();
        String nonce = (String)restInvocation.getHttpHeadersFromParams().get("ACCESS-TIMESTAMP");
        String hmac_data = String.format("%s%s%s%s", nonce, httpMethod, uri, requestBody);
        Mac mac256 = this.getMac();
        mac256.update(hmac_data.getBytes());
        return DigestUtils.bytesToHex((byte[])mac256.doFinal()).trim();
    }
}

