/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.service;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitflyer.BitflyerAdapters;
import org.knowm.xchange.bitflyer.dto.marketdata.BitflyerOrderbook;
import org.knowm.xchange.bitflyer.dto.marketdata.BitflyerTicker;
import org.knowm.xchange.bitflyer.service.BitflyerMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitflyerMarketDataService
extends BitflyerMarketDataServiceRaw
implements MarketDataService {
    public BitflyerMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        BitflyerTicker ticker = this.getTicker(currencyPair.base + "_" + currencyPair.counter);
        return BitflyerAdapters.adaptTicker(ticker, currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        BitflyerOrderbook orderbook = this.getOrderbook(currencyPair.base + "_" + currencyPair.counter);
        List bids = orderbook.getBids().stream().map(e -> new LimitOrder(Order.OrderType.BID, e.getSize(), currencyPair, null, null, e.getPrice())).collect(Collectors.toList());
        List asks = orderbook.getAsks().stream().map(e -> new LimitOrder(Order.OrderType.ASK, e.getSize(), currencyPair, null, null, e.getPrice())).collect(Collectors.toList());
        return new OrderBook(null, asks, bids);
    }
}

