/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.knowm.xchange.bitflyer.BitflyerUtils;
import org.knowm.xchange.bitflyer.dto.account.BitflyerBalance;
import org.knowm.xchange.bitflyer.dto.account.BitflyerCoinHistory;
import org.knowm.xchange.bitflyer.dto.account.BitflyerDepositOrWithdrawal;
import org.knowm.xchange.bitflyer.dto.account.BitflyerMarket;
import org.knowm.xchange.bitflyer.dto.marketdata.BitflyerTicker;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerChildOrderAcceptance;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerParentOrderAcceptance;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerQueryChildOrderResult;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerTradingCommission;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.instrument.Instrument;

public class BitflyerAdapters {
    private static Pattern CURRENCY_PATTERN = Pattern.compile("[A-Z]{3}");

    public static ExchangeMetaData adaptMetaData(List<BitflyerMarket> markets) {
        HashMap<CurrencyPair, Object> currencyPairs = new HashMap<CurrencyPair, Object>();
        HashMap currencies = new HashMap();
        for (BitflyerMarket market : markets) {
            CurrencyPair pair = BitflyerAdapters.adaptCurrencyPair(market.getProductCode());
            currencyPairs.put(pair, null);
        }
        return new ExchangeMetaData(currencyPairs, currencies, null, null, Boolean.valueOf(false));
    }

    public static CurrencyPair adaptCurrencyPair(String productCode) {
        Matcher matcher = CURRENCY_PATTERN.matcher(productCode);
        ArrayList<String> currencies = new ArrayList<String>();
        while (matcher.find()) {
            currencies.add(matcher.group());
        }
        return currencies.size() >= 2 ? new CurrencyPair((String)currencies.get(0), (String)currencies.get(1)) : null;
    }

    public static Wallet adaptAccountInfo(List<BitflyerBalance> balances) {
        ArrayList<Balance> adaptedBalances = new ArrayList<Balance>(balances.size());
        for (BitflyerBalance balance : balances) {
            adaptedBalances.add(new Balance(Currency.getInstance((String)balance.getCurrencyCode()), balance.getAmount(), balance.getAvailable()));
        }
        return Wallet.Builder.from(adaptedBalances).build();
    }

    public static Ticker adaptTicker(BitflyerTicker ticker, CurrencyPair currencyPair) {
        BigDecimal bid = ticker.getBestBid();
        BigDecimal ask = ticker.getBestAsk();
        BigDecimal volume = ticker.getVolume();
        BigDecimal last = ticker.getLtp();
        Date timestamp = ticker.getTimestamp() != null ? BitflyerUtils.parseDate(ticker.getTimestamp()) : null;
        return new Ticker.Builder().currencyPair(currencyPair).bid(bid).ask(ask).last(ask).volume(volume).timestamp(timestamp).build();
    }

    public static List<FundingRecord> adaptFundingRecordsFromCoinHistory(List<BitflyerCoinHistory> coinHistory, FundingRecord.Type type) {
        ArrayList<FundingRecord> retVal = new ArrayList<FundingRecord>();
        for (BitflyerCoinHistory history : coinHistory) {
            retVal.add(BitflyerAdapters.adaptFundingRecord(history, type));
        }
        return retVal;
    }

    public static List<FundingRecord> adaptFundingRecordsFromDepositHistory(List<BitflyerDepositOrWithdrawal> depositWithdrawls, FundingRecord.Type type) {
        ArrayList<FundingRecord> retVal = new ArrayList<FundingRecord>();
        for (BitflyerDepositOrWithdrawal history : depositWithdrawls) {
            retVal.add(BitflyerAdapters.adaptFundingRecord(history, type));
        }
        return retVal;
    }

    public static FundingRecord adaptFundingRecord(BitflyerCoinHistory history, FundingRecord.Type type) {
        return new FundingRecord.Builder().setDate(BitflyerUtils.parseDate(history.getEventDate())).setCurrency(new Currency(history.getCurrencyCode())).setAmount(history.getAmount()).setAddress(history.getAddress()).setInternalId(history.getID()).setType(type).setStatus(BitflyerAdapters.adaptStatus(history.getStatus())).setBalance(history.getAmount()).setFee(BitflyerAdapters.add(history.getFee(), history.getAdditionalFee())).build();
    }

    public static FundingRecord adaptFundingRecord(BitflyerDepositOrWithdrawal history, FundingRecord.Type type) {
        return new FundingRecord.Builder().setDate(BitflyerUtils.parseDate(history.getEventDate())).setCurrency(new Currency(history.getCurrencyCode())).setAmount(history.getAmount()).setInternalId(history.getID()).setType(type).setStatus(BitflyerAdapters.adaptStatus(history.getStatus())).setBalance(history.getAmount()).build();
    }

    public static OpenOrders adaptOpenOrdersFromChildOrderResults(List<BitflyerQueryChildOrderResult> queryResults) {
        return new OpenOrders(queryResults.stream().map(result -> new LimitOrder.Builder(BitflyerAdapters.adaptSide(result.getSide()), (Instrument)new CurrencyPair(result.getProductCode().replace("_", "/"))).id(result.getChildOrderId()).orderStatus(BitflyerAdapters.adaptOrderStatus(result.getChildOrderState())).timestamp(BitflyerUtils.parseDate(result.getChildOrderDate())).limitPrice(result.getPrice()).averagePrice(result.getAveragePrice()).originalAmount(result.getSize()).remainingAmount(result.getOutstandingSize()).cumulativeAmount(result.getExecutedSize()).fee(result.getTotalCommission()).build()).collect(Collectors.toList()));
    }

    public static Fee adaptTradingCommission(BitflyerTradingCommission commission) {
        return new Fee(commission.getCommissionRate(), commission.getCommissionRate());
    }

    public static String adaptOrderId(BitflyerChildOrderAcceptance orderAcceptance) {
        return orderAcceptance.getChildOrderAcceptanceId();
    }

    public static String adaptOrderId(BitflyerParentOrderAcceptance orderAcceptance) {
        return orderAcceptance.getParentOrderAcceptanceId();
    }

    private static Order.OrderType adaptSide(String side) {
        return "BUY".equals(side) ? Order.OrderType.ASK : Order.OrderType.BID;
    }

    private static Order.OrderStatus adaptOrderStatus(String status) {
        if ("ACTIVE".equals(status)) {
            return Order.OrderStatus.NEW;
        }
        if ("COMPLETED".equals(status)) {
            return Order.OrderStatus.FILLED;
        }
        if ("CANCELED".equals(status)) {
            return Order.OrderStatus.CANCELED;
        }
        if ("EXPIRED".equals(status)) {
            return Order.OrderStatus.EXPIRED;
        }
        if ("REJECTED".equals(status)) {
            return Order.OrderStatus.REJECTED;
        }
        return Order.OrderStatus.UNKNOWN;
    }

    private static FundingRecord.Status adaptStatus(String status) {
        if (status.equals("COMPLETED")) {
            return FundingRecord.Status.COMPLETE;
        }
        if (status.equals("PENDING")) {
            return FundingRecord.Status.PROCESSING;
        }
        return FundingRecord.Status.FAILED;
    }

    private static BigDecimal add(BigDecimal a, BigDecimal b) {
        BigDecimal a1 = a == null ? BigDecimal.ZERO : a;
        BigDecimal b1 = b == null ? BigDecimal.ZERO : b;
        return a1.add(b1);
    }

    public static void main(String[] args) {
        BitflyerAdapters.adaptCurrencyPair("BTC_JPY");
        BitflyerAdapters.adaptCurrencyPair("BTCJPY22DEC2017");
        BitflyerAdapters.adaptCurrencyPair("FX_BTC_JPY");
    }
}

