/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;

public class BitflyerUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat DATE_FORMAT_SHORT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private BitflyerUtils() {
    }

    public static Date parseDate(String date) {
        if (date.contains(".")) {
            return BitflyerUtils.parseLongDate(date);
        }
        return BitflyerUtils.parseShortDate(date);
    }

    private static Date parseLongDate(String date) {
        try {
            SimpleDateFormat threadSafeClone = (SimpleDateFormat)DATE_FORMAT.clone();
            return threadSafeClone.parse(date);
        }
        catch (ParseException e) {
            throw new ExchangeException("Illegal date/time format: " + date, (Throwable)e);
        }
    }

    private static Date parseShortDate(String date) {
        try {
            SimpleDateFormat threadSafeClone = (SimpleDateFormat)DATE_FORMAT_SHORT.clone();
            return threadSafeClone.parse(date);
        }
        catch (ParseException e) {
            throw new ExchangeException("Illegal date/time format: " + date, (Throwable)e);
        }
    }

    public static String bitflyerProductCode(CurrencyPair pair) {
        return pair.toString().replace("/", "_");
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

