/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.knowm.xchange.bitflyer.BitflyerUtils;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerChildOrderType;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerSide;
import org.knowm.xchange.bitflyer.dto.trade.BitflyerTimeInForce;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitflyerChildOrder {
    private static final int CURRENCY_SCALE = 2;
    private static final int SIZE_SCALE = 8;
    private String productCode;
    private BitflyerChildOrderType childOrderType;
    private BitflyerSide side;
    private BigDecimal price;
    private BigDecimal size;
    private Long minuteToExpire;
    private BitflyerTimeInForce timeInForce;

    public BitflyerChildOrder(String productCode, BitflyerChildOrderType childOrderType, BitflyerSide side, BigDecimal price, BigDecimal size, Long minuteToExpire, BitflyerTimeInForce timeInForce) {
        this.productCode = productCode;
        this.childOrderType = childOrderType;
        this.side = side;
        this.price = price != null ? price.setScale(2, RoundingMode.HALF_EVEN) : null;
        this.size = size != null ? size.setScale(8, RoundingMode.HALF_EVEN) : null;
        this.minuteToExpire = minuteToExpire;
        this.timeInForce = timeInForce;
    }

    public static BitflyerChildOrderBuilder getOrderBuilder() {
        return new BitflyerChildOrderBuilder();
    }

    @JsonProperty(value="product_code")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @JsonProperty(value="child_order_type")
    public BitflyerChildOrderType getChildOrderType() {
        return this.childOrderType;
    }

    public void setChildOrderType(BitflyerChildOrderType childOrderType) {
        this.childOrderType = childOrderType;
    }

    @JsonProperty(value="side")
    public BitflyerSide getSide() {
        return this.side;
    }

    public void setSide(BitflyerSide side) {
        this.side = side;
    }

    @JsonProperty(value="price")
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @JsonProperty(value="size")
    public BigDecimal getSize() {
        return this.size;
    }

    public void setSize(BigDecimal size) {
        this.size = size;
    }

    @JsonProperty(value="minute_to_expire")
    public Long getMinuteToExpire() {
        return this.minuteToExpire;
    }

    public void setMinuteToExpire(Long minuteToExpire) {
        this.minuteToExpire = minuteToExpire;
    }

    @JsonProperty(value="time_in_force")
    public BitflyerTimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public void setTimeInForce(BitflyerTimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    public String toString() {
        return "BitflyerChildOrder{productCode='" + this.productCode + '\'' + ", childOrderType=" + (Object)((Object)this.childOrderType) + ", side=" + (Object)((Object)this.side) + ", price=" + this.price + ", size=" + this.size + ", minuteToExpire=" + this.minuteToExpire + ", timeInForce=" + (Object)((Object)this.timeInForce) + '}';
    }

    public static class BitflyerChildOrderBuilder {
        private CurrencyPair currencyPair;
        private BitflyerChildOrderType childOrderType;
        private BitflyerSide side;
        private BigDecimal price;
        private BigDecimal size;
        private Long minuteToExpire = null;
        private BitflyerTimeInForce timeInForce = BitflyerTimeInForce.GTC;

        public BitflyerChildOrderBuilder withProductCode(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public BitflyerChildOrderBuilder withChildOrderType(BitflyerChildOrderType childOrderType) {
            this.childOrderType = childOrderType;
            return this;
        }

        public BitflyerChildOrderBuilder withSide(Order.OrderType orderType) {
            this.side = BitflyerSide.fromOrderType(orderType);
            return this;
        }

        public BitflyerChildOrderBuilder withPrice(BigDecimal price) {
            this.price = price;
            return this;
        }

        public BitflyerChildOrderBuilder withSize(BigDecimal size) {
            this.size = size;
            return this;
        }

        public BitflyerChildOrderBuilder withMinuteToExpire(Long minuteToExpire) {
            this.minuteToExpire = minuteToExpire;
            return this;
        }

        public BitflyerChildOrderBuilder withTimeInForce(BitflyerTimeInForce timeInForce) {
            this.timeInForce = timeInForce;
            return this;
        }

        public BitflyerChildOrder buildOrder() {
            return new BitflyerChildOrder(BitflyerUtils.bitflyerProductCode(this.currencyPair), this.childOrderType, this.side, this.price, this.size, this.minuteToExpire, this.timeInForce);
        }
    }
}

