/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitflyer.BitflyerAdapters;
import org.knowm.xchange.bitflyer.BitflyerUtils;
import org.knowm.xchange.bitflyer.dto.BitflyerException;
import org.knowm.xchange.bitflyer.dto.account.BitflyerAddress;
import org.knowm.xchange.bitflyer.dto.account.BitflyerCoinHistory;
import org.knowm.xchange.bitflyer.dto.account.BitflyerDepositOrWithdrawal;
import org.knowm.xchange.bitflyer.dto.trade.results.BitflyerTradingCommission;
import org.knowm.xchange.bitflyer.service.BitflyerAccountServiceRaw;
import org.knowm.xchange.bitflyer.service.BitflyerTradeHistoryParams;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitflyerAccountService
extends BitflyerAccountServiceRaw
implements AccountService {
    private static final Logger LOG = LoggerFactory.getLogger(BitflyerAccountService.class);

    public BitflyerAccountService(Exchange exchange) {
        super(exchange);
    }

    public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        HashMap<CurrencyPair, Fee> tradingFees = new HashMap<CurrencyPair, Fee>();
        List pairs = this.exchange.getExchangeSymbols();
        pairs.forEach(pair -> {
            try {
                BitflyerTradingCommission commission = this.getTradingCommission(BitflyerUtils.bitflyerProductCode(pair));
                tradingFees.put((CurrencyPair)pair, BitflyerAdapters.adaptTradingCommission(commission));
            }
            catch (IOException | BitflyerException | ExchangeException e) {
                LOG.trace("Exception fetching trade commission for {}", pair, (Object)e);
            }
        });
        return tradingFees;
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{BitflyerAdapters.adaptAccountInfo(this.getBitflyerBalances())});
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        List<BitflyerAddress> addresses = this.getAddresses();
        for (BitflyerAddress address : addresses) {
            if (!address.getCurrencyCode().equals(currency.getCurrencyCode())) continue;
            return address.getAddress();
        }
        throw new NotAvailableFromExchangeException();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BitflyerTradeHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams param) throws IOException {
        BitflyerTradeHistoryParams historyParms = (BitflyerTradeHistoryParams)(param instanceof BitflyerTradeHistoryParams ? this.createFundingHistoryParams() : param);
        List<BitflyerCoinHistory> coinsIn = this.getCoinIns();
        List<BitflyerCoinHistory> coinsOut = this.getCoinOuts();
        List<BitflyerDepositOrWithdrawal> cashDeposits = this.getCashDeposits();
        List<BitflyerDepositOrWithdrawal> withdrawals = this.getWithdrawals();
        ArrayList<FundingRecord> retVal = new ArrayList<FundingRecord>();
        List<FundingRecord> some = BitflyerAdapters.adaptFundingRecordsFromCoinHistory(coinsIn, FundingRecord.Type.DEPOSIT);
        this.cullNotWanted(some, historyParms);
        retVal.addAll(some);
        some = BitflyerAdapters.adaptFundingRecordsFromCoinHistory(coinsOut, FundingRecord.Type.WITHDRAWAL);
        this.cullNotWanted(some, historyParms);
        retVal.addAll(some);
        some = BitflyerAdapters.adaptFundingRecordsFromDepositHistory(cashDeposits, FundingRecord.Type.DEPOSIT);
        this.cullNotWanted(some, historyParms);
        retVal.addAll(some);
        some = BitflyerAdapters.adaptFundingRecordsFromDepositHistory(withdrawals, FundingRecord.Type.WITHDRAWAL);
        this.cullNotWanted(some, historyParms);
        retVal.addAll(some);
        Collections.sort(retVal, (r1, r2) -> r2.getDate().compareTo(r1.getDate()));
        return retVal;
    }

    private void cullNotWanted(List<FundingRecord> some, BitflyerTradeHistoryParams param) {
        if (param != null && param.getCurrencies() != null) {
            Iterator<FundingRecord> iter = some.iterator();
            while (iter.hasNext()) {
                FundingRecord record = iter.next();
                if (this.isIn(record.getCurrency(), param.getCurrencies())) continue;
                iter.remove();
            }
        }
    }

    private boolean isIn(Currency currency, Currency[] currencies) {
        for (Currency cur : currencies) {
            if (!cur.equals((Object)currency)) continue;
            return true;
        }
        return false;
    }
}

