/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitflyer.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitflyer.Bitflyer;
import org.knowm.xchange.bitflyer.dto.BitflyerException;
import org.knowm.xchange.bitflyer.service.BitflyerDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import org.knowm.xchange.exceptions.InternalServerException;
import org.knowm.xchange.exceptions.RateLimitExceededException;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ParamsDigest;

public class BitflyerBaseService
extends BaseExchangeService
implements BaseService {
    protected final String apiKey;
    protected final Bitflyer bitflyer;
    protected final ParamsDigest signatureCreator;

    public BitflyerBaseService(Exchange exchange) {
        super(exchange);
        this.bitflyer = (Bitflyer)ExchangeRestProxyBuilder.forInterface(Bitflyer.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = BitflyerDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getApiKey());
    }

    protected ExchangeException handleError(BitflyerException exception) {
        if (exception.getMessage().contains("Insufficient")) {
            return new FundsExceededException((Throwable)exception);
        }
        if (exception.getMessage().contains("Rate limit exceeded")) {
            return new RateLimitExceededException((Throwable)exception);
        }
        if (exception.getMessage().contains("Internal server error")) {
            return new InternalServerException((Throwable)exception);
        }
        return new ExchangeException((Throwable)exception);
    }
}

