/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.trade;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.bitstamp.BitstampUtils;
import org.knowm.xchange.bitstamp.dto.trade.BitstampErrorDeserializer;
import si.mazi.rescu.ExceptionalReturnContentException;

public final class BitstampOrder {
    private long id;
    private Date datetime;
    private int type;
    private BigDecimal price;
    private BigDecimal amount;
    private String currencyPair;
    private String errorMessage;

    public BitstampOrder(@JsonProperty(value="status") String status, @JsonProperty(value="reason") Object reason, @JsonProperty(value="id") long id, @JsonProperty(value="datetime") String datetime, @JsonProperty(value="type") int type, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency_pair") String currencyPair, @JsonProperty(value="error") @JsonDeserialize(using=BitstampErrorDeserializer.class) String errorMessage) {
        if ("error".equals(status)) {
            throw new ExceptionalReturnContentException(String.valueOf(reason));
        }
        this.id = id;
        this.datetime = BitstampUtils.parseDate(datetime);
        this.type = type;
        this.price = price;
        this.amount = amount;
        this.currencyPair = currencyPair;
        this.errorMessage = errorMessage;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public long getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    @JsonIgnore
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.errorMessage != null ? this.errorMessage : String.format("Order{id=%s, datetime=%s, type=%s, price=%s, amount=%s, currencyPair=%s}", this.id, this.datetime, this.type, this.price, this.amount, this.currencyPair);
    }
}

