/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.BitstampAdapters;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampWithdrawal;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampAccountServiceRaw;
import org.knowm.xchange.bitstamp.service.BitstampTradeHistoryParams;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;
import org.knowm.xchange.utils.DateUtils;

public class BitstampAccountService
extends BitstampAccountServiceRaw
implements AccountService {
    public BitstampAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return BitstampAdapters.adaptAccountInfo(this.getBitstampBalance(), this.exchange.getExchangeSpecification().getUserName());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (params instanceof RippleWithdrawFundsParams) {
            RippleWithdrawFundsParams rippleWithdrawFundsParams = (RippleWithdrawFundsParams)params;
            BitstampWithdrawal response = this.withdrawRippleFunds(rippleWithdrawFundsParams.getAmount(), rippleWithdrawFundsParams.getAddress(), rippleWithdrawFundsParams.getTag());
            if (response.error != null) {
                throw new ExchangeException("Failed to withdraw: " + response.error);
            }
            if (response.getId() == null) {
                return null;
            }
            return Long.toString(response.getId());
        }
        if (params instanceof DefaultWithdrawFundsParams) {
            BitstampWithdrawal response;
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            if (defaultParams.getCurrency().equals((Object)Currency.LTC)) {
                response = this.withdrawLtcFunds(defaultParams.getAmount(), defaultParams.getAddress());
            } else if (defaultParams.getCurrency().equals((Object)Currency.ETH)) {
                response = this.withdrawEthFunds(defaultParams.getAmount(), defaultParams.getAddress());
            } else if (defaultParams.getCurrency().equals((Object)Currency.BTC)) {
                response = this.withdrawBtcFunds(defaultParams.getAmount(), defaultParams.getAddress());
            } else if (defaultParams.getCurrency().equals((Object)Currency.BCH)) {
                response = this.withdrawBchFunds(defaultParams.getAmount(), defaultParams.getAddress());
            } else {
                throw new IllegalStateException("Cannot withdraw " + defaultParams.getCurrency());
            }
            if (response.error != null) {
                throw new ExchangeException("Failed to withdraw: " + response.error);
            }
            if (response.getId() == null) {
                return null;
            }
            return Long.toString(response.getId());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        if (currency.equals((Object)Currency.BTC)) {
            return this.getBitstampBitcoinDepositAddress().getDepositAddress();
        }
        if (currency.equals((Object)Currency.LTC)) {
            return this.getBitstampLitecoinDepositAddress().getDepositAddress();
        }
        if (currency.equals((Object)Currency.XRP)) {
            return this.getRippleDepositAddress().getAddressAndDt();
        }
        if (currency.equals((Object)Currency.BCH)) {
            return this.getBitstampBitcoinCashDepositAddress().getDepositAddress();
        }
        if (currency.equals((Object)Currency.ETH)) {
            return this.getBitstampEthereumDepositAddress().getDepositAddress();
        }
        throw new IllegalStateException("Unsupported currency " + currency);
    }

    public BitstampDepositAddress requestDepositAddressObject(Currency currency, String ... arguments) throws IOException {
        if (currency.equals((Object)Currency.BTC)) {
            return this.getBitstampBitcoinDepositAddress();
        }
        if (currency.equals((Object)Currency.LTC)) {
            return this.getBitstampLitecoinDepositAddress();
        }
        if (currency.equals((Object)Currency.XRP)) {
            return this.getRippleDepositAddress();
        }
        if (currency.equals((Object)Currency.BCH)) {
            return this.getBitstampBitcoinCashDepositAddress();
        }
        if (currency.equals((Object)Currency.ETH)) {
            return this.getBitstampEthereumDepositAddress();
        }
        throw new IllegalStateException("Unsupported currency " + currency);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BitstampTradeHistoryParams(null, 1000);
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        Long limit = null;
        Object currencyPair = null;
        Long offset = null;
        TradeHistoryParamsSorted.Order sort = null;
        Long sinceTimestamp = null;
        if (params instanceof TradeHistoryParamPaging) {
            limit = (long)((TradeHistoryParamPaging)params).getPageLength();
        }
        if (params instanceof TradeHistoryParamOffset) {
            offset = ((TradeHistoryParamOffset)params).getOffset();
        }
        if (params instanceof TradeHistoryParamsSorted) {
            sort = ((TradeHistoryParamsSorted)params).getOrder();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            sinceTimestamp = DateUtils.toUnixTimeNullSafe((Date)((TradeHistoryParamsTimeSpan)params).getStartTime());
        }
        BitstampUserTransaction[] txs = this.getBitstampUserTransactions(limit, offset, sort == null ? null : sort.toString(), sinceTimestamp);
        return BitstampAdapters.adaptFundingHistory(Arrays.asList(txs));
    }
}

