/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.dto.account.BittrexDepositHistory;
import org.knowm.xchange.bittrex.dto.account.BittrexWithdrawalHistory;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexLevel;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexMarketSummary;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.dto.trade.BittrexOpenOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrderBase;
import org.knowm.xchange.bittrex.dto.trade.BittrexUserTrade;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BittrexAdapters {
    public static final Logger log = LoggerFactory.getLogger(BittrexAdapters.class);

    private BittrexAdapters() {
    }

    public static List<CurrencyPair> adaptCurrencyPairs(Collection<BittrexSymbol> bittrexSymbol) {
        ArrayList<CurrencyPair> currencyPairs = new ArrayList<CurrencyPair>();
        for (BittrexSymbol symbol : bittrexSymbol) {
            currencyPairs.add(BittrexAdapters.adaptCurrencyPair(symbol));
        }
        return currencyPairs;
    }

    public static CurrencyPair adaptCurrencyPair(BittrexSymbol bittrexSymbol) {
        String baseSymbol = bittrexSymbol.getMarketCurrency();
        String counterSymbol = bittrexSymbol.getBaseCurrency();
        return new CurrencyPair(baseSymbol, counterSymbol);
    }

    public static List<LimitOrder> adaptOpenOrders(List<BittrexOpenOrder> bittrexOpenOrders) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (BittrexOpenOrder order : bittrexOpenOrders) {
            openOrders.add(BittrexAdapters.adaptOrder(order));
        }
        return openOrders;
    }

    public static LimitOrder adaptOrder(BittrexOrderBase order, Order.OrderStatus status) {
        Order.OrderType type = order.getOrderType().equalsIgnoreCase("LIMIT_SELL") ? Order.OrderType.ASK : Order.OrderType.BID;
        String[] currencies = order.getExchange().split("-");
        CurrencyPair pair = new CurrencyPair(currencies[1], currencies[0]);
        return new LimitOrder.Builder(type, pair).originalAmount(order.getQuantity()).id(order.getOrderUuid()).timestamp(order.getOpened()).limitPrice(order.getLimit()).averagePrice(order.getPricePerUnit()).cumulativeAmount(order.getQuantityRemaining() == null ? null : order.getQuantity().subtract(order.getQuantityRemaining())).fee(order.getCommissionPaid()).orderStatus(status).build();
    }

    public static List<LimitOrder> adaptOrders(BittrexLevel[] orders, CurrencyPair currencyPair, String orderType, String id, int depth) {
        if (orders == null) {
            return new ArrayList<LimitOrder>();
        }
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(orders.length);
        for (int i = 0; i < Math.min(orders.length, depth); ++i) {
            BittrexLevel order = orders[i];
            limitOrders.add(BittrexAdapters.adaptOrder(order.getAmount(), order.getPrice(), currencyPair, orderType, id));
        }
        return limitOrders;
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, CurrencyPair currencyPair, String orderTypeString, String id) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new LimitOrder(orderType, amount, currencyPair, id, null, price);
    }

    public static LimitOrder adaptOrder(BittrexOrder order) {
        return BittrexAdapters.adaptOrder(order, BittrexAdapters.adaptOrderStatus(order));
    }

    public static LimitOrder adaptOrder(BittrexOpenOrder order) {
        return BittrexAdapters.adaptOrder(order, BittrexAdapters.adaptOrderStatus(order));
    }

    private static Order.OrderStatus adaptOrderStatus(BittrexOrder order) {
        Order.OrderStatus status = Order.OrderStatus.NEW;
        BigDecimal qty = order.getQuantity();
        BigDecimal qtyRem = order.getQuantityRemaining() != null ? order.getQuantityRemaining() : order.getQuantity();
        Boolean isOpen = order.getOpen();
        Boolean isCancelling = order.getCancelInitiated();
        int qtyRemainingToQty = qtyRem.compareTo(qty);
        int qtyRemainingIsZero = qtyRem.compareTo(BigDecimal.ZERO);
        if (isOpen.booleanValue() && !isCancelling.booleanValue() && qtyRemainingToQty < 0) {
            status = Order.OrderStatus.PARTIALLY_FILLED;
        } else if (!isOpen.booleanValue() && !isCancelling.booleanValue() && qtyRemainingIsZero <= 0) {
            status = Order.OrderStatus.FILLED;
        } else if (isOpen.booleanValue() && isCancelling.booleanValue()) {
            status = Order.OrderStatus.PENDING_CANCEL;
        } else if (!isOpen.booleanValue() && isCancelling.booleanValue()) {
            status = Order.OrderStatus.CANCELED;
        }
        return status;
    }

    private static Order.OrderStatus adaptOrderStatus(BittrexOpenOrder order) {
        Order.OrderStatus status = Order.OrderStatus.NEW;
        BigDecimal qty = order.getQuantity();
        BigDecimal qtyRem = order.getQuantityRemaining() != null ? order.getQuantityRemaining() : order.getQuantity();
        Boolean isCancelling = order.getCancelInitiated();
        int qtyRemainingToQty = qtyRem.compareTo(qty);
        if (!isCancelling.booleanValue() && qtyRemainingToQty < 0) {
            status = Order.OrderStatus.PARTIALLY_FILLED;
        } else if (isCancelling.booleanValue()) {
            status = Order.OrderStatus.PENDING_CANCEL;
        }
        return status;
    }

    public static Trade adaptTrade(BittrexTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = trade.getOrderType().equalsIgnoreCase("BUY") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getQuantity();
        BigDecimal price = trade.getPrice();
        Date date = BittrexUtils.toDate(trade.getTimeStamp());
        String tradeId = String.valueOf(trade.getId());
        return new Trade.Builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(date).id(tradeId).build();
    }

    public static Trades adaptTrades(List<BittrexTrade> trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.size());
        long lastTradeId = 0L;
        for (BittrexTrade trade : trades) {
            long tradeId = Long.valueOf(trade.getId());
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(BittrexAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Ticker adaptTicker(BittrexMarketSummary marketSummary, CurrencyPair currencyPair) {
        BigDecimal last = marketSummary.getLast();
        BigDecimal bid = marketSummary.getBid();
        BigDecimal ask = marketSummary.getAsk();
        BigDecimal high = marketSummary.getHigh();
        BigDecimal low = marketSummary.getLow();
        BigDecimal volume = marketSummary.getVolume();
        Date timestamp = BittrexUtils.toDate(marketSummary.getTimeStamp());
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }

    protected static BigDecimal calculateFrozenBalance(BittrexBalance balance) {
        if (balance.getBalance() == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal[] frozenBalance = new BigDecimal[]{balance.getBalance()};
        Optional.ofNullable(balance.getAvailable()).ifPresent(available -> {
            frozenBalance[0] = frozenBalance[0].subtract((BigDecimal)available);
        });
        Optional.ofNullable(balance.getPending()).ifPresent(pending -> {
            frozenBalance[0] = frozenBalance[0].subtract((BigDecimal)pending);
        });
        return frozenBalance[0];
    }

    public static Wallet adaptWallet(List<BittrexBalance> balances) {
        ArrayList<Balance> wallets = new ArrayList<Balance>(balances.size());
        for (BittrexBalance balance : balances) {
            wallets.add(new Balance(Currency.getInstance((String)balance.getCurrency().toUpperCase()), Optional.ofNullable(balance.getBalance()).orElse(BigDecimal.ZERO), Optional.ofNullable(balance.getAvailable()).orElse(BigDecimal.ZERO), BittrexAdapters.calculateFrozenBalance(balance), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Optional.ofNullable(balance.getPending()).orElse(BigDecimal.ZERO)));
        }
        return Wallet.Builder.from(wallets).build();
    }

    public static Balance adaptBalance(BittrexBalance balance) {
        return new Balance(Currency.getInstance((String)balance.getCurrency().toUpperCase()), Optional.ofNullable(balance.getBalance()).orElse(BigDecimal.ZERO), Optional.ofNullable(balance.getAvailable()).orElse(BigDecimal.ZERO), BittrexAdapters.calculateFrozenBalance(balance), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Optional.ofNullable(balance.getPending()).orElse(BigDecimal.ZERO));
    }

    public static List<UserTrade> adaptUserTrades(List<BittrexUserTrade> bittrexUserTrades) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (BittrexUserTrade bittrexTrade : bittrexUserTrades) {
            if (BittrexAdapters.isOrderWithoutTrade(bittrexTrade)) continue;
            trades.add(BittrexAdapters.adaptUserTrade(bittrexTrade));
        }
        return trades;
    }

    public static UserTrade adaptUserTrade(BittrexUserTrade trade) {
        String[] currencies = trade.getExchange().split("-");
        CurrencyPair currencyPair = new CurrencyPair(currencies[1], currencies[0]);
        Order.OrderType orderType = trade.getOrderType().equalsIgnoreCase("LIMIT_BUY") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getQuantity().subtract(trade.getQuantityRemaining());
        Date date = BittrexUtils.toDate(trade.getClosed());
        String orderId = String.valueOf(trade.getOrderUuid());
        BigDecimal price = trade.getPricePerUnit();
        if (price == null) {
            price = trade.getLimit();
        }
        return new UserTrade.Builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(date).id(orderId).orderId(orderId).feeAmount(trade.getCommission()).feeCurrency(currencyPair.counter).build();
    }

    public static ExchangeMetaData adaptMetaData(List<BittrexSymbol> rawSymbols, ExchangeMetaData metaData) {
        List<CurrencyPair> currencyPairs = BittrexAdapters.adaptCurrencyPairs(rawSymbols);
        Map pairsMap = metaData.getCurrencyPairs();
        Map currenciesMap = metaData.getCurrencies();
        for (CurrencyPair c : currencyPairs) {
            if (!pairsMap.containsKey(c)) {
                pairsMap.put(c, null);
            }
            if (!currenciesMap.containsKey(c.base)) {
                currenciesMap.put(c.base, null);
            }
            if (currenciesMap.containsKey(c.counter)) continue;
            currenciesMap.put(c.counter, null);
        }
        return metaData;
    }

    public static List<FundingRecord> adaptDepositRecords(List<BittrexDepositHistory> bittrexFundingHistories) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (BittrexDepositHistory f : bittrexFundingHistories) {
            if (f == null) continue;
            fundingRecords.add(new FundingRecord(f.getCryptoAddress(), f.getLastUpdated(), Currency.getInstance((String)f.getCurrency()), f.getAmount(), String.valueOf(f.getId()), f.getTxId(), FundingRecord.Type.DEPOSIT, FundingRecord.Status.COMPLETE, null, null, null));
        }
        return fundingRecords;
    }

    private static FundingRecord.Status fromWithdrawalRecord(BittrexWithdrawalHistory bittrexWithdrawal) {
        if (bittrexWithdrawal.getCanceled().booleanValue()) {
            return FundingRecord.Status.CANCELLED;
        }
        if (bittrexWithdrawal.getInvalidAddress().booleanValue()) {
            return FundingRecord.Status.FAILED;
        }
        if (bittrexWithdrawal.getPendingPayment().booleanValue()) {
            return FundingRecord.Status.PROCESSING;
        }
        if (bittrexWithdrawal.getAuthorized().booleanValue()) {
            return FundingRecord.Status.COMPLETE;
        }
        return FundingRecord.Status.FAILED;
    }

    public static List<FundingRecord> adaptWithdrawalRecords(List<BittrexWithdrawalHistory> bittrexFundingHistories) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (BittrexWithdrawalHistory f : bittrexFundingHistories) {
            if (f == null) continue;
            FundingRecord.Status status = BittrexAdapters.fromWithdrawalRecord(f);
            fundingRecords.add(new FundingRecord(f.getAddress(), f.getOpened(), Currency.getInstance((String)f.getCurrency()), f.getAmount(), f.getPaymentUuid(), f.getTxId(), FundingRecord.Type.WITHDRAWAL, status, null, f.getTxCost(), null));
        }
        return fundingRecords;
    }

    private static boolean isOrderWithoutTrade(BittrexUserTrade bittrexTrade) {
        return bittrexTrade.getQuantity().compareTo(bittrexTrade.getQuantityRemaining()) == 0;
    }
}

