/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import org.knowm.xchange.exceptions.RateLimitExceededException;

public class BittrexErrorAdapter {
    public static ExchangeException adapt(BittrexException e) {
        String message = e.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return new ExchangeException("Operation failed without any error message", (Throwable)((Object)e));
        }
        if (message.contains("was throttled")) {
            return new RateLimitExceededException(message, (Throwable)((Object)e));
        }
        switch (message) {
            case "INVALID_MARKET": {
                return new CurrencyPairNotValidException((Throwable)((Object)e));
            }
            case "INSUFFICIENT_FUNDS": {
                return new FundsExceededException((Throwable)((Object)e));
            }
        }
        return new ExchangeException(message, (Throwable)((Object)e));
    }
}

