/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.bittrex.BittrexUtils;

public class BittrexChartData {
    private final Date timeStamp;
    private final BigDecimal open;
    private final BigDecimal close;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal volume;
    private final BigDecimal baseVolume;

    public BittrexChartData(@JsonProperty(value="T") String timeStamp, @JsonProperty(value="O") BigDecimal open, @JsonProperty(value="C") BigDecimal close, @JsonProperty(value="H") BigDecimal high, @JsonProperty(value="L") BigDecimal low, @JsonProperty(value="V") BigDecimal volume, @JsonProperty(value="BV") BigDecimal baseVolume) {
        this.timeStamp = BittrexUtils.toDate(timeStamp);
        this.open = open;
        this.close = close;
        this.high = high;
        this.low = low;
        this.volume = volume;
        this.baseVolume = baseVolume;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getClose() {
        return this.close;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getBaseVolume() {
        return this.baseVolume;
    }

    public String toString() {
        return "BittrexChartData [timeStamp=" + this.timeStamp + ", open=" + this.open + ", close=" + this.close + ", high=" + this.high + ", low=" + this.low + ", volume=" + this.volume + ", baseVolume=" + this.baseVolume + "]";
    }
}

